/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.message.SIPResponse;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.BalancerRunner;
import org.mobicents.tools.sip.balancer.ExtraServerNode;
import org.mobicents.tools.sip.balancer.InvocationContext;
import org.mobicents.tools.sip.balancer.NodeRegister;
import org.mobicents.tools.sip.balancer.NullServerNode;
import org.mobicents.tools.sip.balancer.RouteHeaderHints;
import org.mobicents.tools.sip.balancer.SIPBalancerValveProcessor;
import org.mobicents.tools.sip.balancer.SIPNode;

public class SIPBalancerForwarder
implements SipListener {
    private static final Logger logger = Logger.getLogger((String)SIPBalancerForwarder.class.getCanonicalName());
    public static final String ROUTE_PARAM_NODE_HOST = "node_host";
    public static final String ROUTE_PARAM_NODE_PORT = "node_port";
    public static final String ROUTE_PARAM_NODE_VERSION = "version";
    public static final int UDP = 0;
    public static final int TCP = 1;
    BalancerRunner balancerRunner;
    protected static final HashSet<String> dialogCreationMethods = new HashSet(2);
    public NodeRegister register;
    protected String[] extraServerAddresses;
    protected int[] extraServerPorts;

    public SIPBalancerForwarder(Properties properties, BalancerRunner balancerRunner, NodeRegister register) throws IllegalStateException {
        this.balancerRunner = balancerRunner;
        this.balancerRunner.balancerContext.forwarder = this;
        this.balancerRunner.balancerContext.properties = properties;
        this.register = register;
    }

    public void start() {
        SipFactory sipFactory = null;
        this.balancerRunner.balancerContext.sipStack = null;
        this.balancerRunner.balancerContext.host = this.balancerRunner.balancerContext.properties.getProperty("host");
        this.balancerRunner.balancerContext.internalHost = this.balancerRunner.balancerContext.properties.getProperty("internalHost", this.balancerRunner.balancerContext.host);
        this.balancerRunner.balancerContext.externalHost = this.balancerRunner.balancerContext.properties.getProperty("externalHost", this.balancerRunner.balancerContext.host);
        this.balancerRunner.balancerContext.externalPort = Integer.parseInt(this.balancerRunner.balancerContext.properties.getProperty("externalPort"));
        if (this.balancerRunner.balancerContext.properties.getProperty("internalPort") != null) {
            this.balancerRunner.balancerContext.internalPort = Integer.parseInt(this.balancerRunner.balancerContext.properties.getProperty("internalPort"));
        }
        this.balancerRunner.balancerContext.externalIpLoadBalancerAddress = this.balancerRunner.balancerContext.properties.getProperty("externalIpLoadBalancerAddress");
        this.balancerRunner.balancerContext.internalIpLoadBalancerAddress = this.balancerRunner.balancerContext.properties.getProperty("internalIpLoadBalancerAddress");
        if (this.balancerRunner.balancerContext.properties.getProperty("externalLoadBalancerPort") != null) {
            this.balancerRunner.balancerContext.externalLoadBalancerPort = Integer.parseInt(this.balancerRunner.balancerContext.properties.getProperty("externalLoadBalancerPort"));
        }
        if (this.balancerRunner.balancerContext.properties.getProperty("internalLoadBalancerPort") != null) {
            this.balancerRunner.balancerContext.internalLoadBalancerPort = Integer.parseInt(this.balancerRunner.balancerContext.properties.getProperty("internalLoadBalancerPort"));
        }
        if (this.balancerRunner.balancerContext.properties.getProperty("externalIpLoadBalancerPort") != null) {
            this.balancerRunner.balancerContext.externalLoadBalancerPort = Integer.parseInt(this.balancerRunner.balancerContext.properties.getProperty("externalIpLoadBalancerPort"));
        }
        if (this.balancerRunner.balancerContext.properties.getProperty("internalIpLoadBalancerPort") != null) {
            this.balancerRunner.balancerContext.internalLoadBalancerPort = Integer.parseInt(this.balancerRunner.balancerContext.properties.getProperty("internalIpLoadBalancerPort"));
        }
        if (this.balancerRunner.balancerContext.isTwoEntrypoints() && this.balancerRunner.balancerContext.externalLoadBalancerPort > 0 && this.balancerRunner.balancerContext.internalLoadBalancerPort <= 0) {
            throw new RuntimeException("External IP load balancer specified, but not internal load balancer");
        }
        if (this.balancerRunner.balancerContext.externalIpLoadBalancerAddress != null && this.balancerRunner.balancerContext.externalLoadBalancerPort <= 0) {
            throw new RuntimeException("External load balancer address specified, but not externalLoadBalancerPort");
        }
        if (this.balancerRunner.balancerContext.internalIpLoadBalancerAddress != null && this.balancerRunner.balancerContext.internalLoadBalancerPort <= 0) {
            throw new RuntimeException("Internal load balancer address specified, but not internalLoadBalancerPort");
        }
        String extraServerNodesString = this.balancerRunner.balancerContext.properties.getProperty("extraServerNodes");
        if (extraServerNodesString != null) {
            this.extraServerAddresses = extraServerNodesString.split(",");
            this.extraServerPorts = new int[this.extraServerAddresses.length];
            for (int q = 0; q < this.extraServerAddresses.length; ++q) {
                int indexOfPort = this.extraServerAddresses[q].indexOf(58);
                if (indexOfPort > 0) {
                    this.extraServerPorts[q] = Integer.parseInt(this.extraServerAddresses[q].substring(indexOfPort + 1, this.extraServerAddresses[q].length()));
                    this.extraServerAddresses[q] = this.extraServerAddresses[q].substring(0, indexOfPort);
                    logger.info((Object)("Extra Server: " + this.extraServerAddresses[q] + ":" + this.extraServerPorts[q]));
                    continue;
                }
                this.extraServerPorts[q] = 5060;
            }
        }
        try {
            sipFactory = SipFactory.getInstance();
            sipFactory.setPathName("gov.nist");
            this.balancerRunner.balancerContext.properties.setProperty("gov.nist.javax.sip.SIP_MESSAGE_VALVE", SIPBalancerValveProcessor.class.getName());
            if (this.balancerRunner.balancerContext.properties.getProperty("gov.nist.javax.sip.TCP_POST_PARSING_THREAD_POOL_SIZE") == null) {
                this.balancerRunner.balancerContext.properties.setProperty("gov.nist.javax.sip.TCP_POST_PARSING_THREAD_POOL_SIZE", "100");
            }
            this.balancerRunner.balancerContext.sipStack = sipFactory.createSipStack(this.balancerRunner.balancerContext.properties);
        }
        catch (PeerUnavailableException pue) {
            throw new IllegalStateException("Cant create stack due to[" + pue.getMessage() + "]", pue);
        }
        try {
            Address ipLbAdress;
            SipURI ipLbSipUri;
            this.balancerRunner.balancerContext.headerFactory = sipFactory.createHeaderFactory();
            boolean usePrettyEncoding = Boolean.valueOf(this.balancerRunner.balancerContext.properties.getProperty("usePrettyEncoding", "false"));
            if (usePrettyEncoding) {
                ((HeaderFactoryImpl)this.balancerRunner.balancerContext.headerFactory).setPrettyEncoding(true);
            }
            this.balancerRunner.balancerContext.addressFactory = sipFactory.createAddressFactory();
            this.balancerRunner.balancerContext.messageFactory = sipFactory.createMessageFactory();
            ListeningPoint externalLp = this.balancerRunner.balancerContext.sipStack.createListeningPoint(this.balancerRunner.balancerContext.externalHost, this.balancerRunner.balancerContext.externalPort, "udp");
            ListeningPoint externalLpTcp = this.balancerRunner.balancerContext.sipStack.createListeningPoint(this.balancerRunner.balancerContext.externalHost, this.balancerRunner.balancerContext.externalPort, "tcp");
            this.balancerRunner.balancerContext.externalSipProvider = this.balancerRunner.balancerContext.sipStack.createSipProvider(externalLp);
            this.balancerRunner.balancerContext.externalSipProvider.addListeningPoint(externalLpTcp);
            this.balancerRunner.balancerContext.externalSipProvider.addSipListener((SipListener)this);
            ListeningPoint internalLp = null;
            if (this.balancerRunner.balancerContext.isTwoEntrypoints()) {
                internalLp = this.balancerRunner.balancerContext.sipStack.createListeningPoint(this.balancerRunner.balancerContext.internalHost, this.balancerRunner.balancerContext.internalPort, "udp");
                ListeningPoint internalLpTcp = this.balancerRunner.balancerContext.sipStack.createListeningPoint(this.balancerRunner.balancerContext.internalHost, this.balancerRunner.balancerContext.internalPort, "tcp");
                this.balancerRunner.balancerContext.internalSipProvider = this.balancerRunner.balancerContext.sipStack.createSipProvider(internalLp);
                this.balancerRunner.balancerContext.internalSipProvider.addListeningPoint(internalLpTcp);
                this.balancerRunner.balancerContext.internalSipProvider.addSipListener((SipListener)this);
            }
            SipURI externalLocalUri = this.balancerRunner.balancerContext.addressFactory.createSipURI(null, externalLp.getIPAddress());
            externalLocalUri.setPort(externalLp.getPort());
            externalLocalUri.setTransportParam("udp");
            externalLocalUri.setLrParam();
            Address externalLocalAddress = this.balancerRunner.balancerContext.addressFactory.createAddress((URI)externalLocalUri);
            externalLocalAddress.setURI((URI)externalLocalUri);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("adding Record Router Header :" + externalLocalAddress));
            }
            this.balancerRunner.balancerContext.externalRecordRouteHeader[0] = this.balancerRunner.balancerContext.headerFactory.createRecordRouteHeader(externalLocalAddress);
            externalLocalUri = this.balancerRunner.balancerContext.addressFactory.createSipURI(null, externalLp.getIPAddress());
            externalLocalUri.setPort(externalLp.getPort());
            externalLocalUri.setTransportParam("tcp");
            externalLocalUri.setLrParam();
            externalLocalAddress = this.balancerRunner.balancerContext.addressFactory.createAddress((URI)externalLocalUri);
            externalLocalAddress.setURI((URI)externalLocalUri);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("adding Record Router Header :" + externalLocalAddress));
            }
            this.balancerRunner.balancerContext.externalRecordRouteHeader[1] = this.balancerRunner.balancerContext.headerFactory.createRecordRouteHeader(externalLocalAddress);
            if (this.balancerRunner.balancerContext.isTwoEntrypoints()) {
                SipURI internalLocalUri = this.balancerRunner.balancerContext.addressFactory.createSipURI(null, internalLp.getIPAddress());
                internalLocalUri.setPort(internalLp.getPort());
                internalLocalUri.setTransportParam("udp");
                internalLocalUri.setLrParam();
                Address internalLocalAddress = this.balancerRunner.balancerContext.addressFactory.createAddress((URI)internalLocalUri);
                internalLocalAddress.setURI((URI)internalLocalUri);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("adding Record Router Header :" + internalLocalAddress));
                }
                this.balancerRunner.balancerContext.internalRecordRouteHeader[0] = this.balancerRunner.balancerContext.headerFactory.createRecordRouteHeader(internalLocalAddress);
                internalLocalUri = this.balancerRunner.balancerContext.addressFactory.createSipURI(null, internalLp.getIPAddress());
                internalLocalUri.setPort(internalLp.getPort());
                internalLocalUri.setTransportParam("tcp");
                internalLocalUri.setLrParam();
                internalLocalAddress = this.balancerRunner.balancerContext.addressFactory.createAddress((URI)internalLocalUri);
                internalLocalAddress.setURI((URI)internalLocalUri);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("adding Record Router Header :" + internalLocalAddress));
                }
                this.balancerRunner.balancerContext.internalRecordRouteHeader[1] = this.balancerRunner.balancerContext.headerFactory.createRecordRouteHeader(internalLocalAddress);
            }
            if (this.balancerRunner.balancerContext.externalIpLoadBalancerAddress != null) {
                ipLbSipUri = this.balancerRunner.balancerContext.addressFactory.createSipURI(null, this.balancerRunner.balancerContext.externalIpLoadBalancerAddress);
                ipLbSipUri.setPort(this.balancerRunner.balancerContext.externalLoadBalancerPort);
                ipLbSipUri.setTransportParam("udp");
                ipLbSipUri.setLrParam();
                ipLbAdress = this.balancerRunner.balancerContext.addressFactory.createAddress((URI)ipLbSipUri);
                ipLbAdress.setURI((URI)ipLbSipUri);
                this.balancerRunner.balancerContext.externalIpBalancerRecordRouteHeader[0] = this.balancerRunner.balancerContext.headerFactory.createRecordRouteHeader(ipLbAdress);
                ipLbSipUri = this.balancerRunner.balancerContext.addressFactory.createSipURI(null, this.balancerRunner.balancerContext.externalIpLoadBalancerAddress);
                ipLbSipUri.setPort(this.balancerRunner.balancerContext.externalLoadBalancerPort);
                ipLbSipUri.setTransportParam("tcp");
                ipLbSipUri.setLrParam();
                ipLbAdress = this.balancerRunner.balancerContext.addressFactory.createAddress((URI)ipLbSipUri);
                ipLbAdress.setURI((URI)ipLbSipUri);
                this.balancerRunner.balancerContext.externalIpBalancerRecordRouteHeader[1] = this.balancerRunner.balancerContext.headerFactory.createRecordRouteHeader(ipLbAdress);
            }
            if (this.balancerRunner.balancerContext.internalIpLoadBalancerAddress != null) {
                ipLbSipUri = this.balancerRunner.balancerContext.addressFactory.createSipURI(null, this.balancerRunner.balancerContext.internalIpLoadBalancerAddress);
                ipLbSipUri.setPort(this.balancerRunner.balancerContext.internalLoadBalancerPort);
                ipLbSipUri.setTransportParam("udp");
                ipLbSipUri.setLrParam();
                ipLbAdress = this.balancerRunner.balancerContext.addressFactory.createAddress((URI)ipLbSipUri);
                ipLbAdress.setURI((URI)ipLbSipUri);
                this.balancerRunner.balancerContext.internalIpBalancerRecordRouteHeader[0] = this.balancerRunner.balancerContext.headerFactory.createRecordRouteHeader(ipLbAdress);
                ipLbSipUri = this.balancerRunner.balancerContext.addressFactory.createSipURI(null, this.balancerRunner.balancerContext.internalIpLoadBalancerAddress);
                ipLbSipUri.setPort(this.balancerRunner.balancerContext.internalLoadBalancerPort);
                ipLbSipUri.setTransportParam("tcp");
                ipLbSipUri.setLrParam();
                ipLbAdress = this.balancerRunner.balancerContext.addressFactory.createAddress((URI)ipLbSipUri);
                ipLbAdress.setURI((URI)ipLbSipUri);
                this.balancerRunner.balancerContext.internalIpBalancerRecordRouteHeader[1] = this.balancerRunner.balancerContext.headerFactory.createRecordRouteHeader(ipLbAdress);
            }
            this.balancerRunner.balancerContext.activeExternalHeader[0] = this.balancerRunner.balancerContext.externalIpBalancerRecordRouteHeader[0] != null ? this.balancerRunner.balancerContext.externalIpBalancerRecordRouteHeader[0] : this.balancerRunner.balancerContext.externalRecordRouteHeader[0];
            this.balancerRunner.balancerContext.activeInternalHeader[0] = this.balancerRunner.balancerContext.internalIpBalancerRecordRouteHeader[0] != null ? this.balancerRunner.balancerContext.internalIpBalancerRecordRouteHeader[0] : this.balancerRunner.balancerContext.internalRecordRouteHeader[0];
            this.balancerRunner.balancerContext.activeExternalHeader[1] = this.balancerRunner.balancerContext.externalIpBalancerRecordRouteHeader[1] != null ? this.balancerRunner.balancerContext.externalIpBalancerRecordRouteHeader[1] : this.balancerRunner.balancerContext.externalRecordRouteHeader[1];
            this.balancerRunner.balancerContext.activeInternalHeader[1] = this.balancerRunner.balancerContext.internalIpBalancerRecordRouteHeader[1] != null ? this.balancerRunner.balancerContext.internalIpBalancerRecordRouteHeader[1] : this.balancerRunner.balancerContext.internalRecordRouteHeader[1];
            this.balancerRunner.balancerContext.useIpLoadBalancerAddressInViaHeaders = Boolean.valueOf(this.balancerRunner.balancerContext.properties.getProperty("useIpLoadBalancerAddressInViaHeaders", "false"));
            if (this.balancerRunner.balancerContext.useIpLoadBalancerAddressInViaHeaders) {
                this.balancerRunner.balancerContext.externalViaHost = this.balancerRunner.balancerContext.externalIpLoadBalancerAddress;
                this.balancerRunner.balancerContext.internalViaHost = this.balancerRunner.balancerContext.internalIpLoadBalancerAddress;
                this.balancerRunner.balancerContext.externalViaPort = this.balancerRunner.balancerContext.externalLoadBalancerPort;
                this.balancerRunner.balancerContext.internalViaPort = this.balancerRunner.balancerContext.internalLoadBalancerPort;
            } else {
                this.balancerRunner.balancerContext.externalViaHost = this.balancerRunner.balancerContext.externalHost;
                this.balancerRunner.balancerContext.internalViaHost = this.balancerRunner.balancerContext.internalHost;
                this.balancerRunner.balancerContext.externalViaPort = this.balancerRunner.balancerContext.externalPort;
                this.balancerRunner.balancerContext.internalViaPort = this.balancerRunner.balancerContext.internalPort;
            }
            this.balancerRunner.balancerContext.sipStack.start();
            SipStackImpl stackImpl = (SipStackImpl)this.balancerRunner.balancerContext.sipStack;
            SIPBalancerValveProcessor valve = (SIPBalancerValveProcessor)stackImpl.sipMessageValve;
            valve.balancerRunner = this.balancerRunner;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't create sip objects and lps due to[" + ex.getMessage() + "]", ex);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Sip Balancer started on external address " + this.balancerRunner.balancerContext.externalHost + ", external port : " + this.balancerRunner.balancerContext.externalPort + ", internalPort : " + this.balancerRunner.balancerContext.internalPort));
        }
    }

    public void stop() {
        if (this.balancerRunner.balancerContext.sipStack == null) {
            return;
        }
        Iterator sipProviderIterator = this.balancerRunner.balancerContext.sipStack.getSipProviders();
        try {
            while (sipProviderIterator.hasNext()) {
                ListeningPoint[] listeningPoints;
                SipProvider sipProvider = (SipProvider)sipProviderIterator.next();
                for (ListeningPoint listeningPoint : listeningPoints = sipProvider.getListeningPoints()) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Removing the following Listening Point " + listeningPoint));
                    }
                    try {
                        sipProvider.removeListeningPoint(listeningPoint);
                        this.balancerRunner.balancerContext.sipStack.deleteListeningPoint(listeningPoint);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Cant remove the listening points or sip providers", (Throwable)e);
                    }
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Removing the sip provider");
                }
                sipProvider.removeSipListener((SipListener)this);
                this.balancerRunner.balancerContext.sipStack.deleteSipProvider(sipProvider);
                sipProviderIterator = this.balancerRunner.balancerContext.sipStack.getSipProviders();
            }
            this.balancerRunner.balancerContext.sipStack.stop();
            this.balancerRunner.balancerContext.sipStack = null;
            System.gc();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Sip forwarder SIP stack stopped");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cant remove the listening points or sip providers", e);
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processRequest(RequestEvent requestEvent) {
        block8: {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            String requestMethod = request.getMethod();
            if ((requestMethod.equals("OPTIONS") || requestMethod.equals("INFO")) && request.getHeader("Mobicents-Heartbeat") != null && sipProvider == this.balancerRunner.balancerContext.internalSipProvider) {
                byte[] bytes = (byte[])request.getContent();
                Properties prop = new Properties();
                try {
                    prop.load(new ByteArrayInputStream(bytes, 0, bytes.length));
                    SIPNode node = new SIPNode(prop.getProperty("hostname"), prop.getProperty("ip"));
                    for (String id : prop.stringPropertyNames()) {
                        node.getProperties().put(id, (Serializable)((Object)prop.getProperty(id)));
                    }
                    ArrayList<SIPNode> list = new ArrayList<SIPNode>();
                    list.add(node);
                    this.register.handlePingInRegister(list);
                    Response response = this.balancerRunner.balancerContext.messageFactory.createResponse(200, request);
                    sipProvider.sendResponse(response);
                    return;
                }
                catch (Exception e) {
                    logger.error((Object)("Failure parsing heartbeat properties from this request " + request), (Throwable)e);
                }
            }
            try {
                this.updateStats((Message)request);
                this.forwardRequest(sipProvider, request);
            }
            catch (Throwable throwable) {
                logger.error((Object)("Unexpected exception while forwarding the request " + request), throwable);
                if ("ACK".equalsIgnoreCase(requestMethod)) break block8;
                try {
                    Response response = this.balancerRunner.balancerContext.messageFactory.createResponse(500, request);
                    sipProvider.sendResponse(response);
                }
                catch (Exception e) {
                    logger.error((Object)("Unexpected exception while trying to send the error response for this " + request), (Throwable)e);
                }
            }
        }
    }

    private void updateStats(Message message) {
        if (this.balancerRunner.balancerContext.gatherStatistics) {
            if (message instanceof Request) {
                this.balancerRunner.balancerContext.requestsProcessed.incrementAndGet();
                String method = ((Request)message).getMethod();
                AtomicLong requestsProcessed = this.balancerRunner.balancerContext.requestsProcessedByMethod.get(method);
                if (requestsProcessed == null) {
                    this.balancerRunner.balancerContext.requestsProcessedByMethod.put(method, new AtomicLong(0L));
                } else {
                    requestsProcessed.incrementAndGet();
                }
            } else {
                this.balancerRunner.balancerContext.responsesProcessed.incrementAndGet();
                int statusCode = ((Response)message).getStatusCode();
                int statusCodeDiv = statusCode / 100;
                switch (statusCodeDiv) {
                    case 1: {
                        this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get("1XX").incrementAndGet();
                        break;
                    }
                    case 2: {
                        this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get("2XX").incrementAndGet();
                        break;
                    }
                    case 3: {
                        this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get("3XX").incrementAndGet();
                        break;
                    }
                    case 4: {
                        this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get("4XX").incrementAndGet();
                        break;
                    }
                    case 5: {
                        this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get("5XX").incrementAndGet();
                        break;
                    }
                    case 6: {
                        this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get("6XX").incrementAndGet();
                        break;
                    }
                    case 7: {
                        this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get("7XX").incrementAndGet();
                        break;
                    }
                    case 8: {
                        this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get("8XX").incrementAndGet();
                        break;
                    }
                    case 9: {
                        this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get("9XX").incrementAndGet();
                    }
                }
            }
        }
    }

    private SIPNode getAliveNode(String host, int port, String otherTransport, InvocationContext ctx) {
        return this.getNodeFromCollection(host, port, otherTransport, ctx.nodes);
    }

    private SIPNode getAliveNodeAnyVersion(String host, int port, String otherTransport) {
        return this.getNodeFromCollection(host, port, otherTransport, this.balancerRunner.balancerContext.aliveNodes);
    }

    private SIPNode getNodeFromCollection(String host, int port, String otherTransport, Collection<SIPNode> ctx) {
        otherTransport = otherTransport.toLowerCase();
        for (SIPNode node : ctx) {
            if (!host.equals(node.getHostName()) && !host.equals(node.getIp()) || (Integer)node.getProperties().get(otherTransport + "Port") != port) continue;
            return node;
        }
        return null;
    }

    private SIPNode getNodeDeadOrAlive(String host, int port, String otherTransport) {
        return this.getNodeFromCollection(host, port, otherTransport, this.balancerRunner.balancerContext.allNodesEver);
    }

    private boolean isViaHeaderFromServer(Request request) {
        ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
        String host = viaHeader.getHost();
        String transport = viaHeader.getTransport();
        if (transport == null) {
            transport = "udp";
        }
        int port = viaHeader.getPort();
        if (this.extraServerAddresses != null) {
            for (int q = 0; q < this.extraServerAddresses.length; ++q) {
                if (!this.extraServerAddresses[q].equals(host) || this.extraServerPorts[q] != port) continue;
                return true;
            }
        }
        return this.getAliveNodeAnyVersion(host, port, transport) != null;
    }

    private SIPNode getTransactionSourceNode(Response response) {
        SIPNode node;
        ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
        String host = viaHeader.getHost();
        String transport = viaHeader.getTransport();
        if (transport == null) {
            transport = "udp";
        }
        transport = transport.toLowerCase();
        int port = viaHeader.getPort();
        if (this.extraServerAddresses != null) {
            for (int q = 0; q < this.extraServerAddresses.length; ++q) {
                if (!this.extraServerAddresses[q].equals(host) || this.extraServerPorts[q] != port) continue;
                return ExtraServerNode.extraServerNode;
            }
        }
        if ((node = this.getNodeDeadOrAlive(host, port, transport)) != null) {
            return node;
        }
        return null;
    }

    private SIPNode getSenderNode(Response response) {
        SIPNode node;
        SIPResponse resp = (SIPResponse)response;
        String host = resp.getRemoteAddress().getHostAddress();
        String transport = "udp";
        int port = resp.getRemotePort();
        if (this.extraServerAddresses != null) {
            for (int q = 0; q < this.extraServerAddresses.length; ++q) {
                if (!this.extraServerAddresses[q].equals(host) || this.extraServerPorts[q] != port) continue;
                return ExtraServerNode.extraServerNode;
            }
        }
        if ((node = this.getNodeDeadOrAlive(host, port, transport)) != null) {
            return node;
        }
        return null;
    }

    public SipURI getLoopbackUri(Request request) {
        SipURI uri = null;
        RouteHeader route = (RouteHeader)request.getHeader("Route");
        if (route != null) {
            if (route.getAddress().getURI().isSipURI()) {
                uri = (SipURI)route.getAddress().getURI();
            }
        } else if (request.getRequestURI().isSipURI()) {
            uri = (SipURI)request.getRequestURI();
        }
        if (uri != null && (uri.getHost().equals(this.balancerRunner.balancerContext.externalHost) && uri.getPort() == this.balancerRunner.balancerContext.externalPort || uri.getHost().equals(this.balancerRunner.balancerContext.internalHost) && uri.getPort() == this.balancerRunner.balancerContext.internalPort)) {
            return uri;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void forwardRequest(SipProvider sipProvider, Request request) throws ParseException, InvalidArgumentException, SipException, TransactionUnavailableException {
        if (SIPBalancerForwarder.logger.isDebugEnabled()) {
            SIPBalancerForwarder.logger.debug((Object)("got request:\n" + request));
        }
        isRequestFromServer = false;
        isRequestFromServer = this.balancerRunner.balancerContext.isTwoEntrypoints() == false ? this.isViaHeaderFromServer(request) : sipProvider.equals(this.balancerRunner.balancerContext.internalSipProvider);
        isCancel = "CANCEL".equals(request.getMethod());
        if (!isCancel) {
            this.decreaseMaxForwardsHeader(sipProvider, request);
        }
        hints = this.removeRouteHeadersMeantForLB(request);
        version = hints.version;
        if (version == null) {
            hints.version = version = this.register.getLatestVersion();
        }
        ctx = this.balancerRunner.getInvocationContext(version);
        callID = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
        transport = ((ViaHeader)request.getHeader("Via")).getTransport().toLowerCase();
        if (hints.serverAssignedNode != null) {
            callId = ((SIPHeader)request.getHeader("Call-ID")).getValue();
            ctx.balancerAlgorithm.assignToNode(callId, hints.serverAssignedNode);
            if (SIPBalancerForwarder.logger.isDebugEnabled()) {
                SIPBalancerForwarder.logger.debug((Object)("Following node information has been found in one of the route Headers " + hints.serverAssignedNode));
            }
            if ((uri = this.getLoopbackUri(request)) != null) {
                uri.setHost(hints.serverAssignedNode.getIp());
                uri.setPort(((Integer)hints.serverAssignedNode.getProperties().get(transport + "Port")).intValue());
            }
        }
        nextNode = null;
        if (isRequestFromServer) {
            ctx.balancerAlgorithm.processInternalRequest(request);
            nextNode = hints.serverAssignedNode;
        } else {
            assignedNode = hints.serverAssignedNode;
            if (assignedNode == null && (nextNodeHeader = (RouteHeader)request.getHeader("Route")) != null && (uri = nextNodeHeader.getAddress().getURI()) instanceof SipURI) {
                sipUri = (SipURI)uri;
                assignedNode = this.getAliveNode(sipUri.getHost(), sipUri.getPort(), transport, ctx);
                if (SIPBalancerForwarder.logger.isDebugEnabled()) {
                    SIPBalancerForwarder.logger.debug((Object)("Found SIP URI " + uri + " |Next node is " + assignedNode));
                }
            }
            assignedUri = null;
            originalRouteHeaderUri = null;
            if (assignedNode == null) {
                if (hints.subsequentRequest) {
                    header = (RouteHeader)request.getHeader("Route");
                    if (header != null) {
                        assignedUri = (SipURI)header.getAddress().getURI();
                        originalRouteHeaderUri = (SipURI)assignedUri.clone();
                        request.removeFirst("Route");
                    } else if (request.getRequestURI() instanceof SipURI) {
                        sipUri = (SipURI)request.getRequestURI();
                        assignedNode = this.getAliveNode(sipUri.getHost(), sipUri.getPort(), transport, ctx);
                    }
                    if (SIPBalancerForwarder.logger.isDebugEnabled()) {
                        SIPBalancerForwarder.logger.debug((Object)("Subsequent request -> Found Route Header " + header + " |Next node is " + assignedNode));
                    }
                } else if (request.getRequestURI() instanceof SipURI) {
                    sipUri = (SipURI)request.getRequestURI();
                    assignedNode = this.getAliveNode(sipUri.getHost(), sipUri.getPort(), transport, ctx);
                    if (SIPBalancerForwarder.logger.isDebugEnabled()) {
                        SIPBalancerForwarder.logger.debug((Object)("NOT Subsequent request -> using sipUri " + sipUri + " |Next node is " + assignedNode));
                    }
                }
            }
            if (assignedNode == null) {
                if (SIPBalancerForwarder.logger.isDebugEnabled()) {
                    SIPBalancerForwarder.logger.debug((Object)"assignedNode is null");
                }
                if ((nextNode = ctx.balancerAlgorithm.processExternalRequest(request)) instanceof NullServerNode && SIPBalancerForwarder.logger.isDebugEnabled()) {
                    SIPBalancerForwarder.logger.debug((Object)("Algorithm returned a NullServerNode. We will not attempt to forward this request " + request));
                }
                if (nextNode != null) {
                    if (SIPBalancerForwarder.logger.isDebugEnabled()) {
                        nodesString = "";
                        for (Object n : nodes = ctx.nodes.toArray()) {
                            nodesString = nodesString + n + " , ";
                        }
                        SIPBalancerForwarder.logger.debug((Object)("Next node is not null. Assigned uri is " + assignedUri + "Available nodes: " + nodesString));
                    }
                    try {
                        routeSipUri = assignedUri == null ? this.balancerRunner.balancerContext.addressFactory.createSipURI(null, nextNode.getIp()) : assignedUri;
                        routeSipUri.setHost(nextNode.getIp());
                        port = (Integer)nextNode.getProperties().get(transport + "Port");
                        if (port == null) {
                            throw new RuntimeException("Port is null in the node properties for transport=" + transport);
                        }
                        routeSipUri.setPort(port.intValue());
                        routeSipUri.setTransportParam(transport);
                        routeSipUri.setLrParam();
                        route = this.balancerRunner.balancerContext.headerFactory.createRouteHeader(this.balancerRunner.balancerContext.addressFactory.createAddress((URI)routeSipUri));
                        request.addFirst((Header)route);
                        if (originalRouteHeaderUri == null || !request.getRequestURI().isSipURI() || !(rurihostid = (uri = (SipURI)request.getRequestURI()).getHost() + uri.getPort()).equals(originalhostid = originalRouteHeaderUri.getHost() + originalRouteHeaderUri.getPort())) ** GOTO lbl86
                        uri.setPort(routeSipUri.getPort());
                        uri.setHost(routeSipUri.getHost());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error adding route header", e);
                    }
                }
            } else {
                nextNode = ctx.balancerAlgorithm.processAssignedExternalRequest(request, assignedNode);
            }
lbl86:
            // 4 sources

            if (nextNode == null) {
                if (SIPBalancerForwarder.logger.isDebugEnabled()) {
                    SIPBalancerForwarder.logger.debug((Object)"No nodes available");
                }
                if (!"ACK".equalsIgnoreCase(request.getMethod())) {
                    try {
                        response = this.balancerRunner.balancerContext.messageFactory.createResponse(500, request);
                        response.setReasonPhrase("No nodes available");
                        sipProvider.sendResponse(response);
                    }
                    catch (Exception e) {
                        SIPBalancerForwarder.logger.error((Object)("Unexpected exception while trying to send the error response for this " + request), (Throwable)e);
                    }
                }
                return;
            }
        }
        hints.serverAssignedNode = nextNode;
        if (!hints.subsequentRequest && SIPBalancerForwarder.dialogCreationMethods.contains(request.getMethod())) {
            this.addLBRecordRoute(sipProvider, request, hints, version);
        }
        via = (ViaHeader)request.getHeader("Via");
        newBranch = via.getBranch() + callID.substring(0, Math.min(callID.length(), 5));
        viaHeaderExternal = null;
        viaHeaderInternal = null;
        viaHeaderExternal = this.balancerRunner.balancerContext.headerFactory.createViaHeader(this.balancerRunner.balancerContext.externalViaHost, this.balancerRunner.balancerContext.externalViaPort, transport, newBranch + "_" + version);
        if (this.balancerRunner.balancerContext.isTwoEntrypoints()) {
            viaHeaderInternal = this.balancerRunner.balancerContext.headerFactory.createViaHeader(this.balancerRunner.balancerContext.internalViaHost, this.balancerRunner.balancerContext.internalViaPort, transport, newBranch + "zsd" + "_" + version);
        }
        if (SIPBalancerForwarder.logger.isDebugEnabled()) {
            SIPBalancerForwarder.logger.debug((Object)("ViaHeaders will be added " + viaHeaderExternal + " and " + viaHeaderInternal));
            SIPBalancerForwarder.logger.debug((Object)("Sending the request:\n" + request + "\n on the other side"));
        }
        if (this.getLoopbackUri(request) != null) {
            SIPBalancerForwarder.logger.warn((Object)("Drop. Cannot forward to loopback the following request: " + request));
            return;
        }
        if (!isRequestFromServer && this.balancerRunner.balancerContext.isTwoEntrypoints()) {
            request.addHeader((Header)viaHeaderExternal);
            if (viaHeaderInternal != null) {
                request.addHeader(viaHeaderInternal);
            }
            this.balancerRunner.balancerContext.internalSipProvider.sendRequest(request);
        } else {
            if (viaHeaderInternal != null) {
                request.addHeader(viaHeaderInternal);
            }
            request.addHeader((Header)viaHeaderExternal);
            this.balancerRunner.balancerContext.externalSipProvider.sendRequest(request);
        }
    }

    private RecordRouteHeader stampRecordRoute(RecordRouteHeader rrh, RouteHeaderHints hints, String transport) {
        SipURI uri = (SipURI)rrh.getAddress().getURI();
        try {
            uri.setParameter(ROUTE_PARAM_NODE_HOST, hints.serverAssignedNode.getIp());
            uri.setParameter(ROUTE_PARAM_NODE_PORT, hints.serverAssignedNode.getProperties().get(transport.toLowerCase() + "Port").toString());
            uri.setParameter(ROUTE_PARAM_NODE_VERSION, hints.version);
        }
        catch (ParseException e) {
            logger.warn((Object)"Problem adding rrh", (Throwable)e);
        }
        return rrh;
    }

    private void addTwoRecordRoutes(Request request, RecordRouteHeader first, RecordRouteHeader second, RouteHeaderHints hints, String transport) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("adding Record Router Header :" + first));
        }
        request.addHeader((Header)this.stampRecordRoute((RecordRouteHeader)first.clone(), hints, transport));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("adding Record Router Header :" + second));
        }
        request.addHeader((Header)this.stampRecordRoute((RecordRouteHeader)second.clone(), hints, transport));
    }

    private void addLBRecordRoute(SipProvider sipProvider, Request request, RouteHeaderHints hints, String version) throws ParseException {
        String transport;
        int transportIndex;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("adding Record Router Header :" + this.balancerRunner.balancerContext.activeExternalHeader));
        }
        int n = transportIndex = (transport = ((ViaHeader)request.getHeader("Via")).getTransport().toLowerCase()).equalsIgnoreCase("udp") ? 0 : 1;
        if (this.balancerRunner.balancerContext.isTwoEntrypoints()) {
            if (sipProvider.equals(this.balancerRunner.balancerContext.externalSipProvider)) {
                this.addTwoRecordRoutes(request, this.balancerRunner.balancerContext.activeExternalHeader[transportIndex], this.balancerRunner.balancerContext.activeInternalHeader[transportIndex], hints, transport);
            } else {
                this.addTwoRecordRoutes(request, this.balancerRunner.balancerContext.activeInternalHeader[transportIndex], this.balancerRunner.balancerContext.activeExternalHeader[transportIndex], hints, transport);
            }
        } else {
            RecordRouteHeader recordRouteHeader = this.balancerRunner.balancerContext.activeExternalHeader[transportIndex];
            if (hints.serverAssignedNode != null) {
                recordRouteHeader = (RecordRouteHeader)recordRouteHeader.clone();
                SipURI sipuri = (SipURI)recordRouteHeader.getAddress().getURI();
                sipuri.setParameter(ROUTE_PARAM_NODE_HOST, hints.serverAssignedNode.getIp());
                sipuri.setParameter(ROUTE_PARAM_NODE_PORT, hints.serverAssignedNode.getProperties().get(transport.toLowerCase() + "Port").toString());
                sipuri.setParameter(ROUTE_PARAM_NODE_VERSION, version);
            }
            request.addHeader((Header)recordRouteHeader);
        }
    }

    private SIPNode checkRouteHeaderForSipNode(SipURI routeSipUri) {
        SIPNode node = null;
        String hostNode = routeSipUri.getParameter(ROUTE_PARAM_NODE_HOST);
        String hostPort = routeSipUri.getParameter(ROUTE_PARAM_NODE_PORT);
        String hostVersion = routeSipUri.getParameter(ROUTE_PARAM_NODE_VERSION);
        if (hostNode != null && hostPort != null) {
            int port = Integer.parseInt(hostPort);
            String transport = routeSipUri.getTransportParam();
            if (transport == null) {
                transport = "udp";
            }
            node = this.register.getNode(hostNode, port, transport, hostVersion);
        }
        return node;
    }

    private RouteHeaderHints removeRouteHeadersMeantForLB(Request request) {
        ToHeader to;
        boolean subsequent;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Checking if there is any route headers meant for the LB to remove...");
        }
        SIPNode node = null;
        String callVersion = null;
        int numberOfRemovedRouteHeaders = 0;
        RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
        if (routeHeader != null) {
            SipURI routeUri = (SipURI)routeHeader.getAddress().getURI();
            callVersion = routeUri.getParameter(ROUTE_PARAM_NODE_VERSION);
            if (!this.isRouteHeaderExternal(routeUri.getHost(), routeUri.getPort())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("this route header is for the LB removing it " + routeUri));
                }
                ++numberOfRemovedRouteHeaders;
                request.removeFirst("Route");
                routeHeader = (RouteHeader)request.getHeader("Route");
                node = this.checkRouteHeaderForSipNode(routeUri);
                if (routeHeader != null && !this.isRouteHeaderExternal((routeUri = (SipURI)routeHeader.getAddress().getURI()).getHost(), routeUri.getPort())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("this route header is for the LB removing it " + routeUri));
                    }
                    ++numberOfRemovedRouteHeaders;
                    request.removeFirst("Route");
                    if (node == null) {
                        node = this.checkRouteHeaderForSipNode(routeUri);
                    }
                    boolean moreHeaders = true;
                    while (moreHeaders) {
                        RouteHeader extraHeader = (RouteHeader)request.getHeader("Route");
                        if (extraHeader != null) {
                            SipURI u = (SipURI)extraHeader.getAddress().getURI();
                            if (!this.isRouteHeaderExternal(u.getHost(), u.getPort())) {
                                ++numberOfRemovedRouteHeaders;
                                request.removeFirst("Route");
                                continue;
                            }
                            moreHeaders = false;
                            continue;
                        }
                        moreHeaders = false;
                    }
                }
            }
        }
        if (node == null && request.getRequestURI().isSipURI()) {
            node = this.checkRouteHeaderForSipNode((SipURI)request.getRequestURI());
        }
        boolean bl = subsequent = (to = (ToHeader)request.getHeader("To")).getTag() != null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Number of removed Route headers is " + numberOfRemovedRouteHeaders));
        }
        if (numberOfRemovedRouteHeaders != 2 && subsequent) {
            logger.warn((Object)("A subsequent request should have two Route headers. Number of removed Route headers is " + numberOfRemovedRouteHeaders + ". This indicates a client is removing important headers."));
        }
        return new RouteHeaderHints(node, subsequent, callVersion);
    }

    private boolean isRouteHeaderExternal(String host, int port) {
        if ((host.equalsIgnoreCase(this.balancerRunner.balancerContext.externalHost) || host.equalsIgnoreCase(this.balancerRunner.balancerContext.internalHost)) && (port == this.balancerRunner.balancerContext.externalPort || port == this.balancerRunner.balancerContext.internalPort)) {
            return false;
        }
        if (host.equalsIgnoreCase(this.balancerRunner.balancerContext.externalIpLoadBalancerAddress) && port == this.balancerRunner.balancerContext.externalLoadBalancerPort) {
            return false;
        }
        return !host.equalsIgnoreCase(this.balancerRunner.balancerContext.internalIpLoadBalancerAddress) || port != this.balancerRunner.balancerContext.internalLoadBalancerPort;
    }

    private void decreaseMaxForwardsHeader(SipProvider sipProvider, Request request) throws InvalidArgumentException, ParseException, SipException {
        MaxForwardsHeader maxForwardsHeader;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Decreasing  the Max Forward Header ");
        }
        if ((maxForwardsHeader = (MaxForwardsHeader)request.getHeader("Max-Forwards")) == null) {
            maxForwardsHeader = this.balancerRunner.balancerContext.headerFactory.createMaxForwardsHeader(70);
            request.addHeader((Header)maxForwardsHeader);
        } else if (maxForwardsHeader.getMaxForwards() - 1 > 0) {
            maxForwardsHeader.setMaxForwards(maxForwardsHeader.getMaxForwards() - 1);
        } else {
            Response response = this.balancerRunner.balancerContext.messageFactory.createResponse(483, request);
            sipProvider.sendResponse(response);
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        SipProvider sipProvider = (SipProvider)responseEvent.getSource();
        Response originalResponse = responseEvent.getResponse();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got response :\n" + originalResponse));
        }
        this.updateStats((Message)originalResponse);
        Response response = originalResponse;
        SIPNode senderNode = this.getSenderNode(response);
        if (senderNode != null) {
            senderNode.updateTimerStamp();
        }
        ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
        String branch = viaHeader.getBranch();
        int versionDelimiter = branch.lastIndexOf(95);
        String version = branch.substring(versionDelimiter + 1);
        InvocationContext ctx = this.balancerRunner.getInvocationContext(version);
        if (viaHeader != null && !this.isRouteHeaderExternal(viaHeader.getHost(), viaHeader.getPort())) {
            response.removeFirst("Via");
        }
        if ((viaHeader = (ViaHeader)response.getHeader("Via")) != null && !this.isRouteHeaderExternal(viaHeader.getHost(), viaHeader.getPort())) {
            response.removeFirst("Via");
        }
        boolean fromServer = false;
        if (this.balancerRunner.balancerContext.isTwoEntrypoints()) {
            fromServer = sipProvider.equals(this.balancerRunner.balancerContext.internalSipProvider);
        } else {
            boolean bl = fromServer = senderNode == null;
        }
        if (fromServer) {
            ctx.balancerAlgorithm.processInternalResponse(response);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("from server sending response externally " + response));
                }
                this.balancerRunner.balancerContext.externalSipProvider.sendResponse(response);
            }
            catch (Exception ex) {
                logger.error((Object)("Unexpected exception while forwarding the response \n" + response), (Throwable)ex);
            }
        } else {
            try {
                ctx.balancerAlgorithm.processExternalResponse(response);
                if (this.balancerRunner.balancerContext.isTwoEntrypoints()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("two entry points: from external sending response " + response));
                    }
                    this.balancerRunner.balancerContext.internalSipProvider.sendResponse(response);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("one entry point: from external sending response " + response));
                    }
                    this.balancerRunner.balancerContext.externalSipProvider.sendResponse(response);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Unexpected exception while forwarding the response \n" + response), (Throwable)ex);
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        ServerTransaction transaction = null;
        if (timeoutEvent.isServerTransaction()) {
            transaction = timeoutEvent.getServerTransaction();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("timeout => " + transaction.getRequest().toString()));
            }
        } else {
            transaction = timeoutEvent.getClientTransaction();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("timeout => " + transaction.getRequest().toString()));
            }
        }
        String callId = ((CallIdHeader)transaction.getRequest().getHeader("Call-ID")).getCallId();
        this.register.unStickSessionFromNode(callId);
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        ServerTransaction transaction = null;
        if (transactionTerminatedEvent.isServerTransaction()) {
            transaction = transactionTerminatedEvent.getServerTransaction();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("timeout => " + transaction.getRequest().toString()));
            }
        } else {
            transaction = transactionTerminatedEvent.getClientTransaction();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("timeout => " + transaction.getRequest().toString()));
            }
        }
        if ("BYE".equals(transaction.getRequest().getMethod())) {
            String callId = ((CallIdHeader)transaction.getRequest().getHeader("Call-ID")).getCallId();
            this.register.unStickSessionFromNode(callId);
        }
    }

    public long getNumberOfRequestsProcessed() {
        return this.balancerRunner.balancerContext.requestsProcessed.get();
    }

    public long getNumberOfResponsesProcessed() {
        return this.balancerRunner.balancerContext.responsesProcessed.get();
    }

    public long getRequestsProcessedByMethod(String method) {
        AtomicLong requestsProcessed = this.balancerRunner.balancerContext.requestsProcessedByMethod.get(method);
        if (requestsProcessed != null) {
            return requestsProcessed.get();
        }
        return 0L;
    }

    public long getResponsesProcessedByStatusCode(String statusCode) {
        AtomicLong responsesProcessed = this.balancerRunner.balancerContext.responsesProcessedByStatusCode.get(statusCode);
        if (responsesProcessed != null) {
            return responsesProcessed.get();
        }
        return 0L;
    }

    public Map<String, AtomicLong> getNumberOfRequestsProcessedByMethod() {
        return this.balancerRunner.balancerContext.requestsProcessedByMethod;
    }

    public Map<String, AtomicLong> getNumberOfResponsesProcessedByStatusCode() {
        return this.balancerRunner.balancerContext.responsesProcessedByStatusCode;
    }

    public BalancerContext getBalancerAlgorithmContext() {
        return this.balancerRunner.balancerContext;
    }

    public void setBalancerAlgorithmContext(BalancerContext balancerAlgorithmContext) {
        this.balancerRunner.balancerContext = balancerAlgorithmContext;
    }

    public void setGatherStatistics(boolean skipStatistics) {
        this.balancerRunner.balancerContext.gatherStatistics = skipStatistics;
    }

    public boolean isGatherStatistics() {
        return this.balancerRunner.balancerContext.gatherStatistics;
    }

    static {
        dialogCreationMethods.add("INVITE");
        dialogCreationMethods.add("SUBSCRIBE");
    }
}

