/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.stack.HopImpl;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.SipException;
import javax.sip.SipStack;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import org.mobicents.tools.sip.balancer.NodeRegister;
import org.mobicents.tools.sip.balancer.SIPNode;

public class RouterImpl
implements Router {
    private static NodeRegister register = null;

    public RouterImpl(SipStack sipStack, String proxyPort) throws Exception {
    }

    public static void setRegister(NodeRegister register) {
        RouterImpl.register = register;
    }

    public Hop getNextHop(Request request) throws SipException {
        int i;
        String callID = ((CallID)request.getHeader("Call-ID")).getCallId();
        SIPNode node = null;
        HopImpl hop = null;
        String transport = ((ViaHeader)request.getHeader("Via")).getTransport().toLowerCase();
        String method = request.getMethod();
        if (method.equals("INVITE") || method.equals("SUBSCRIBE")) {
            node = register.stickSessionToNode(callID, null);
        } else if (method.equals("BYE") || method.equals("CANCEL")) {
            node = register.getGluedNode(callID);
            if (node == null) {
                for (i = 0; i < 5 && node == null; ++i) {
                    try {
                        node = register.getNextNode();
                        continue;
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        // empty catch block
                    }
                }
            }
        } else {
            node = register.getGluedNode(callID);
            if (node == null) {
                for (i = 0; i < 5 && node == null; ++i) {
                    try {
                        node = register.getNextNode();
                        continue;
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        // empty catch block
                    }
                }
            }
        }
        Integer port = (Integer)node.getProperties().get(transport + "Port");
        if (port == null) {
            throw new RuntimeException("No port available for transport " + transport + " for node " + node);
        }
        hop = new HopImpl(node.getIp(), port.intValue(), transport);
        System.out.println(this.getClass().getName() + ".getNextHop() returning hop:" + hop);
        return hop;
    }

    public ListIterator getNextHops(Request request) {
        SIPNode node = null;
        for (int i = 0; i < 5 && node == null; ++i) {
            try {
                node = register.getNextNode();
                continue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                // empty catch block
            }
        }
        if (node == null) {
            return null;
        }
        String transport = ((ViaHeader)request.getHeader("Via")).getTransport().toLowerCase();
        LinkedList<HopImpl> retval = new LinkedList<HopImpl>();
        Integer port = (Integer)node.getProperties().get(transport + "Port");
        if (port == null) {
            throw new RuntimeException("No port available for transport " + transport + " for node " + node);
        }
        retval.add(new HopImpl(node.getIp(), port.intValue(), transport));
        return retval.listIterator();
    }

    public Hop getOutboundProxy() {
        return null;
    }
}

