/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.HeaderConsistentHashBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.InvocationContext;
import org.mobicents.tools.sip.balancer.SIPNode;

public class PureConsistentHashBalancerAlgorithm
extends HeaderConsistentHashBalancerAlgorithm {
    private static Logger logger = Logger.getLogger((String)PureConsistentHashBalancerAlgorithm.class.getCanonicalName());
    MessageDigest md5;
    HashMap<Integer, SIPNode> hashToNode = new HashMap();
    HashMap<SIPNode, Integer> nodeToHash = new HashMap();
    private TreeSet<SIPNode> tmpNodes = new TreeSet();

    public PureConsistentHashBalancerAlgorithm() {
        this("Call-ID");
    }

    public PureConsistentHashBalancerAlgorithm(String headerName) {
        this.sipHeaderAffinityKey = headerName;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SIPNode processExternalRequest(Request request) {
        Integer nodeIndex = this.hashHeader((Message)request);
        if (nodeIndex < 0) {
            return null;
        }
        BalancerContext balancerContext = this.getBalancerContext();
        try {
            SIPNode node = (SIPNode)this.nodesArray[nodeIndex];
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public synchronized void nodeAdded(SIPNode node) {
        this.nodeAdded(node, this.invocationContext);
    }

    public synchronized void nodeAdded(SIPNode node, InvocationContext context) {
        this.addNode(node);
        this.syncNodes();
    }

    private synchronized void addNode(SIPNode node) {
        this.tmpNodes.add(node);
        this.syncNodes();
        this.dumpNodes();
    }

    @Override
    public synchronized void nodeRemoved(SIPNode node) {
        this.tmpNodes.remove(node);
        this.syncNodes();
        this.dumpNodes();
    }

    public int digest(String string) {
        this.md5.update(string.getBytes());
        byte[] digest = this.md5.digest();
        int result = 0;
        for (int q = 0; q < digest.length; ++q) {
            result ^= digest[q] << (3 - q % 4 << 3);
        }
        return result;
    }

    public int absDigest(String string) {
        return Math.abs(this.digest(string));
    }

    private void dumpNodes() {
        String nodes = "I am " + this.getBalancerContext().externalHost + ":" + this.getBalancerContext().externalPort + ". I see the following nodes are in cache right now (" + this.nodesArray.length + "):\n";
        for (Object object : this.nodesArray) {
            SIPNode node = (SIPNode)object;
            nodes = nodes + node.toString() + " [ALIVE:" + this.isAlive(node) + "]" + " [HASH:" + this.absDigest(node.toStringWithoutJvmroute()) + "]" + "\n";
        }
        logger.info((Object)nodes);
    }

    @Override
    protected int hashAffinityKeyword(String keyword) {
        int hashCode = Math.abs(keyword.hashCode());
        Object[] nodes = this.nodesArray;
        int lastNodeWithLowerHash = 0;
        int q = 0;
        while (q < nodes.length) {
            SIPNode node = (SIPNode)nodes[q];
            Integer nodeHash = this.nodeToHash.get(node);
            if (nodeHash == null) {
                nodeHash = 0;
            }
            if (hashCode <= nodeHash) {
                return q;
            }
            lastNodeWithLowerHash = q++;
        }
        return lastNodeWithLowerHash;
    }

    @Override
    public void init() {
        InputStream configurationInputStream = null;
        String configFile = this.getProperties().getProperty("persistentConsistentHashCacheConfiguration");
        if (configFile != null) {
            logger.info((Object)("Try to use cache configuration from " + configFile));
            try {
                configurationInputStream = new FileInputStream(configFile);
            }
            catch (FileNotFoundException e1) {
                logger.error((Object)"File not found", (Throwable)e1);
                throw new RuntimeException(e1);
            }
        } else {
            logger.info((Object)"Using default cache settings");
            configurationInputStream = this.getClass().getClassLoader().getResourceAsStream("META-INF/PHA-balancer-cache.xml");
            if (configurationInputStream == null) {
                throw new RuntimeException("Problem loading resource META-INF/PHA-balancer-cache.xml");
            }
        }
        this.httpAffinityKey = this.getProperties().getProperty("httpAffinityKey", "appsession");
        this.sipHeaderAffinityKey = this.getProperties().getProperty("sipHeaderAffinityKey", "Call-ID");
    }

    @Override
    public synchronized void syncNodes() {
        TreeSet<SIPNode> nodes = this.tmpNodes;
        if (nodes != null) {
            ArrayList<SIPNode> nodeList = new ArrayList<SIPNode>();
            nodeList.addAll(nodes);
            Collections.sort(nodeList, new Comparator<SIPNode>(){

                @Override
                public int compare(SIPNode o1, SIPNode o2) {
                    int b;
                    int a = PureConsistentHashBalancerAlgorithm.this.absDigest(o1.toStringWithoutJvmroute());
                    if (a == (b = PureConsistentHashBalancerAlgorithm.this.absDigest(o2.toStringWithoutJvmroute()))) {
                        return 0;
                    }
                    if (a < b) {
                        return -1;
                    }
                    return 1;
                }
            });
            HashMap<Integer, SIPNode> tmpHashToNode = new HashMap<Integer, SIPNode>();
            for (SIPNode node : nodeList) {
                tmpHashToNode.put(this.absDigest(node.toStringWithoutJvmroute()), node);
            }
            this.hashToNode = tmpHashToNode;
            HashMap<SIPNode, Integer> tmpNodeToHash = new HashMap<SIPNode, Integer>();
            for (SIPNode node : nodeList) {
                tmpNodeToHash.put(node, this.absDigest(node.toStringWithoutJvmroute()));
            }
            this.nodeToHash = tmpNodeToHash;
            this.nodesArray = nodeList.toArray();
        }
        this.dumpNodes();
    }
}

