/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.mobicents.tools.sip.balancer.HeaderConsistentHashBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.SIPNode;

@CacheListener
public class PersistentConsistentHashBalancerAlgorithm
extends HeaderConsistentHashBalancerAlgorithm {
    private static Logger logger = Logger.getLogger((String)PersistentConsistentHashBalancerAlgorithm.class.getCanonicalName());
    protected Cache cache;

    public PersistentConsistentHashBalancerAlgorithm() {
    }

    public PersistentConsistentHashBalancerAlgorithm(String headerName) {
        this.sipHeaderAffinityKey = headerName;
    }

    @NodeModified
    public void modified(Event event) {
        logger.debug((Object)event.toString());
    }

    @Override
    public synchronized void nodeAdded(SIPNode node) {
        this.addNode(node);
        this.syncNodes();
    }

    private void addNode(SIPNode node) {
        Fqn nodes = Fqn.fromString((String)("/BALANCER" + this.invocationContext.version + "/NODES"));
        this.cache.put(nodes, (Object)node, (Object)"");
        this.dumpNodes();
    }

    @Override
    public synchronized void nodeRemoved(SIPNode node) {
        this.dumpNodes();
    }

    private void dumpNodes() {
        String nodes = "I am " + this.getBalancerContext().externalHost + ":" + this.getBalancerContext().externalPort + ". I see the following nodes are in cache right now (" + this.nodesArray.length + "):\n";
        for (Object object : this.nodesArray) {
            SIPNode node = (SIPNode)object;
            nodes = nodes + node.toString() + " [ALIVE:" + this.isAlive(node) + "]\n";
        }
        logger.info((Object)nodes);
    }

    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        logger.info((Object)event.toString());
    }

    @Override
    public void init() {
        DefaultCacheFactory cacheFactory = new DefaultCacheFactory();
        InputStream configurationInputStream = null;
        String configFile = this.getProperties().getProperty("persistentConsistentHashCacheConfiguration");
        if (configFile != null) {
            logger.info((Object)("Try to use cache configuration from " + configFile));
            try {
                configurationInputStream = new FileInputStream(configFile);
            }
            catch (FileNotFoundException e1) {
                logger.error((Object)"File not found", (Throwable)e1);
                throw new RuntimeException(e1);
            }
        } else {
            logger.info((Object)"Using default cache settings");
            configurationInputStream = this.getClass().getClassLoader().getResourceAsStream("META-INF/PHA-balancer-cache.xml");
            if (configurationInputStream == null) {
                throw new RuntimeException("Problem loading resource META-INF/PHA-balancer-cache.xml");
            }
        }
        Cache cache = cacheFactory.createCache(configurationInputStream);
        cache.addCacheListener((Object)this);
        cache.create();
        cache.start();
        this.cache = cache;
        this.httpAffinityKey = this.getProperties().getProperty("httpAffinityKey", "appsession");
        this.sipHeaderAffinityKey = this.getProperties().getProperty("sipHeaderAffinityKey", "Call-ID");
    }

    @Override
    protected void syncNodes() {
        Set nodes = this.cache.getKeys("/BALANCER" + this.invocationContext.version + "/NODES");
        if (nodes != null) {
            ArrayList nodeList = new ArrayList();
            nodeList.addAll(nodes);
            Collections.sort(nodeList);
            this.nodesArray = nodeList.toArray();
        }
        this.dumpNodes();
    }
}

