/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.mobicents.tools.sip.balancer.BalancerRunner;
import org.mobicents.tools.sip.balancer.InvocationContext;
import org.mobicents.tools.sip.balancer.NodeRegister;
import org.mobicents.tools.sip.balancer.NodeRegisterRMIStub;
import org.mobicents.tools.sip.balancer.SIPNode;

public class NodeRegisterImpl
implements NodeRegister {
    private static Logger logger = Logger.getLogger((String)NodeRegisterImpl.class.getCanonicalName());
    public static final int POINTER_START = 0;
    private long nodeInfoExpirationTaskInterval = 5000L;
    private long nodeExpiration = 5100L;
    private Registry registry;
    private Timer taskTimer = new Timer();
    private TimerTask nodeExpirationTask = null;
    private InetAddress serverAddress = null;
    private String latestVersion = "-2147483648";
    private int numberOfOldServers;
    private int numberOfNewServers;
    BalancerRunner balancerRunner;

    public NodeRegisterImpl(InetAddress serverAddress) throws RemoteException {
        this.serverAddress = serverAddress;
    }

    public boolean startRegistry(int rmiRegistryPort) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Node registry starting...");
        }
        try {
            this.balancerRunner.balancerContext.aliveNodes = new CopyOnWriteArrayList();
            this.balancerRunner.balancerContext.jvmRouteToSipNode = new ConcurrentHashMap();
            this.register(this.serverAddress, rmiRegistryPort);
            this.nodeExpirationTask = new NodeExpirationTimerTask();
            this.taskTimer.scheduleAtFixedRate(this.nodeExpirationTask, this.nodeInfoExpirationTaskInterval, this.nodeInfoExpirationTaskInterval);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Node expiration task created");
                logger.info((Object)"Node registry started");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unexpected exception while starting the registry", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean stopRegistry() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Stopping node registry...");
        }
        boolean isDeregistered = this.deregister(this.serverAddress);
        boolean taskCancelled = this.nodeExpirationTask.cancel();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Node Expiration Task cancelled " + taskCancelled));
        }
        this.balancerRunner.balancerContext.allNodesEver.clear();
        this.balancerRunner.balancerContext.allNodesEver = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Node registry stopped.");
        }
        return isDeregistered;
    }

    private void register(InetAddress serverAddress, int rmiRegistryPort) {
        try {
            this.registry = LocateRegistry.createRegistry(rmiRegistryPort, null, new BindingAddressCorrectnessSocketFactory(serverAddress));
            this.registry.bind("SIPBalancer", new RegisterRMIStub());
            logger.info((Object)("RMI heartbeat listener bound to internalHost, port " + rmiRegistryPort));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to bind due to:", e);
        }
    }

    private boolean deregister(InetAddress serverAddress) {
        try {
            this.registry.unbind("SIPBalancer");
            return UnicastRemoteObject.unexportObject(this.registry, false);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to unbind due to", e);
        }
        catch (NotBoundException e) {
            throw new RuntimeException("Failed to unbind due to", e);
        }
    }

    @Override
    public void unStickSessionFromNode(String callID) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("unsticked  CallId " + callID + " from node " + null));
        }
    }

    @Override
    public SIPNode stickSessionToNode(String callID, SIPNode sipNode) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sticking  CallId " + callID + " to node " + null));
        }
        return null;
    }

    @Override
    public SIPNode getGluedNode(String callID) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("glueued node " + null + " for CallId " + callID));
        }
        return null;
    }

    @Override
    public boolean isSIPNodePresent(String host, int port, String transport, String version) {
        return this.getNode(host, port, transport, version) != null;
    }

    @Override
    public SIPNode getNode(String host, int port, String transport, String version) {
        for (SIPNode node : this.balancerRunner.balancerContext.aliveNodes) {
            Integer nodePort;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("node to check against " + node));
            }
            if (!node.getIp().equals(host) || (nodePort = (Integer)node.getProperties().get(transport + "Port")) == null || nodePort != port) continue;
            if (version == null) {
                return node;
            }
            String nodeVersion = (String)((Object)node.getProperties().get("version"));
            if (nodeVersion == null) {
                nodeVersion = "0";
            }
            if (!version.equals(nodeVersion)) continue;
            return node;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("checking if the node is still alive for " + host + ":" + port + "/" + transport + " : false"));
        }
        return null;
    }

    @Override
    public synchronized void handlePingInRegister(ArrayList<SIPNode> ping) {
        for (SIPNode pingNode : ping) {
            String version = (String)((Object)pingNode.getProperties().get("version"));
            if (version == null) {
                version = "0";
            }
            InvocationContext ctx = this.balancerRunner.getInvocationContext(version);
            pingNode.updateTimerStamp();
            if (pingNode.getProperties().get("jvmRoute") != null) {
                this.balancerRunner.balancerContext.jvmRouteToSipNode.put((String)((Object)pingNode.getProperties().get("jvmRoute")), pingNode);
            }
            SIPNode nodePresent = null;
            Iterator<SIPNode> nodesIterator = ctx.nodes.iterator();
            while (nodesIterator.hasNext() && nodePresent == null) {
                SIPNode node = nodesIterator.next();
                if (!node.equals(pingNode)) continue;
                nodePresent = node;
            }
            if (nodePresent != null) {
                nodePresent.updateTimerStamp();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ping " + nodePresent.getTimeStamp()));
                continue;
            }
            Integer current = Integer.parseInt(version);
            Integer latest = Integer.parseInt(this.latestVersion);
            this.latestVersion = Math.max(current, latest) + "";
            this.balancerRunner.balancerContext.aliveNodes.add(pingNode);
            ctx.nodes.add(pingNode);
            ctx.balancerAlgorithm.nodeAdded(pingNode);
            this.balancerRunner.balancerContext.allNodesEver.add(pingNode);
            pingNode.updateTimerStamp();
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("NodeExpirationTimerTask Run NSync[" + pingNode + "] added"));
        }
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void forceRemovalInRegister(ArrayList<SIPNode> ping) {
        for (SIPNode pingNode : ping) {
            InvocationContext ctx = this.balancerRunner.getInvocationContext((String)((Object)pingNode.getProperties().get("version")));
            ctx.nodes.remove(pingNode);
            boolean nodePresent = false;
            Iterator<SIPNode> nodesIterator = this.balancerRunner.balancerContext.aliveNodes.iterator();
            while (nodesIterator.hasNext() && !nodePresent) {
                SIPNode node = nodesIterator.next();
                if (!node.equals(pingNode)) continue;
                nodePresent = true;
            }
            if (!nodePresent) continue;
            this.balancerRunner.balancerContext.aliveNodes.remove(pingNode);
            ctx.balancerAlgorithm.nodeRemoved(pingNode);
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("NodeExpirationTimerTask Run NSync[" + pingNode + "] forcibly removed due to a clean shutdown of a node. Numbers of nodes present in the balancer : " + this.balancerRunner.balancerContext.aliveNodes.size()));
        }
    }

    public InetAddress getAddress() {
        return this.serverAddress;
    }

    public long getNodeExpiration() {
        return this.nodeExpiration;
    }

    public long getNodeExpirationTaskInterval() {
        return this.nodeInfoExpirationTaskInterval;
    }

    public void setNodeExpiration(long value) throws IllegalArgumentException {
        if (value < 15L) {
            throw new IllegalArgumentException("Value cant be less than 15");
        }
        this.nodeExpiration = value;
    }

    public void setNodeExpirationTaskInterval(long value) {
        if (value < 15L) {
            throw new IllegalArgumentException("Value cant be less than 15");
        }
        this.nodeInfoExpirationTaskInterval = value;
    }

    @Override
    public SIPNode[] getAllNodes() {
        return this.balancerRunner.balancerContext.aliveNodes.toArray(new SIPNode[0]);
    }

    @Override
    public SIPNode getNextNode() throws IndexOutOfBoundsException {
        return null;
    }

    @Override
    public void jvmRouteSwitchover(String fromJvmRoute, String toJvmRoute) {
        for (InvocationContext ctx : this.balancerRunner.contexts.values()) {
            ctx.balancerAlgorithm.jvmRouteSwitchover(fromJvmRoute, toJvmRoute);
        }
    }

    class NodeExpirationTimerTask
    extends TimerTask {
        NodeExpirationTimerTask() {
        }

        @Override
        public void run() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"NodeExpirationTimerTask Running");
            }
            for (SIPNode node : NodeRegisterImpl.this.balancerRunner.balancerContext.aliveNodes) {
                long expirationTime = node.getTimeStamp() + NodeRegisterImpl.this.nodeExpiration;
                if (expirationTime < System.currentTimeMillis()) {
                    InvocationContext ctx = NodeRegisterImpl.this.balancerRunner.getInvocationContext((String)((Object)node.getProperties().get("version")));
                    NodeRegisterImpl.this.balancerRunner.balancerContext.aliveNodes.remove(node);
                    ctx.nodes.remove(node);
                    ctx.balancerAlgorithm.nodeRemoved(node);
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("NodeExpirationTimerTask Run NSync[" + node + "] removed. Last timestamp: " + node.getTimeStamp() + ", current: " + System.currentTimeMillis() + " diff=" + ((double)System.currentTimeMillis() - (double)node.getTimeStamp()) + "ms and tolerance=" + NodeRegisterImpl.this.nodeExpiration + " ms"));
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("node time stamp : " + expirationTime + " , current time : " + System.currentTimeMillis()));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"NodeExpirationTimerTask Done");
            }
        }
    }

    public static class BindingAddressCorrectnessSocketFactory
    extends RMISocketFactory
    implements Serializable {
        private InetAddress bindingAddress = null;

        public BindingAddressCorrectnessSocketFactory() {
        }

        public BindingAddressCorrectnessSocketFactory(InetAddress ipInterface) {
            this.bindingAddress = ipInterface;
        }

        @Override
        public ServerSocket createServerSocket(int port) {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(port, 50, this.bindingAddress);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return serverSocket;
        }

        @Override
        public Socket createSocket(String dummy, int port) throws IOException {
            return new Socket(this.bindingAddress, port);
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass();
        }
    }

    private class RegisterRMIStub
    extends UnicastRemoteObject
    implements NodeRegisterRMIStub {
        protected RegisterRMIStub() throws RemoteException {
        }

        @Override
        public void handlePing(ArrayList<SIPNode> ping) throws RemoteException {
            NodeRegisterImpl.this.handlePingInRegister(ping);
        }

        @Override
        public void forceRemoval(ArrayList<SIPNode> ping) throws RemoteException {
            NodeRegisterImpl.this.forceRemovalInRegister(ping);
        }

        @Override
        public void switchover(String fromJvmRoute, String toJvmRoute) throws RemoteException {
            NodeRegisterImpl.this.jvmRouteSwitchover(fromJvmRoute, toJvmRoute);
        }
    }
}

