/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.DefaultBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.SIPNode;

public class InvocationContext {
    Logger logger = Logger.getLogger((String)InvocationContext.class.getCanonicalName());
    public DefaultBalancerAlgorithm balancerAlgorithm;
    public CopyOnWriteArrayList<SIPNode> nodes = new CopyOnWriteArrayList();
    public String version;
    private ConcurrentHashMap<String, Object> attribs = new ConcurrentHashMap();

    public InvocationContext(String version, BalancerContext balancerContext) {
        this.version = version;
        try {
            Class<?> clazz = Class.forName(balancerContext.algorithmClassName);
            this.balancerAlgorithm = (DefaultBalancerAlgorithm)clazz.newInstance();
            this.balancerAlgorithm.balancerContext = balancerContext;
            this.balancerAlgorithm.setProperties(balancerContext.properties);
            this.balancerAlgorithm.setInvocationContext(this);
            this.logger.info((Object)("Balancer algorithm " + balancerContext.algorithmClassName + " loaded succesfully" + " for cluster version = " + version));
            this.balancerAlgorithm.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading the algorithm class: " + balancerContext.algorithmClassName, e);
        }
    }

    public Object getAttribute(String name) {
        return this.attribs.get(name);
    }

    public void setAttribute(String name, Object val) {
        this.attribs.put(name, val);
    }

    public void removeAttribute(String name) {
        this.attribs.remove(name);
    }
}

