/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.Via;
import java.util.Collections;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.DefaultBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.InvocationContext;
import org.mobicents.tools.sip.balancer.SIPNode;

public class HeaderConsistentHashBalancerAlgorithm
extends DefaultBalancerAlgorithm {
    private static Logger logger = Logger.getLogger((String)HeaderConsistentHashBalancerAlgorithm.class.getName());
    protected String sipHeaderAffinityKey;
    protected String httpAffinityKey;
    private SortedSet<SIPNode> nodes = Collections.synchronizedSortedSet(new TreeSet());
    protected Object[] nodesArray;
    protected boolean nodesAreDirty = true;

    public HeaderConsistentHashBalancerAlgorithm() {
    }

    public HeaderConsistentHashBalancerAlgorithm(String headerName) {
        this.sipHeaderAffinityKey = headerName == null ? "Call-ID" : headerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SIPNode processExternalRequest(Request request) {
        Integer nodeIndex;
        if (this.nodesAreDirty) {
            HeaderConsistentHashBalancerAlgorithm headerConsistentHashBalancerAlgorithm = this;
            synchronized (headerConsistentHashBalancerAlgorithm) {
                this.syncNodes();
            }
        }
        if ((nodeIndex = this.hashHeader((Message)request)) < 0) {
            return null;
        }
        try {
            SIPNode node = (SIPNode)this.nodesArray[nodeIndex];
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public synchronized void nodeAdded(SIPNode node) {
        this.nodes.add(node);
        this.nodesArray = this.nodes.toArray(new Object[0]);
        this.nodesAreDirty = false;
    }

    @Override
    public synchronized void nodeRemoved(SIPNode node) {
        this.nodes.remove(node);
        this.nodesArray = this.nodes.toArray(new Object[0]);
        this.nodesAreDirty = false;
    }

    private void dumpNodes() {
        System.out.println("0----------------------------------------------------0");
        for (Object object : this.nodesArray) {
            SIPNode node = (SIPNode)object;
            System.out.println(node);
        }
    }

    protected Integer hashHeader(Message message) {
        String headerValue = null;
        headerValue = this.sipHeaderAffinityKey.equals("from.user") ? ((SipURI)((FromHeader)message.getHeader("From")).getAddress().getURI()).getUser() : (this.sipHeaderAffinityKey.equals("to.user") ? ((SipURI)((ToHeader)message.getHeader("To")).getAddress().getURI()).getUser() : ((SIPHeader)message.getHeader(this.sipHeaderAffinityKey)).getValue());
        if (this.nodesArray.length == 0) {
            throw new RuntimeException("No Application Servers registered. All servers are dead.");
        }
        int nodeIndex = this.hashAffinityKeyword(headerValue);
        if (this.isAlive((SIPNode)this.nodesArray[nodeIndex])) {
            return nodeIndex;
        }
        return -1;
    }

    protected boolean isAlive(SIPNode node) {
        return this.invocationContext.nodes.contains(node);
    }

    public SIPNode processHttpRequest(HttpRequest request, InvocationContext context) {
        String affinityKeyword = this.getUrlParameters(request.getUri()).get(this.httpAffinityKey);
        if (affinityKeyword == null) {
            return super.processHttpRequest(request);
        }
        return (SIPNode)this.nodesArray[this.hashAffinityKeyword(affinityKeyword)];
    }

    protected int hashAffinityKeyword(String keyword) {
        int nodeIndex = Math.abs(keyword.hashCode()) % this.nodesArray.length;
        SIPNode computedNode = (SIPNode)this.nodesArray[nodeIndex];
        if (!this.isAlive(computedNode)) {
            for (int q = 0; q < this.nodesArray.length && !this.isAlive((SIPNode)this.nodesArray[nodeIndex = (nodeIndex + 1) % this.nodesArray.length]); ++q) {
            }
        }
        return nodeIndex;
    }

    HashMap<String, String> getUrlParameters(String url) {
        String[] tokens;
        HashMap<String, String> parameters = new HashMap<String, String>();
        int start = url.lastIndexOf(63);
        if (start <= 0 || url.length() <= start + 1) {
            return parameters;
        }
        url = url.substring(start + 1);
        for (String token : tokens = url.split("&")) {
            String[] params = token.split("=");
            if (params.length < 2) {
                parameters.put(token, "");
                continue;
            }
            parameters.put(params[0], params[1]);
        }
        return parameters;
    }

    @Override
    public void init() {
        this.httpAffinityKey = this.getProperties().getProperty("httpAffinityKey", "appsession");
        this.sipHeaderAffinityKey = this.getProperties().getProperty("sipHeaderAffinityKey", "Call-ID");
        logger.info((Object)("SIP affinity key = " + this.sipHeaderAffinityKey + " HTTP key = " + this.httpAffinityKey));
    }

    @Override
    public void configurationChanged() {
        logger.info((Object)"Configuration changed");
        this.httpAffinityKey = this.getProperties().getProperty("httpAffinityKey", "appsession");
        this.sipHeaderAffinityKey = this.getProperties().getProperty("sipHeaderAffinityKey", "Call-ID");
    }

    @Override
    public void processExternalResponse(Response response) {
        this.processExternalResponse(response, this.invocationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExternalResponse(Response response, InvocationContext context) {
        block15: {
            Integer nodeIndex = this.hashHeader((Message)response);
            BalancerContext balancerContext = this.getBalancerContext();
            Via via = (Via)response.getHeader("Via");
            String host = via.getHost();
            Integer port = via.getPort();
            String transport = via.getTransport().toLowerCase();
            boolean found = false;
            for (SIPNode node : context.nodes) {
                if (!node.getIp().equals(host) || !port.equals(node.getProperties().get(transport + "Port"))) continue;
                found = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("external response node found ? " + found));
            }
            if (!found) {
                if (this.nodesAreDirty) {
                    HeaderConsistentHashBalancerAlgorithm i$ = this;
                    synchronized (i$) {
                        this.syncNodes();
                    }
                }
                try {
                    SIPNode node = (SIPNode)this.nodesArray[nodeIndex];
                    if (node == null || !context.nodes.contains(node)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("No node to handle " + via));
                        }
                        break block15;
                    }
                    String transportProperty = transport + "Port";
                    port = (Integer)node.getProperties().get(transportProperty);
                    if (!via.getHost().equalsIgnoreCase(node.getIp()) && via.getPort() == port.intValue()) break block15;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("changing retransmission via " + via + "setting new values " + node.getIp() + ":" + port));
                    }
                    try {
                        via.setHost(node.getIp());
                        via.setPort(port.intValue());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error setting new values " + node.getIp() + ":" + port + " on via " + via, e);
                    }
                    if (!"UDP".equalsIgnoreCase(transport)) {
                        via.setRPort();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    protected void syncNodes() {
        this.nodes.clear();
        this.nodes.addAll(this.invocationContext.nodes);
        this.nodesArray = this.nodes.toArray(new Object[0]);
        this.nodesAreDirty = false;
    }
}

