/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.mobicents.tools.sip.balancer.CallIDAffinityBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.SIPNode;

public class ClusterSubdomainAffinityAlgorithm
extends CallIDAffinityBalancerAlgorithm {
    private static Logger logger = Logger.getLogger((String)ClusterSubdomainAffinityAlgorithm.class.getCanonicalName());
    protected ConcurrentHashMap<String, List<String>> nodeToNodeGroup = new ConcurrentHashMap();

    @Override
    protected SIPNode selectNewNode(SIPNode node, String callId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The assigned node has died. This is the dead node: " + node));
        }
        SIPNode oldNode = node;
        List<String> alternativeNodes = this.nodeToNodeGroup.get(oldNode.getIp());
        for (SIPNode check : this.invocationContext.nodes) {
            for (String alt : alternativeNodes) {
                if (!check.getIp().equals(alt)) continue;
                this.groupedFailover(oldNode, check);
                logger.info((Object)("Grouped failover to partner node from " + oldNode + " to " + check));
                return check;
            }
        }
        logger.info((Object)("No alternatives found for " + oldNode + " from " + alternativeNodes));
        return super.selectNewNode(oldNode, callId);
    }

    @Override
    public void init() {
        super.init();
        String subclusterMap = this.getProperties().getProperty("subclusterMap");
        logger.info((Object)("Subcluster map: " + subclusterMap));
        this.loadSubclusters(subclusterMap);
        logger.info((Object)("Grouped failover is set to " + this.groupedFailover));
    }

    public void loadSubclusters(String subclustersString) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        if (subclustersString != null) {
            subclustersString = subclustersString.replaceAll(" ", "");
            String[] groups = subclustersString.split("\\)\\(");
            for (int q = 0; q < groups.length; ++q) {
                String group = groups[q];
                group = group.replaceAll("\\(", "").replaceAll("\\)", "");
                String[] hosts = group.split(",");
                LinkedList<String> hostGroupList = new LinkedList<String>();
                for (String host : hosts) {
                    if (host.length() <= 0) continue;
                    if (hostGroupList.contains(host)) {
                        throw new RuntimeException("Duplicate host " + host + " in " + hosts);
                    }
                    hostGroupList.add(host);
                }
                for (String host : hosts) {
                    LinkedList tmp = new LinkedList(hostGroupList);
                    tmp.remove(host);
                    map.put(host, tmp);
                }
            }
        }
        this.nodeToNodeGroup = map;
    }

    public String dumpSubcluster() {
        String result = "";
        for (String host : this.nodeToNodeGroup.keySet()) {
            String mapped = host + ": " + this.nodeToNodeGroup.get(host);
            result = result + mapped + "\n";
        }
        return result;
    }

    @Override
    public void configurationChanged() {
        super.configurationChanged();
        try {
            this.loadSubclusters(this.getProperties().getProperty("subclusterMap"));
            logger.info((Object)("Subclusters reloaded. The groups are as follows:" + this.dumpSubcluster()));
        }
        catch (Exception e) {
            logger.error((Object)"Subcluster changes were unsuccesful", (Throwable)e);
        }
    }
}

