/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.Via;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.tools.sip.balancer.DefaultBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.SIPNode;

public class CallIDAffinityBalancerAlgorithm
extends DefaultBalancerAlgorithm {
    private static Logger logger = Logger.getLogger((String)CallIDAffinityBalancerAlgorithm.class.getCanonicalName());
    protected String headerName = "Call-ID";
    protected ConcurrentHashMap<String, SIPNode> callIdMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Long> callIdTimestamps = new ConcurrentHashMap();
    protected AtomicInteger nextNodeCounter = new AtomicInteger(0);
    protected int maxCallIdleTime = 500;
    protected boolean groupedFailover = false;
    protected Timer cacheEvictionTimer = new Timer();

    @Override
    public void processInternalRequest(Request request) {
        logger.debug((Object)"internal request");
    }

    @Override
    public void processInternalResponse(Response response) {
        logger.debug((Object)"internal response");
    }

    @Override
    public void processExternalResponse(Response response) {
        Via via = (Via)response.getHeader("Via");
        String host = via.getHost();
        Integer port = via.getPort();
        String transport = via.getTransport().toLowerCase();
        boolean found = false;
        for (SIPNode node : this.invocationContext.nodes) {
            if (!node.getIp().equals(host) || !port.equals(node.getProperties().get(transport + "Port"))) continue;
            found = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("external response node found ? " + found));
        }
        if (!found) {
            SIPNode node;
            String callId = ((SIPHeader)response.getHeader(this.headerName)).getValue();
            node = this.callIdMap.get(callId);
            if (node == null || !this.invocationContext.nodes.contains(node)) {
                node = this.selectNewNode(node, callId);
                String transportProperty = transport + "Port";
                port = (Integer)node.getProperties().get(transportProperty);
                if (port == null) {
                    throw new RuntimeException("No transport found for node " + node + " " + transportProperty);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("changing via " + via + "setting new values " + node.getIp() + ":" + port));
                }
                try {
                    via.setHost(node.getIp());
                    via.setPort(port.intValue());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error setting new values " + node.getIp() + ":" + port + " on via " + via, e);
                }
                if (!"UDP".equalsIgnoreCase(transport)) {
                    via.setRPort();
                }
            } else {
                String transportProperty = transport + "Port";
                port = (Integer)node.getProperties().get(transportProperty);
                if (via.getHost().equalsIgnoreCase(node.getIp()) || via.getPort() != port.intValue()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("changing retransmission via " + via + "setting new values " + node.getIp() + ":" + port));
                    }
                    try {
                        via.setHost(node.getIp());
                        via.setPort(port.intValue());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error setting new values " + node.getIp() + ":" + port + " on via " + via, e);
                    }
                    if (!"UDP".equalsIgnoreCase(transport)) {
                        via.setRPort();
                    }
                }
            }
        }
    }

    @Override
    public SIPNode processExternalRequest(Request request) {
        String callId = ((SIPHeader)request.getHeader(this.headerName)).getValue();
        SIPNode node = this.callIdMap.get(callId);
        this.callIdTimestamps.put(callId, System.currentTimeMillis());
        if (node == null) {
            node = this.nextAvailableNode();
            if (node == null) {
                return null;
            }
            this.callIdMap.put(callId, node);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No node found in the affinity map. It is null. We select new node: " + node));
            }
        } else if (!this.invocationContext.nodes.contains(node)) {
            node = this.selectNewNode(node, callId);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("The assigned node in the affinity map is still alive: " + node));
        }
        return node;
    }

    protected SIPNode selectNewNode(SIPNode node, String callId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The assigned node has died. This is the dead node: " + node));
        }
        if (this.groupedFailover) {
            SIPNode oldNode = node;
            if ((node = this.leastBusyTargetNode(oldNode)) == null) {
                return null;
            }
            this.groupedFailover(oldNode, node);
        } else {
            node = this.nextAvailableNode();
            if (node == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"no nodes available return null");
                }
                return null;
            }
            this.callIdMap.put(callId, node);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("So, we must select new node: " + node));
        }
        return node;
    }

    protected synchronized SIPNode nextAvailableNode() {
        if (this.invocationContext.nodes.size() == 0) {
            return null;
        }
        int nextNode = this.nextNodeCounter.incrementAndGet();
        return this.invocationContext.nodes.get(nextNode %= this.invocationContext.nodes.size());
    }

    protected synchronized SIPNode leastBusyTargetNode(SIPNode deadNode) {
        HashMap<SIPNode, Integer> nodeUtilization = new HashMap<SIPNode, Integer>();
        for (SIPNode node : this.callIdMap.values()) {
            Integer n = (Integer)nodeUtilization.get(node);
            if (n == null) {
                nodeUtilization.put(node, 0);
                continue;
            }
            nodeUtilization.put(node, n + 1);
        }
        int minUtil = Integer.MAX_VALUE;
        SIPNode minUtilNode = null;
        for (SIPNode node : nodeUtilization.keySet()) {
            Integer util = (Integer)nodeUtilization.get(node);
            if (node.equals(deadNode) || util >= minUtil) continue;
            minUtil = util;
            minUtilNode = node;
        }
        logger.info((Object)("Least busy node selected " + minUtilNode + " with " + minUtil + " calls"));
        return minUtilNode;
    }

    @Override
    public void init() {
        String groupFailoverProperty;
        String maxTimeInCacheString;
        if (this.getProperties() != null && (maxTimeInCacheString = this.getProperties().getProperty("callIdAffinityMaxTimeInCache")) != null) {
            this.maxCallIdleTime = Integer.parseInt(maxTimeInCacheString);
        }
        logger.info((Object)("Call Idle Time is " + this.maxCallIdleTime + " seconds. Inactive calls will be evicted."));
        final CallIDAffinityBalancerAlgorithm thisAlgorithm = this;
        this.cacheEvictionTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CallIDAffinityBalancerAlgorithm callIDAffinityBalancerAlgorithm = thisAlgorithm;
                    synchronized (callIDAffinityBalancerAlgorithm) {
                        ArrayList<String> oldCalls = new ArrayList<String>();
                        for (String key : CallIDAffinityBalancerAlgorithm.this.callIdTimestamps.keySet()) {
                            long time = CallIDAffinityBalancerAlgorithm.this.callIdTimestamps.get(key);
                            if (System.currentTimeMillis() - time <= (long)(1000 * CallIDAffinityBalancerAlgorithm.this.maxCallIdleTime)) continue;
                            oldCalls.add(key);
                        }
                        for (String key : oldCalls) {
                            CallIDAffinityBalancerAlgorithm.this.callIdMap.remove(key);
                            CallIDAffinityBalancerAlgorithm.this.callIdTimestamps.remove(key);
                        }
                        if (oldCalls.size() > 0) {
                            logger.info((Object)("Reaping idle calls... Evicted " + oldCalls.size() + " calls."));
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to clean up old calls. If you continue to se this message frequestly and the memory is growing, report this problem.", (Throwable)e);
                }
            }
        }, 0L, 6000L);
        if (this.getProperties() != null && (groupFailoverProperty = this.getProperties().getProperty("callIdAffinityGroupFailover")) != null) {
            this.groupedFailover = Boolean.parseBoolean(groupFailoverProperty);
        }
        logger.info((Object)("Grouped failover is set to " + this.groupedFailover));
    }

    @Override
    public void configurationChanged() {
        this.cacheEvictionTimer.cancel();
        this.cacheEvictionTimer = new Timer();
        this.init();
    }

    @Override
    public void assignToNode(String id, SIPNode node) {
        this.callIdMap.put(id, node);
        this.callIdTimestamps.put(id, System.currentTimeMillis());
    }

    @Override
    public void jvmRouteSwitchover(String fromJvmRoute, String toJvmRoute) {
        block7: {
            try {
                SIPNode oldNode = this.getBalancerContext().jvmRouteToSipNode.get(fromJvmRoute);
                SIPNode newNode = this.getBalancerContext().jvmRouteToSipNode.get(toJvmRoute);
                if (oldNode != null && newNode != null) {
                    int updatedRoutes = 0;
                    for (String key : this.callIdMap.keySet()) {
                        SIPNode n = this.callIdMap.get(key);
                        if (!n.equals(oldNode)) continue;
                        this.callIdMap.replace(key, newNode);
                        ++updatedRoutes;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Switchover occured where fromJvmRoute=" + fromJvmRoute + " and toJvmRoute=" + toJvmRoute + " with " + updatedRoutes + " updated routes."));
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("Switchover failed where fromJvmRoute=" + fromJvmRoute + " and toJvmRoute=" + toJvmRoute));
                }
            }
            catch (Throwable t) {
                if (!logger.isInfoEnabled()) break block7;
                logger.info((Object)("Switchover failed where fromJvmRoute=" + fromJvmRoute + " and toJvmRoute=" + toJvmRoute));
                logger.info((Object)"This is not a fatal failure, logging the reason for the failure ", t);
            }
        }
    }

    public synchronized void groupedFailover(SIPNode oldNode, SIPNode newNode) {
        block7: {
            try {
                if (oldNode != null && newNode != null) {
                    int updatedRoutes = 0;
                    for (String key : this.callIdMap.keySet()) {
                        SIPNode n = this.callIdMap.get(key);
                        if (!n.equals(oldNode)) continue;
                        this.callIdMap.replace(key, newNode);
                        ++updatedRoutes;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Switchover occured where oldNode=" + oldNode + " and newNode=" + newNode + " with " + updatedRoutes + " updated routes."));
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("Switchover failed where fromJvmRoute=" + oldNode + " and toJvmRoute=" + newNode));
                }
            }
            catch (Throwable t) {
                if (!logger.isInfoEnabled()) break block7;
                logger.info((Object)("Switchover failed where fromJvmRoute=" + oldNode + " and toJvmRoute=" + newNode));
                logger.info((Object)"This is not a fatal failure, logging the reason for the failure ", t);
            }
        }
    }
}

