/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.netty.channel.ChannelException;
import org.mobicents.tools.http.balancer.HttpBalancerForwarder;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.BalancerRunnerMBean;
import org.mobicents.tools.sip.balancer.CallIDAffinityBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.InvocationContext;
import org.mobicents.tools.sip.balancer.NodeRegisterImpl;
import org.mobicents.tools.sip.balancer.RouterImpl;
import org.mobicents.tools.sip.balancer.SIPBalancerForwarder;
import org.mobicents.tools.sip.balancer.SIPNode;
import org.mobicents.tools.sip.balancer.SipBalancerShutdownHook;

public class BalancerRunner
implements BalancerRunnerMBean {
    private static final String NODE_TIMEOUT = "nodeTimeout";
    private static final String HEARTBEAT_INTERVAL = "heartbeatInterval";
    private static final String HOST_PROP = "host";
    private static final String RMI_REGISTRY_PORT_PROP = "rmiRegistryPort";
    private static final String JMX_HTML_ADAPTER_PORT_PROP = "jmxHtmlAdapterPort";
    private static final String ALGORITHM_PROP = "algorithmClass";
    private static final String DEFAULT_ALGORITHM = CallIDAffinityBalancerAlgorithm.class.getCanonicalName();
    public static final String SIP_BALANCER_JMX_NAME = "mobicents:type=LoadBalancer,name=LoadBalancer";
    public static final String HTML_ADAPTOR_PORT = "8000";
    public static final String REGISTRY_PORT = "2000";
    public static final String HTML_ADAPTOR_JMX_NAME = "mobicents:name=htmladapter,port=";
    ConcurrentHashMap<String, InvocationContext> contexts = new ConcurrentHashMap();
    private static Logger logger;
    protected SIPBalancerForwarder sipForwarder = null;
    protected NodeRegisterImpl reg = null;
    HtmlAdaptorServer adapter = new HtmlAdaptorServer();
    ObjectName adapterName = null;
    JMXConnectorServer cs = null;
    HttpBalancerForwarder httpBalancerForwarder;
    public BalancerContext balancerContext = new BalancerContext();
    public String algorithClassName = null;
    Timer timer;
    long lastupdate = 0L;

    public InvocationContext getInvocationContext(String version) {
        InvocationContext ct;
        if (version == null) {
            version = "0";
        }
        if ((ct = this.contexts.get(version)) == null) {
            ct = new InvocationContext(version, this.balancerContext);
            this.contexts.put(version, ct);
        }
        return ct;
    }

    public InvocationContext getLatestInvocationContext() {
        return this.getInvocationContext(this.reg.getLatestVersion());
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            logger.error((Object)"Please specify mobicents-balancer-config argument. Usage is : java -DlogConfigFile=./lb-log4j.xml -jar sip-balancer-jar-with-dependencies.jar -mobicents-balancer-config=lb-configuration.properties");
            return;
        }
        if (!args[0].startsWith("-mobicents-balancer-config=")) {
            logger.error((Object)"Impossible to find the configuration file since you didn't specify the mobicents-balancer-config argument. Usage is : java -DlogConfigFile=./lb-log4j.xml -jar sip-balancer-jar-with-dependencies.jar -mobicents-balancer-config=lb-configuration.properties");
            return;
        }
        String configurationFileLocation = args[0].substring("-mobicents-balancer-config=".length());
        BalancerRunner balancerRunner = new BalancerRunner();
        balancerRunner.start(configurationFileLocation);
    }

    public void start(Properties properties) {
        String ipAddress = properties.getProperty(HOST_PROP);
        if (ipAddress == null) {
            ipAddress = properties.getProperty("internalHost");
        }
        if (ipAddress == null) {
            ipAddress = properties.getProperty("externalHost");
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            logger.error((Object)("Couldn't get the InetAddress from the host " + ipAddress), (Throwable)e);
            return;
        }
        int jmxHtmlPort = -1;
        String portAsString = properties.getProperty(JMX_HTML_ADAPTER_PORT_PROP, HTML_ADAPTOR_PORT);
        try {
            jmxHtmlPort = Integer.parseInt(portAsString);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)"Couldn't convert jmxHtmlAdapterPort to a valid integer", (Throwable)nfe);
            return;
        }
        int rmiRegistryPort = -1;
        portAsString = properties.getProperty(RMI_REGISTRY_PORT_PROP, REGISTRY_PORT);
        try {
            rmiRegistryPort = Integer.parseInt(portAsString);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)"Couldn't convert rmiRegistryPort to a valid integer", (Throwable)nfe);
            return;
        }
        this.balancerContext.algorithmClassName = this.algorithClassName = properties.getProperty(ALGORITHM_PROP, DEFAULT_ALGORITHM);
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            this.adapterName = new ObjectName(HTML_ADAPTOR_JMX_NAME + jmxHtmlPort);
            this.adapter.setPort(jmxHtmlPort);
            server.registerMBean(this.adapter, this.adapterName);
            RouterImpl.setRegister(this.reg);
            this.reg = new NodeRegisterImpl(addr);
            this.reg.balancerRunner = this;
            try {
                this.reg.setNodeExpirationTaskInterval(Integer.parseInt(properties.getProperty(HEARTBEAT_INTERVAL, "150")));
                this.reg.setNodeExpiration(Integer.parseInt(properties.getProperty(NODE_TIMEOUT, "10200")));
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("nodeTimeout=" + this.reg.getNodeExpiration()));
                    logger.info((Object)("heartbeatInterval=" + this.reg.getNodeExpirationTaskInterval()));
                }
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)"Couldn't convert rmiRegistryPort to a valid integer", (Throwable)nfe);
                return;
            }
            this.reg.startRegistry(rmiRegistryPort);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"adding shutdown hook");
            }
            this.sipForwarder = new SIPBalancerForwarder(properties, this, this.reg);
            this.sipForwarder.start();
            this.httpBalancerForwarder = new HttpBalancerForwarder();
            this.httpBalancerForwarder.balancerRunner = this;
            try {
                this.httpBalancerForwarder.start();
            }
            catch (ChannelException e) {
                logger.warn((Object)"HTTP forwarder could not be restarted.");
            }
            ObjectName on = new ObjectName(SIP_BALANCER_JMX_NAME);
            if (server.isRegistered(on)) {
                server.unregisterMBean(on);
            }
            server.registerMBean(this, on);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + ipAddress + ":" + rmiRegistryPort + "/server");
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, server);
            this.cs.start();
            this.adapter.start();
            Runtime.getRuntime().addShutdownHook(new SipBalancerShutdownHook(this));
        }
        catch (Exception e) {
            logger.error((Object)"An unexpected error occurred while starting the load balancer", (Throwable)e);
            return;
        }
    }

    @Override
    public void start(final String configurationFileLocation) {
        File file = new File(configurationFileLocation);
        this.lastupdate = file.lastModified();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("the configuration file location " + configurationFileLocation + " does not exists !");
        }
        Properties properties = new Properties(System.getProperties());
        try {
            properties.load(fileInputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to load the properties configuration file located at " + configurationFileLocation);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                logger.warn((Object)("Problem closing file " + e));
            }
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File conf = new File(configurationFileLocation);
                if (BalancerRunner.this.lastupdate < conf.lastModified()) {
                    BalancerRunner.this.lastupdate = conf.lastModified();
                    logger.info((Object)"Configuration file changed, applying changes.");
                    FileInputStream fileInputStream = null;
                    try {
                        for (InvocationContext ctx : BalancerRunner.this.contexts.values()) {
                            fileInputStream = new FileInputStream(conf);
                            BalancerRunner.this.balancerContext.properties.load(fileInputStream);
                            ctx.balancerAlgorithm.configurationChanged();
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Problem reloading configuration " + e));
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Exception e) {
                                logger.error((Object)("Problem closing stream " + e));
                            }
                        }
                    }
                }
            }
        }, 3000L, 2000L);
        this.start(properties);
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        logger.info((Object)"Stopping the sip forwarder");
        this.sipForwarder.stop();
        logger.info((Object)"Stopping the http forwarder");
        this.httpBalancerForwarder.stop();
        logger.info((Object)"Unregistering the node registry");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName on = new ObjectName(SIP_BALANCER_JMX_NAME);
            if (server.isRegistered(on)) {
                server.unregisterMBean(on);
            }
            if (server.isRegistered(this.adapterName)) {
                server.unregisterMBean(this.adapterName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"An unexpected error occurred while stopping the load balancer", (Throwable)e);
        }
        try {
            if (this.cs != null) {
                if (this.cs.isActive()) {
                    this.cs.stop();
                }
                this.cs = null;
                for (InvocationContext ctx : this.contexts.values()) {
                    ctx.balancerAlgorithm.stop();
                }
                this.adapter.stop();
                logger.info((Object)"Stopping the node registry");
                this.reg.stopRegistry();
                this.reg = null;
                this.adapter = null;
                System.gc();
            }
        }
        catch (Exception e) {
            logger.error((Object)"An unexpected error occurred while stopping the load balancer", (Throwable)e);
        }
    }

    @Override
    public long getNodeExpiration() {
        return this.reg.getNodeExpiration();
    }

    @Override
    public long getNodeExpirationTaskInterval() {
        return this.reg.getNodeExpirationTaskInterval();
    }

    @Override
    public long getNumberOfRequestsProcessed() {
        return this.sipForwarder.getNumberOfRequestsProcessed();
    }

    @Override
    public long getNumberOfResponsesProcessed() {
        return this.sipForwarder.getNumberOfResponsesProcessed();
    }

    @Override
    public Map<String, AtomicLong> getNumberOfRequestsProcessedByMethod() {
        return this.sipForwarder.getNumberOfRequestsProcessedByMethod();
    }

    @Override
    public Map<String, AtomicLong> getNumberOfResponsesProcessedByStatusCode() {
        return this.sipForwarder.getNumberOfResponsesProcessedByStatusCode();
    }

    @Override
    public long getRequestsProcessedByMethod(String method) {
        return this.sipForwarder.getRequestsProcessedByMethod(method);
    }

    @Override
    public long getResponsesProcessedByStatusCode(String statusCode) {
        return this.sipForwarder.getResponsesProcessedByStatusCode(statusCode);
    }

    @Override
    public void setNodeExpiration(long value) {
        this.reg.setNodeExpiration(value);
    }

    @Override
    public void setNodeExpirationTaskInterval(long value) {
        this.reg.setNodeExpirationTaskInterval(value);
    }

    @Override
    public List<SIPNode> getNodes() {
        return new LinkedList<SIPNode>(this.balancerContext.aliveNodes);
    }

    @Override
    public String[] getNodeList() {
        List<SIPNode> nodes = this.getNodes();
        String[] nodeList = new String[nodes.size()];
        int i = 0;
        for (SIPNode node : nodes) {
            nodeList[i] = node.toString();
            ++i;
        }
        return nodeList;
    }

    @Override
    public Properties getProperties() {
        return this.balancerContext.properties;
    }

    @Override
    public String getProperty(String key) {
        return this.balancerContext.properties.getProperty(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.balancerContext.properties.setProperty(key, value);
        for (InvocationContext ctx : this.contexts.values()) {
            ctx.balancerAlgorithm.configurationChanged();
        }
    }

    static {
        String logLevel = System.getProperty("logLevel", "INFO");
        String logConfigFile = System.getProperty("logConfigFile");
        if (logConfigFile == null) {
            Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r (%t) %p [%c{1}%x] %m%n")));
            Logger.getRootLogger().setLevel(Level.toLevel((String)logLevel));
        } else {
            DOMConfigurator.configure((String)logConfigFile);
        }
        logger = Logger.getLogger((String)BalancerRunner.class.getCanonicalName());
    }
}

