/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.http.balancer;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.mobicents.tools.http.balancer.HttpRequestHandler;
import org.mobicents.tools.sip.balancer.BalancerRunner;

public class HttpServerPipelineFactory
implements ChannelPipelineFactory {
    BalancerRunner balancerRunner;
    int maxContentLength = 0x100000;

    public HttpServerPipelineFactory(BalancerRunner balancerRunner, int maxContentLength) {
        this.balancerRunner = balancerRunner;
        this.maxContentLength = maxContentLength;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.maxContentLength));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("handler", (ChannelHandler)new HttpRequestHandler(this.balancerRunner));
        return pipeline;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }
}

