/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.http.balancer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.mobicents.tools.http.balancer.HttpChannelAssociations;
import org.mobicents.tools.sip.balancer.BalancerRunner;
import org.mobicents.tools.sip.balancer.InvocationContext;
import org.mobicents.tools.sip.balancer.SIPNode;

public class HttpRequestHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger((String)HttpRequestHandler.class.getCanonicalName());
    private volatile HttpRequest request;
    private volatile boolean readingChunks;
    private BalancerRunner balancerRunner;

    public HttpRequestHandler(BalancerRunner balancerRunner) {
        this.balancerRunner = balancerRunner;
    }

    public void messageReceived(ChannelHandlerContext ctx, final MessageEvent e) throws Exception {
        if (!this.readingChunks) {
            this.request = (HttpRequest)e.getMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request URI accessed: " + this.request.getUri() + " channel " + e.getChannel()));
            }
            Channel associatedChannel = HttpChannelAssociations.channels.get(e.getChannel());
            InvocationContext invocationContext = this.balancerRunner.getLatestInvocationContext();
            SIPNode node = null;
            try {
                node = invocationContext.balancerAlgorithm.processHttpRequest(this.request);
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                logger.warn((Object)"Problem in balancer algorithm", (Throwable)ex);
                this.writeResponse(e, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Load Balancer Error: Exception in the balancer algorithm:\n" + sw.toString());
                return;
            }
            if (node == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Service unavailable. No server is available.");
                }
                this.writeResponse(e, HttpResponseStatus.SERVICE_UNAVAILABLE, "Service is temporarily unavailable");
                return;
            }
            if (associatedChannel != null && associatedChannel.isConnected()) {
                associatedChannel.write((Object)this.request);
            } else {
                e.getChannel().getCloseFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture arg0) throws Exception {
                        HttpRequestHandler.this.closeChannelPair(arg0.getChannel());
                    }
                });
                ChannelFuture future = HttpChannelAssociations.inboundBootstrap.connect((SocketAddress)new InetSocketAddress(node.getIp(), (int)((Integer)node.getProperties().get("httpPort"))));
                future.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture arg0) throws Exception {
                        Channel channel = arg0.getChannel();
                        HttpChannelAssociations.channels.put(e.getChannel(), channel);
                        HttpChannelAssociations.channels.put(channel, e.getChannel());
                        if (HttpRequestHandler.this.request.isChunked()) {
                            HttpRequestHandler.this.readingChunks = true;
                        }
                        channel.write((Object)HttpRequestHandler.this.request);
                        channel.getCloseFuture().addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture arg0) throws Exception {
                                HttpRequestHandler.this.closeChannelPair(arg0.getChannel());
                            }
                        });
                    }
                });
            }
        } else {
            HttpChunk chunk = (HttpChunk)e.getMessage();
            if (chunk.isLast()) {
                this.readingChunks = false;
            }
            HttpChannelAssociations.channels.get(e.getChannel()).write((Object)chunk);
        }
    }

    private void closeChannelPair(Channel channel) {
        Channel associatedChannel = HttpChannelAssociations.channels.get(channel);
        if (associatedChannel != null) {
            try {
                HttpChannelAssociations.channels.remove(associatedChannel);
                if (!associatedChannel.isConnected()) {
                    associatedChannel.disconnect();
                    associatedChannel.close();
                    associatedChannel.getCloseFuture().awaitUninterruptibly();
                }
                associatedChannel = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HttpChannelAssociations.channels.remove(channel);
        if (logger.isDebugEnabled()) {
            try {
                logger.debug((Object)("Channel closed " + HttpChannelAssociations.channels.size() + " " + channel));
                Enumeration<Channel> c = HttpChannelAssociations.channels.keys();
                while (c.hasMoreElements()) {
                    logger.debug((Object)c.nextElement().toString());
                }
            }
            catch (Exception e) {
                logger.debug((Object)"error", (Throwable)e);
            }
        }
    }

    private void writeResponse(MessageEvent e, HttpResponseStatus status, String responseString) {
        CookieDecoder cookieDecoder;
        Set cookies;
        String cookieString;
        ChannelBuffer buf = ChannelBuffers.copiedBuffer((CharSequence)responseString, (Charset)Charset.forName("UTF-8"));
        boolean close = "close".equalsIgnoreCase(this.request.getHeader("Connection")) || this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.getHeader("Connection"));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setContent(buf);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        if (!close) {
            response.setHeader("Content-Length", (Object)String.valueOf(buf.readableBytes()));
        }
        if ((cookieString = this.request.getHeader("Cookie")) != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", (Object)cookieEncoder.encode());
        }
        ChannelFuture future = e.getChannel().write((Object)response);
        if (close) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        logger.error((Object)"Error", e.getCause());
        e.getChannel().close();
    }
}

