/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.http.balancer;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.mobicents.tools.http.balancer.HttpResponseHandler;

public class HttpClientPipelineFactory
implements ChannelPipelineFactory {
    int maxContentLength = 0x100000;

    public HttpClientPipelineFactory(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.maxContentLength));
        pipeline.addLast("handler", (ChannelHandler)new HttpResponseHandler());
        return pipeline;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }
}

