/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.http.balancer;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.mobicents.tools.http.balancer.HttpChannelAssociations;
import org.mobicents.tools.http.balancer.HttpClientPipelineFactory;
import org.mobicents.tools.http.balancer.HttpServerPipelineFactory;
import org.mobicents.tools.sip.balancer.BalancerRunner;

public class HttpBalancerForwarder {
    private static final Logger logger = Logger.getLogger((String)HttpBalancerForwarder.class.getCanonicalName());
    ExecutorService executor;
    public BalancerRunner balancerRunner;
    NioServerSocketChannelFactory nioServerSocketChannelFactory = null;
    NioClientSocketChannelFactory nioClientSocketChannelFactory = null;
    Channel serverChannel;

    public void start() {
        this.executor = Executors.newCachedThreadPool();
        this.nioServerSocketChannelFactory = new NioServerSocketChannelFactory((Executor)this.executor, (Executor)this.executor);
        this.nioClientSocketChannelFactory = new NioClientSocketChannelFactory((Executor)this.executor, (Executor)this.executor);
        HttpChannelAssociations.serverBootstrap = new ServerBootstrap((ChannelFactory)this.nioServerSocketChannelFactory);
        HttpChannelAssociations.inboundBootstrap = new ClientBootstrap((ChannelFactory)this.nioClientSocketChannelFactory);
        HttpChannelAssociations.channels = new ConcurrentHashMap();
        Integer httpPort = 2080;
        if (this.balancerRunner.balancerContext.properties != null) {
            String httpPortString = this.balancerRunner.balancerContext.properties.getProperty("httpPort", "2080");
            httpPort = Integer.parseInt(httpPortString);
        }
        int maxContentLength = 0x100000;
        if (this.balancerRunner.balancerContext.properties != null) {
            String maxContentLengthString = this.balancerRunner.balancerContext.properties.getProperty("maxContentLength", "1048576");
            maxContentLength = Integer.parseInt(maxContentLengthString);
        }
        logger.info((Object)("HTTP LB listening on port " + httpPort));
        logger.debug((Object)("HTTP maxContentLength Chunking set to " + maxContentLength));
        HttpChannelAssociations.serverBootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpServerPipelineFactory(this.balancerRunner, maxContentLength));
        this.serverChannel = HttpChannelAssociations.serverBootstrap.bind((SocketAddress)new InetSocketAddress(httpPort));
        HttpChannelAssociations.inboundBootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpClientPipelineFactory(maxContentLength));
    }

    public void stop() {
        if (this.executor == null) {
            return;
        }
        for (Map.Entry<Channel, Channel> entry : HttpChannelAssociations.channels.entrySet()) {
            entry.getKey().unbind();
            entry.getKey().close();
            entry.getKey().getCloseFuture().awaitUninterruptibly();
            entry.getValue().unbind();
            entry.getValue().close();
            entry.getValue().getCloseFuture().awaitUninterruptibly();
        }
        this.serverChannel.unbind();
        this.serverChannel.close();
        this.serverChannel.getCloseFuture().awaitUninterruptibly();
        this.executor.shutdownNow();
        this.executor = null;
    }
}

