/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.bootstrap;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.util.StringPropertyReplacer;
import org.mobicents.media.server.bootstrap.MainDeployer;

public class Main {
    private static final String HOME_DIR = "MMS_HOME";
    private static final String BOOT_URL = "/conf/bootstrap-beans.xml";
    private static final String LOG4J_URL = "/conf/log4j.properties";
    private static final String LOG4J_URL_XML = "/conf/log4j.xml";
    public static final String MMS_HOME = "mms.home.dir";
    public static final String MMS_MEDIA = "mms.media.dir";
    public static final String MMS_BIND_ADDRESS = "mms.bind.address";
    private static final String LINKSET_PERSIST_DIR_KEY = "linkset.persist.dir";
    private static int index = 0;
    private Kernel kernel;
    private BasicXMLDeployer kernelDeployer;
    private Controller controller;
    private static Logger logger = Logger.getLogger(Main.class);

    public static void main(String[] args) throws Throwable {
        String homeDir = Main.getHomeDir(args);
        System.setProperty(MMS_HOME, homeDir);
        System.setProperty(MMS_MEDIA, homeDir + File.separator + "media" + File.separator);
        System.setProperty(LINKSET_PERSIST_DIR_KEY, homeDir + File.separator + "ss7");
        if (!Main.initLOG4JProperties(homeDir) && !Main.initLOG4JXml(homeDir)) {
            System.err.println("Could not find configuration file for log4j. Defaults will be used.");
        } else {
            logger.info((Object)"log4j initialized from a configuration file.");
        }
        logger.info((Object)("Home directory: " + homeDir));
        URL bootURL = Main.getBootURL(args);
        Main main = new Main();
        main.processCommandLine(args);
        logger.info((Object)("Booting from " + bootURL));
        main.boot(bootURL);
    }

    private void processCommandLine(String[] args) {
        int c;
        String programName = System.getProperty("program.name", "Mobicents Media Server");
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("host", 1, null, 98)};
        Getopt g = new Getopt("MMS", args, "-:b:h", longopts);
        g.setOpterr(false);
        block6: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 98: {
                    String arg = g.getOptarg();
                    System.setProperty(MMS_BIND_ADDRESS, arg);
                    continue block6;
                }
                case 104: {
                    System.out.println("usage: " + programName + " [options]");
                    System.out.println();
                    System.out.println("options:");
                    System.out.println("    -h, --help                    Show this help message");
                    System.out.println("    -b, --host=<host or ip>       Bind address for all Mobicents Media Server services");
                    System.out.println();
                    System.exit(0);
                    continue block6;
                }
                case 58: {
                    System.out.println("You need an argument for option " + (char)g.getOptopt());
                    System.exit(0);
                    continue block6;
                }
                case 63: {
                    System.out.println("The option '" + (char)g.getOptopt() + "' is not valid");
                    System.exit(0);
                    continue block6;
                }
            }
            System.out.println("getopt() returned " + c);
        }
        if (System.getProperty(MMS_BIND_ADDRESS) == null) {
            System.setProperty(MMS_BIND_ADDRESS, "127.0.0.1");
        }
    }

    private static boolean initLOG4JProperties(String homeDir) {
        String Log4jURL = homeDir + LOG4J_URL;
        try {
            URL log4jurl = Main.getURL(Log4jURL);
            InputStream inStreamLog4j = log4jurl.openStream();
            Properties propertiesLog4j = new Properties();
            try {
                propertiesLog4j.load(inStreamLog4j);
                PropertyConfigurator.configure((Properties)propertiesLog4j);
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        logger.debug((Object)("LOG4J initialized with properties file: " + Log4jURL));
        return true;
    }

    private static boolean initLOG4JXml(String homeDir) {
        String Log4jURL = homeDir + LOG4J_URL_XML;
        try {
            URL log4jurl = Main.getURL(Log4jURL);
            DOMConfigurator.configure((URL)log4jurl);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static String getHomeDir(String[] args) {
        String mmsHomeDir = System.getProperty(HOME_DIR);
        if (mmsHomeDir == null && (mmsHomeDir = System.getenv(HOME_DIR)) == null) {
            mmsHomeDir = args.length > index ? args[index++] : ".";
        }
        return mmsHomeDir;
    }

    private static URL getBootURL(String[] args) throws Exception {
        String bootURL = "${mms.home.dir}/conf/bootstrap-beans.xml";
        return Main.getURL(bootURL);
    }

    protected void boot(URL bootURL) throws Throwable {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.registerShutdownThread();
        this.kernel = bootstrap.getKernel();
        this.kernelDeployer = new BasicXMLDeployer(this.kernel);
        this.kernelDeployer.deploy(bootURL);
        this.kernelDeployer.validate();
        this.controller = this.kernel.getController();
        this.start(this.kernel, this.kernelDeployer);
    }

    public void start(Kernel kernel, BasicXMLDeployer kernelDeployer) throws Throwable {
        ControllerContext context = this.controller.getInstalledContext((Object)"MainDeployer");
        if (context != null) {
            MainDeployer deployer = (MainDeployer)context.getTarget();
            deployer.start(kernel, kernelDeployer);
        }
    }

    public static URL getURL(String filePath) throws Exception {
        File file = new File(filePath = StringPropertyReplacer.replaceProperties((String)filePath, (Properties)System.getProperties()));
        if (!file.exists()) {
            throw new IllegalArgumentException("No such file: " + filePath);
        }
        return file.toURI().toURL();
    }

    protected void registerShutdownThread() {
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownThread()));
    }

    private class ShutdownThread
    implements Runnable {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            System.out.println("Shutting down");
            Main.this.kernelDeployer.shutdown();
            Main.this.kernelDeployer = null;
            Main.this.kernel.getController().shutdown();
            Main.this.kernel = null;
        }
    }
}

