/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mscontrol.messages;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;

@Immutable
public final class Record {
    private static final List<URI> empty = new ArrayList<URI>(0);
    private final URI destination;
    private final List<URI> prompts;
    private final int timeout;
    private final int length;
    private final String endInputKey;

    public Record(URI recordingId, List<URI> prompts, int timeout, int length, String endInputKey) {
        this.destination = recordingId;
        this.prompts = prompts;
        this.timeout = timeout;
        this.length = length;
        this.endInputKey = endInputKey;
    }

    public Record(URI recordingId, int timeout, int length, String endInputKey) {
        this.destination = recordingId;
        this.prompts = empty;
        this.timeout = timeout;
        this.length = length;
        this.endInputKey = endInputKey;
    }

    public URI destination() {
        return this.destination;
    }

    public List<URI> prompts() {
        return this.prompts;
    }

    public boolean hasPrompts() {
        return this.prompts != null && !this.prompts.isEmpty();
    }

    public int timeout() {
        return this.timeout;
    }

    public int length() {
        return this.length;
    }

    public String endInputKey() {
        return this.endInputKey;
    }

    public boolean hasEndInputKey() {
        return this.endInputKey != null && !this.endInputKey.isEmpty();
    }
}

