/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip.dns;

import gov.nist.javax.sip.address.AddressFactoryImpl;
import gov.nist.javax.sip.stack.HopImpl;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.address.TelURL;
import javax.sip.address.URI;
import org.apache.log4j.Logger;
import org.mobicents.ext.javax.sip.dns.DNSLookupPerformer;
import org.mobicents.ext.javax.sip.dns.DNSServerLocator;
import org.mobicents.ext.javax.sip.dns.DefaultDNSLookupPerformer;
import org.mobicents.ext.javax.sip.dns.NAPTRRecordComparator;
import org.mobicents.ext.javax.sip.dns.SRVRecordComparator;
import org.mobicents.ext.javax.sip.utils.Inet6Util;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDNSServerLocator
implements DNSServerLocator {
    private static final Logger logger = Logger.getLogger(DefaultDNSServerLocator.class);
    protected Set<String> supportedTransports;
    protected Set<String> localHostNames = new CopyOnWriteArraySet<String>();
    protected Map<String, Set<String>> localHostNamesToIPMap = new ConcurrentHashMap<String, Set<String>>(0);
    private DNSLookupPerformer dnsLookupPerformer = new DefaultDNSLookupPerformer();

    public DefaultDNSServerLocator() {
        this.supportedTransports = new CopyOnWriteArraySet<String>();
    }

    public DefaultDNSServerLocator(Set<String> supportedTransports) {
        this();
        this.supportedTransports = new CopyOnWriteArraySet<String>(supportedTransports);
    }

    @Override
    public Queue<Hop> locateHops(URI uri) {
        SipURI sipUri = this.getSipURI(uri);
        if (sipUri != null) {
            return this.locateHopsForSipURI(sipUri);
        }
        return new LinkedList<Hop>();
    }

    @Override
    public SipURI getSipURI(URI uri) {
        if (uri instanceof TelURL) {
            return this.lookupSipUri(((TelURL)uri).getPhoneNumber());
        }
        if (uri.isSipURI() && ((SipURI)uri).getParameter("user") != null && ((SipURI)uri).getParameter("user").equalsIgnoreCase("phone")) {
            String phoneNumber = ((SipURI)uri).getUser();
            if (phoneNumber == null || phoneNumber.isEmpty()) {
                throw new IllegalArgumentException("Phone Number can't be empty in following uri with phone parameter " + uri);
            }
            return this.lookupSipUri(phoneNumber);
        }
        if (uri instanceof SipURI) {
            return (SipURI)uri;
        }
        return null;
    }

    public SipURI lookupSipUri(String phoneNumber) {
        String domainName = this.convertPhoneNumberToDomainName(phoneNumber);
        List<NAPTRRecord> naptrRecords = this.dnsLookupPerformer.performNAPTRLookup(domainName, false, this.supportedTransports);
        if (naptrRecords.size() > 0) {
            Collections.sort(naptrRecords, new NAPTRRecordComparator());
            for (NAPTRRecord naptrRecord : naptrRecords) {
                String[] regexPortions;
                String regexp = naptrRecord.getRegexp().toString();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("regexp " + regexp + " found for phone number " + phoneNumber));
                }
                if (regexp.startsWith("!")) {
                    regexp = regexp.substring(1);
                }
                if (regexp.endsWith("!")) {
                    regexp = regexp.substring(0, regexp.length() - 1);
                }
                if ((regexPortions = regexp.split("!")).length == 2) {
                    if (regexPortions[1].startsWith("sip:")) {
                        String result = regexPortions[1];
                        Pattern pattern = Pattern.compile(regexPortions[0]);
                        Matcher regexMatcher = pattern.matcher(phoneNumber);
                        if (regexMatcher.matches()) {
                            for (int i = 0; i < regexMatcher.groupCount(); ++i) {
                                String group = regexMatcher.group(i);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("group found " + group));
                                }
                                result = result.replace("\\\\" + (i + 1), group);
                            }
                        }
                        try {
                            return new AddressFactoryImpl().createSipURI(result);
                        }
                        catch (ParseException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("replacement " + result + " couldn't be parsed a valid sip uri : " + e.getMessage()));
                            continue;
                        }
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("regexp seconf portion  " + regexPortions[1] + " does not start with sip:"));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("regexp " + regexp + " number of portions " + regexPortions.length));
            }
        }
        return null;
    }

    private String convertPhoneNumberToDomainName(String phoneNumber) {
        char[] phoneNumberAsChar = phoneNumber.toCharArray();
        StringBuilder validPhoneNumber = new StringBuilder();
        for (char c : phoneNumberAsChar) {
            if (!Character.isDigit(c)) continue;
            validPhoneNumber.append(c).append('.');
        }
        return validPhoneNumber.reverse().append(".e164.arpa").substring(1);
    }

    public Queue<Hop> locateHopsForSipURI(SipURI sipURI) {
        String hopTransport;
        String hopHost = sipURI.getHost();
        int hopPort = sipURI.getPort();
        String string = hopTransport = sipURI.isSecure() ? "TLS" : sipURI.getTransportParam();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving " + hopHost + " transport " + hopTransport));
        }
        if (Inet6Util.isValidIP6Address(hopHost) || Inet6Util.isValidIPV4Address(hopHost)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("host " + hopHost + " is a numeric IP address, " + "no DNS SRV lookup to be done, using the hop given in param"));
            }
            LinkedList<Hop> priorityQueue = new LinkedList<Hop>();
            String transport = hopTransport;
            if (transport == null) {
                transport = this.getDefaultTransportForSipUri(sipURI);
            }
            if (hopPort == -1) {
                hopPort = "TLS".equalsIgnoreCase(transport) || "TCP".equalsIgnoreCase(transport) && sipURI.isSecure() ? 5061 : 5060;
            }
            priorityQueue.add((Hop)new HopImpl(hopHost, hopPort, transport));
            return priorityQueue;
        }
        if (this.localHostNames.contains(hopHost)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("host " + hopHost + " is a localhostName belonging to ourselves"));
            }
            Queue<Hop> priorityQueue = this.resolveHostByAandAAAALookup(hopHost, hopPort, hopTransport);
            return priorityQueue;
        }
        return this.resolveHostByDnsSrvLookup(sipURI);
    }

    @Override
    public Queue<Hop> resolveHostByAandAAAALookup(String hopHost, int hopPort, String hopTransport) {
        Set<String> ipAddresses;
        Queue<Hop> priorityQueue = this.dnsLookupPerformer.locateHopsForNonNumericAddressWithPort(hopHost, hopPort, hopTransport);
        if (priorityQueue.isEmpty() && !this.localHostNamesToIPMap.isEmpty() && (ipAddresses = this.localHostNamesToIPMap.get(hopHost)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("host " + hopHost + " is a localhostName belonging to ourselves, adding corresponding ip addresses " + ipAddresses.toArray().toString()));
            }
            for (String ipAddress : ipAddresses) {
                priorityQueue.add((Hop)new HopImpl(ipAddress, hopPort, hopTransport));
            }
        }
        return priorityQueue;
    }

    public Queue<Hop> resolveHostByDnsSrvLookup(SipURI sipURI) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving Hops for SipURI " + sipURI));
        }
        String host = sipURI.getHost();
        int port = sipURI.getPort();
        String transport = sipURI.getTransportParam();
        NAPTRRecord naptrRecordOfTransportLookup = null;
        ArrayList<Record> srvRecordsOfTransportLookup = new ArrayList<Record>();
        if (transport == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("transport not specified, trying to resolve it for " + sipURI));
            }
            if (port != -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("port not specified, trying to resolve it for " + sipURI));
                }
                transport = this.getDefaultTransportForSipUri(sipURI);
            } else {
                List<NAPTRRecord> naptrRecords = this.dnsLookupPerformer.performNAPTRLookup(host, sipURI.isSecure(), this.supportedTransports);
                if (naptrRecords == null || naptrRecords.size() == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("no NPATR records found, doing SRV queries for supported transports for " + sipURI));
                    }
                    Iterator<String> supportedTransportIterator = this.supportedTransports.iterator();
                    HashMap<String, List<Record>> resolvedTransports = new HashMap<String, List<Record>>();
                    while (supportedTransportIterator.hasNext()) {
                        List<Record> lookupRecord;
                        String supportedTransport = supportedTransportIterator.next().toLowerCase();
                        String serviceIdentifier = "_sip._";
                        if (sipURI.isSecure()) {
                            serviceIdentifier = "_sips._";
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("no NPATR records found, doing SRV query for supported transport " + serviceIdentifier + supportedTransport + "." + host + " for " + sipURI));
                        }
                        if ((lookupRecord = this.dnsLookupPerformer.performSRVLookup(serviceIdentifier + supportedTransport + "." + host)).size() <= 0) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("no NPATR records found, SRV query for supported transport " + serviceIdentifier + supportedTransport + "." + host + " successful for " + sipURI));
                        }
                        resolvedTransports.put(supportedTransport.toUpperCase(), lookupRecord);
                    }
                    if (!resolvedTransports.isEmpty()) {
                        if (sipURI.isSecure() && (resolvedTransports.keySet().contains("TLS") || resolvedTransports.keySet().contains("TCP"))) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("SIPS URI was provided to resolve and TLS transport found by the SRV query. Setting transport to TLS for " + sipURI));
                            }
                            if (resolvedTransports.get(transport = "TLS") == null) {
                                transport = "TCP";
                            }
                            srvRecordsOfTransportLookup.addAll((Collection)resolvedTransports.get(transport));
                        } else if (!sipURI.isSecure()) {
                            if (resolvedTransports.keySet().contains("TLS")) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("SIP URI was provided to resolve and TLS transport found by the SRV query. Setting transport to TLS for " + sipURI));
                                }
                                if (resolvedTransports.get(transport) == null) {
                                    transport = "TCP";
                                }
                                srvRecordsOfTransportLookup.addAll((Collection)resolvedTransports.get(transport));
                            } else {
                                transport = (String)resolvedTransports.keySet().iterator().next();
                                srvRecordsOfTransportLookup.addAll((Collection)resolvedTransports.get(transport));
                            }
                        }
                    }
                    if (transport == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("no SRV records found for finding transport for " + sipURI));
                        }
                        transport = this.getDefaultTransportForSipUri(sipURI);
                    }
                } else {
                    String service;
                    Collections.sort(naptrRecords, new NAPTRRecordComparator());
                    naptrRecordOfTransportLookup = naptrRecords.get(0);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("naptr records found for finding transport for " + sipURI));
                    }
                    transport = (service = naptrRecordOfTransportLookup.getService()).contains("SIPS") ? "TLS" : (service.contains("D2U") ? "UDP" : "TCP");
                }
            }
        }
        transport = transport.toLowerCase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("using transport " + transport + " for " + sipURI));
        }
        if (port != -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doing A and AAAA lookups since TARGET is not numeric and port is not null for " + sipURI));
            }
            return this.dnsLookupPerformer.locateHopsForNonNumericAddressWithPort(host, port, transport);
        }
        if (naptrRecordOfTransportLookup != null) {
            List<Record> srvRecords;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("performing SRV lookup on NAPTR replacement found earlier " + naptrRecordOfTransportLookup.getReplacement() + " for " + sipURI));
            }
            if ((srvRecords = this.dnsLookupPerformer.performSRVLookup(naptrRecordOfTransportLookup.getReplacement().toString())).size() > 0) {
                return this.sortSRVRecords(host, transport, srvRecords);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doing A and AAAA lookups since SRV lookups returned no records for NAPTR replacement found earlier " + naptrRecordOfTransportLookup.getReplacement() + " for " + sipURI));
            }
            return this.dnsLookupPerformer.locateHopsForNonNumericAddressWithPort(host, port, transport);
        }
        if (srvRecordsOfTransportLookup == null || srvRecordsOfTransportLookup.size() == 0) {
            List<Record> srvRecords;
            String serviceIdentifier = "_sip._";
            if (sipURI.isSecure() && !transport.equalsIgnoreCase("UDP") || transport.equalsIgnoreCase("TLS")) {
                serviceIdentifier = "_sips._";
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("performing SRV lookup because a transport was specified explicitly for " + sipURI));
            }
            if ((srvRecords = this.dnsLookupPerformer.performSRVLookup(serviceIdentifier + transport + "." + host)) == null || srvRecords.size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("doing A and AAAA lookups since SRV lookups returned no records and transport was specified explicitly for " + sipURI));
                }
                return this.dnsLookupPerformer.locateHopsForNonNumericAddressWithPort(host, port, transport);
            }
            return this.sortSRVRecords(host, transport, srvRecords);
        }
        return this.sortSRVRecords(host, transport, srvRecordsOfTransportLookup);
    }

    private Queue<Hop> sortSRVRecords(String host, String transport, List<Record> srvRecords) {
        LinkedList<Hop> priorityQueue = new LinkedList<Hop>();
        Collections.sort(srvRecords, new SRVRecordComparator());
        for (Record record : srvRecords) {
            Queue<Hop> hostnameLookupQueue;
            SRVRecord srvRecord = (SRVRecord)record;
            int recordPort = srvRecord.getPort();
            String resolvedName = srvRecord.getTarget().toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking up " + host + "/" + transport + " , Host Name = " + resolvedName + ", Host Port = " + recordPort));
            }
            if ((hostnameLookupQueue = this.dnsLookupPerformer.locateHopsForNonNumericAddressWithPort(resolvedName, recordPort, transport)) == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Did a successful DNS SRV lookup for host:transport " + host + "/" + transport + " , Host Name = " + resolvedName + " , Host IP Address = " + hostnameLookupQueue + ", Host Port = " + recordPort));
            }
            priorityQueue.addAll(hostnameLookupQueue);
        }
        return priorityQueue;
    }

    public String getDefaultTransportForSipUri(SipURI sipURI) {
        String transport;
        if (sipURI.isSecure()) {
            transport = "TLS";
        } else if (this.supportedTransports.contains("UDP")) {
            transport = "UDP";
        } else if (this.supportedTransports.contains("TCP")) {
            transport = "TCP";
        } else {
            throw new IllegalArgumentException("No supported transport for SIP URI " + sipURI);
        }
        return transport;
    }

    @Override
    public void addLocalHostName(String localHostName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding localHostName " + localHostName));
        }
        this.localHostNames.add(localHostName);
    }

    @Override
    public void removeLocalHostName(String localHostName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing localHostName " + localHostName));
        }
        this.localHostNames.remove(localHostName);
    }

    @Override
    public void mapLocalHostNameToIP(String localHostName, Set<String> ipAddresses) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mapping localHostName " + localHostName + " to " + ipAddresses.toArray().toString()));
        }
        this.localHostNamesToIPMap.put(localHostName, ipAddresses);
    }

    @Override
    public void unmapLocalHostNameToIP(String localHostName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unmapping localHostName " + localHostName));
        }
        this.localHostNamesToIPMap.remove(localHostName);
    }

    @Override
    public void addSupportedTransport(String supportedTransport) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding supportedTransport " + supportedTransport));
        }
        this.supportedTransports.add(supportedTransport.toUpperCase());
    }

    @Override
    public void removeSupportedTransport(String supportedTransport) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing supportedTransport " + supportedTransport));
        }
        this.supportedTransports.add(supportedTransport.toUpperCase());
    }

    @Override
    public void setDnsLookupPerformer(DNSLookupPerformer dnsLookupPerformer) {
        this.dnsLookupPerformer = dnsLookupPerformer;
    }

    @Override
    public DNSLookupPerformer getDnsLookupPerformer() {
        return this.dnsLookupPerformer;
    }
}

