/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser.selective;

import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.message.selective.SelectiveSIPRequest;
import gov.nist.javax.sip.message.selective.SelectiveSIPResponse;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.chars.CharsMsgParser;
import gov.nist.javax.sip.parser.chars.Lexer;
import gov.nist.javax.sip.parser.chars.RequestLineParser;
import gov.nist.javax.sip.parser.chars.StatusLineParser;
import gov.nist.javax.sip.parser.selective.SelectiveMessage;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class SelectiveCharParser
extends CharsMsgParser {
    private static final String HEADERS_TO_PARSE = "gov.nist.java.sip.selective.parser.HEADERS_TO_PARSE";
    private static Set<String> headersToParse = new HashSet<String>();
    StackLogger logger;

    public SelectiveCharParser(SIPTransactionStack stack, Properties configurationProperties) {
        this.logger = stack.getStackLogger();
        if (headersToParse.size() < 1) {
            String headersToParseString;
            boolean headersToParseFound = false;
            if (configurationProperties != null && (headersToParseString = configurationProperties.getProperty(HEADERS_TO_PARSE)) != null) {
                headersToParse.clear();
                StringTokenizer stringTokenizer = new StringTokenizer(headersToParseString, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String headerToParse = stringTokenizer.nextToken();
                    headersToParse.add(headerToParse.trim().toLowerCase());
                }
                headersToParseFound = true;
            }
            if (!headersToParseFound) {
                headersToParse.add("From".toLowerCase());
                headersToParse.add("To".toLowerCase());
                headersToParse.add("CSeq".toLowerCase());
                headersToParse.add("Call-ID".toLowerCase());
                headersToParse.add("Max-Forwards".toLowerCase());
                headersToParse.add("Via".toLowerCase());
                headersToParse.add("Contact".toLowerCase());
                headersToParse.add("Record-Route".toLowerCase());
                headersToParse.add("Route".toLowerCase());
                headersToParse.add("Content-Length".toLowerCase());
                headersToParse.add("Subscription-State".toLowerCase());
                headersToParse.add("Event".toLowerCase());
            }
            if (this.logger.isLoggingEnabled()) {
                this.logger.logDebug("Headers to parse : ");
                for (String headerToParse : headersToParse) {
                    this.logger.logDebug(headerToParse);
                }
            }
        }
    }

    public SIPMessage parseSIPMessage(byte[] msgBuffer, boolean readBody, boolean strict, ParseExceptionListener parseExceptionListener) throws ParseException {
        return super.parseSIPMessage(msgBuffer, readBody, strict, parseExceptionListener);
    }

    protected void processHeader(char[] header, SIPMessage message, ParseExceptionListener parseExceptionListener, byte[] msgBuffer) throws ParseException {
        String headerName = Lexer.getHeaderName(header);
        if (headerName == null) {
            throw new ParseException("The header name or value is null", 0);
        }
        if (headersToParse.contains(headerName.toLowerCase())) {
            super.processHeader(header, message, parseExceptionListener, msgBuffer);
        } else {
            ((SelectiveMessage)message).addHeaderNotParsed(headerName, new String(header));
        }
    }

    protected SIPMessage processFirstLine(char[] firstLine, ParseExceptionListener parseExceptionListener, byte[] msgBuffer) throws ParseException {
        return this.reprocessFirstLine(firstLine, null, parseExceptionListener, msgBuffer);
    }

    protected SIPMessage reprocessFirstLine(char[] firstLine, SIPMessage sipMessage, ParseExceptionListener parseExceptionListener, byte[] msgBuffer) throws ParseException {
        Object message = sipMessage;
        char[] retval = new char[firstLine.length + 1];
        System.arraycopy(firstLine, 0, retval, 0, firstLine.length);
        retval[firstLine.length] = 10;
        if (!new String(firstLine).startsWith("SIP/2.0")) {
            if (message == null) {
                message = new SelectiveSIPRequest(headersToParse);
            }
            try {
                RequestLine requestLine = new RequestLineParser(retval).parse();
                ((SIPRequest)message).setRequestLine(requestLine);
            }
            catch (ParseException ex) {
                if (parseExceptionListener != null) {
                    try {
                        parseExceptionListener.handleException(ex, message, RequestLine.class, new String(retval), new String(msgBuffer, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                throw ex;
            }
        } else {
            if (message == null) {
                message = new SelectiveSIPResponse(headersToParse);
            }
            try {
                StatusLine sl = new StatusLineParser(retval).parse();
                ((SIPResponse)message).setStatusLine(sl);
            }
            catch (ParseException ex) {
                if (parseExceptionListener != null) {
                    try {
                        parseExceptionListener.handleException(ex, message, StatusLine.class, new String(retval), new String(msgBuffer, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                throw ex;
            }
        }
        return message;
    }
}

