/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.resources;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.operations.HttpManagementAddHandler;
import org.jboss.as.host.controller.operations.HttpManagementRemoveHandler;
import org.jboss.as.host.controller.operations.HttpManagementWriteAttributeHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HttpManagementResourceDefinition
extends SimpleResourceDefinition {
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final HostControllerEnvironment environment;
    private static final PathElement RESOURCE_PATH = PathElement.pathElement((String)"management-interface", (String)"http-interface");
    public static final SimpleAttributeDefinition SECURITY_REALM = new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).build();
    public static final SimpleAttributeDefinition INTERFACE = new SimpleAttributeDefinitionBuilder("interface", ModelType.STRING, false).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true)).build();
    public static final SimpleAttributeDefinition HTTP_PORT = new SimpleAttributeDefinitionBuilder("port", ModelType.INT, true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true)).build();
    public static final SimpleAttributeDefinition HTTPS_PORT = new SimpleAttributeDefinitionBuilder("secure-port", ModelType.INT, true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true)).build();
    public static final SimpleAttributeDefinition CONSOLE_ENABLED = new SimpleAttributeDefinitionBuilder("console-enabled", ModelType.BOOLEAN, true).setAllowExpression(true).setXmlName(Attribute.CONSOLE_ENABLED.getLocalName()).setDefaultValue(new ModelNode(true)).build();
    public static final AttributeDefinition[] ATTRIBUTE_DEFINITIONS = new AttributeDefinition[]{INTERFACE, HTTP_PORT, HTTPS_PORT, SECURITY_REALM, CONSOLE_ENABLED};

    public HttpManagementResourceDefinition(LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment) {
        super(RESOURCE_PATH, (ResourceDescriptionResolver)HostModelUtil.getResourceDescriptionResolver("core", "management", "http-interface"), (OperationStepHandler)new HttpManagementAddHandler(hostControllerInfo, environment), (OperationStepHandler)new HttpManagementRemoveHandler(hostControllerInfo, environment), OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
        this.hostControllerInfo = hostControllerInfo;
        this.environment = environment;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        HttpManagementWriteAttributeHandler writeAttributeHandler = new HttpManagementWriteAttributeHandler(this.hostControllerInfo, this.environment);
        for (AttributeDefinition attr : ATTRIBUTE_DEFINITIONS) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeAttributeHandler);
        }
    }
}

