/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.ByteBufferFactory;
import gov.nist.javax.sip.stack.NioTlsChannelInterface;
import gov.nist.javax.sip.stack.NioTlsMessageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SSLStateMachine {
    private static StackLogger logger = CommonLogger.getLogger(SSLStateMachine.class);
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    protected SSLEngine sslEngine;
    protected Queue<MessageSendItem> pendingOutboundBuffers = new LinkedList<MessageSendItem>();
    protected NioTlsChannelInterface channel;
    protected ByteBuffer tlsRecordBuffer;
    private Object unwrapLock = new Object();
    private Object wrapLock = new Object();

    public SSLStateMachine(SSLEngine sslEngine, NioTlsChannelInterface channel) {
        this.sslEngine = sslEngine;
        this.channel = channel;
    }

    public void wrapRemaining() throws IOException {
        this.wrap(null, this.channel.prepareEncryptedDataBuffer(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void wrap(ByteBuffer src, ByteBuffer dst, MessageSendCallback callback) throws IOException {
        Object object = this.wrapLock;
        synchronized (object) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Wrapping " + src + ", buffers size " + this.pendingOutboundBuffers.size());
            }
            if (src != null) {
                this.pendingOutboundBuffers.offer(new MessageSendItem(src, callback));
            }
            int iter = 0;
            block12: while (true) {
                SSLEngineResult result;
                ++iter;
                MessageSendItem currentBuffer = this.pendingOutboundBuffers.peek();
                if (currentBuffer == null) break;
                try {
                    result = this.sslEngine.wrap(currentBuffer.message, dst);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Wrap result " + result + " buffers size " + this.pendingOutboundBuffers.size());
                    }
                }
                finally {
                    if (!currentBuffer.message.hasRemaining()) {
                        this.pendingOutboundBuffers.remove();
                        logger.logDebug("REMOVED item from encryption queue because it has no more data, all is done, buffers size now is " + this.pendingOutboundBuffers.size() + " current buffer is " + currentBuffer);
                    }
                }
                int remaining = currentBuffer.message.remaining();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Remaining " + remaining + " queue size is " + this.pendingOutboundBuffers.size());
                }
                if (result.bytesProduced() > 0) {
                    dst.flip();
                    byte[] bytes = new byte[dst.remaining()];
                    dst.get(bytes);
                    if (currentBuffer.getCallBack() != null) {
                        currentBuffer.getCallBack().doSend(bytes);
                    } else {
                        this.sendSSLMetadata(bytes);
                    }
                    dst.clear();
                    continue;
                }
                switch (result.getHandshakeStatus()) {
                    case NEED_WRAP: {
                        if (!currentBuffer.message.hasRemaining()) return;
                        break;
                    }
                    case NEED_UNWRAP: {
                        break block12;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks(result);
                        break;
                    }
                    case FINISHED: {
                        if (!(this.channel instanceof NioTlsMessageChannel)) break;
                        ((NioTlsMessageChannel)this.channel).setHandshakeCompleted(true);
                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setPeerCertificates(this.sslEngine.getSession().getPeerCertificates());
                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setLocalCertificates(this.sslEngine.getSession().getLocalCertificates());
                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setCipherSuite(this.sslEngine.getSession().getCipherSuite());
                        break;
                    }
                    case NOT_HANDSHAKING: {
                        break block12;
                    }
                }
            }
            return;
        }
    }

    private void wrapNonAppData() throws Exception {
        SSLEngineResult result;
        ByteBuffer encryptedDataBuffer = this.channel.prepareEncryptedDataBuffer();
        do {
            result = this.sslEngine.wrap(EMPTY_BUFFER, encryptedDataBuffer);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("NonAppWrap result " + result + " buffers size " + this.pendingOutboundBuffers.size());
            }
            if (result.bytesProduced() > 0) {
                encryptedDataBuffer.flip();
                byte[] msg = new byte[encryptedDataBuffer.remaining()];
                encryptedDataBuffer.get(msg);
                this.sendSSLMetadata(msg);
                encryptedDataBuffer.clear();
            }
            switch (result.getHandshakeStatus()) {
                case FINISHED: {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Handshake complete!");
                    }
                    if (!(this.channel instanceof NioTlsMessageChannel)) break;
                    ((NioTlsMessageChannel)this.channel).setHandshakeCompleted(true);
                    ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setPeerCertificates(this.sslEngine.getSession().getPeerCertificates());
                    ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setLocalCertificates(this.sslEngine.getSession().getLocalCertificates());
                    ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setCipherSuite(this.sslEngine.getSession().getCipherSuite());
                    break;
                }
                case NEED_TASK: {
                    this.runDelegatedTasks(result);
                }
            }
        } while (result.bytesProduced() != 0);
    }

    public void unwrap(ByteBuffer src) throws Exception {
        ByteBuffer outputBuffer = this.channel.prepareAppDataBuffer();
        this.unwrap(src, outputBuffer);
    }

    private void startBuffer(ByteBuffer src) {
        if (this.tlsRecordBuffer == null) {
            this.tlsRecordBuffer = ByteBufferFactory.getInstance().allocateDirect(33270);
            this.tlsRecordBuffer.put(src);
            this.tlsRecordBuffer.flip();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Allocated record buffer for reading " + this.tlsRecordBuffer + " for src = " + src);
            }
        }
    }

    private void clearBuffer() {
        this.tlsRecordBuffer = null;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Buffer cleared");
        }
    }

    private ByteBuffer normalizeTlsRecordBuffer(ByteBuffer src) {
        if (this.tlsRecordBuffer == null) {
            return src;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Normalize buffer " + src + " into record buffer " + this.tlsRecordBuffer);
        }
        this.tlsRecordBuffer.position(this.tlsRecordBuffer.limit());
        this.tlsRecordBuffer.limit(this.tlsRecordBuffer.capacity());
        this.tlsRecordBuffer.put(src);
        this.tlsRecordBuffer.flip();
        return this.tlsRecordBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unwrap(ByteBuffer src, ByteBuffer dst) throws Exception {
        Object object = this.unwrapLock;
        synchronized (object) {
            block13: while (true) {
                src = this.normalizeTlsRecordBuffer(src);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Unwrap src " + src + " dst " + dst);
                }
                SSLEngineResult result = null;
                try {
                    result = this.sslEngine.unwrap(src, dst);
                }
                catch (Exception e) {
                    if (!logger.isLoggingEnabled(32)) throw e;
                    logger.logDebug("An Exception occured while trying to unwrap the message " + e);
                    throw e;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Unwrap result " + result + " buffers size " + this.pendingOutboundBuffers.size() + " src=" + src + " dst=" + dst);
                }
                if (result.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Buffer underflow, wait for the next inbound chunk of data to feed the SSL engine");
                    }
                    this.startBuffer(src);
                    break;
                }
                this.clearBuffer();
                if (result.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_OVERFLOW)) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Buffer overflow , must prepare the buffer again. Check for continious overflow here?");
                    }
                    dst = this.channel.prepareAppDataBuffer();
                    continue;
                }
                if (result.bytesProduced() > 0) {
                    dst.flip();
                    byte[] a = new byte[dst.remaining()];
                    dst.get(a);
                    this.channel.addPlaintextBytes(a);
                }
                switch (result.getHandshakeStatus()) {
                    case NEED_UNWRAP: {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Unwrap has remaining: " + src.hasRemaining() + " buffer " + src);
                        }
                        if (!src.hasRemaining()) return;
                        break;
                    }
                    case NEED_WRAP: {
                        this.wrapNonAppData();
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks(result);
                        break;
                    }
                    case FINISHED: {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Handshaking just finnished, but has remaining. Will try to wrap the queues app items.");
                        }
                        this.wrapRemaining();
                        if (src.hasRemaining()) break;
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Handshake passed");
                        }
                        if (!(this.channel instanceof NioTlsMessageChannel)) return;
                        ((NioTlsMessageChannel)this.channel).setHandshakeCompleted(true);
                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setPeerCertificates(this.sslEngine.getSession().getPeerCertificates());
                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setLocalCertificates(this.sslEngine.getSession().getLocalCertificates());
                        ((NioTlsMessageChannel)this.channel).getHandshakeCompletedListener().setCipherSuite(this.sslEngine.getSession().getCipherSuite());
                        try {
                            this.channel.getSIPStack().getTlsSecurityPolicy().enforceTlsPolicy(this.channel.getEncapsulatedClientTransaction());
                        }
                        catch (SecurityException ex) {
                            throw new IOException(ex.getMessage());
                        }
                        if (!logger.isLoggingEnabled(32)) return;
                        logger.logDebug("TLS Security policy passed");
                        break block13;
                    }
                    case NOT_HANDSHAKING: {
                        this.wrapRemaining();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Not handshaking, but has remaining: " + src.hasRemaining() + " buffer " + src);
                        }
                        if (!src.hasRemaining()) return;
                    }
                }
            }
            return;
        }
    }

    private void runDelegatedTasks(SSLEngineResult result) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Running delegated task for " + result);
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = this.sslEngine.getHandshakeStatus();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Handshake status after delegated tasks " + (Object)((Object)hsStatus));
            }
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new IOException("handshake shouldn't need additional tasks");
            }
        }
    }

    public void sendSSLMetadata(byte[] msg) throws IOException {
        this.channel.sendEncryptedData(msg);
    }

    public static class MessageSendItem {
        private ByteBuffer message;
        private MessageSendCallback callback;

        public MessageSendItem(ByteBuffer buffer, MessageSendCallback callback) {
            this.message = buffer;
            this.callback = callback;
        }

        public MessageSendCallback getCallBack() {
            return this.callback;
        }

        public String toString() {
            return MessageSendItem.class.getSimpleName() + " [" + this.message + ", " + this.callback + "]";
        }
    }

    public static interface MessageSendCallback {
        public void doSend(byte[] var1) throws IOException;
    }
}

