/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.IOExceptionEventExt;
import gov.nist.javax.sip.SipListenerExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageProcessor;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.ParseException;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import javax.sip.ListeningPoint;
import javax.sip.SipListener;
import javax.sip.address.Hop;

public abstract class ConnectionOrientedMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable,
RawMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(ConnectionOrientedMessageChannel.class);
    protected SIPTransactionStack sipStack;
    protected Socket mySock;
    protected PipelinedMsgParser myParser;
    protected String key;
    protected InputStream myClientInputStream;
    protected boolean isRunning = true;
    protected boolean isCached;
    protected Thread mythread;
    protected String myAddress;
    protected int myPort;
    protected InetAddress peerAddress;
    protected int peerPortAdvertisedInHeaders = -1;
    protected String peerAddressAdvertisedInHeaders;
    protected int peerPort;
    protected String peerProtocol;
    private volatile long lastKeepAliveReceivedTime;
    private SIPStackTimerTask pingKeepAliveTimeoutTask;
    private Semaphore keepAliveSemaphore;
    private long keepAliveTimeout;

    public ConnectionOrientedMessageChannel(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
        this.keepAliveTimeout = sipStack.getReliableConnectionKeepAliveTimeout();
        if (this.keepAliveTimeout > 0L) {
            this.keepAliveSemaphore = new Semaphore(1);
        }
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public void close() {
        this.close(true, true);
    }

    protected abstract void close(boolean var1, boolean var2);

    @Override
    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    @Override
    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    @Override
    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    @Override
    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    @Override
    public void sendMessage(final SIPMessage sipMessage) throws IOException {
        SIPResponse sipResponse;
        Via via;
        if (logger.isLoggingEnabled(32) && !sipMessage.isNullRequest()) {
            logger.logDebug("sendMessage:: " + sipMessage.getFirstLine() + " cseq method = " + sipMessage.getCSeq().getMethod());
        }
        for (MessageProcessor messageProcessor : this.getSIPStack().getMessageProcessors()) {
            if (!messageProcessor.getIpAddress().getHostAddress().equals(this.getPeerAddress()) || messageProcessor.getPort() != this.getPeerPort() || !messageProcessor.getTransport().equalsIgnoreCase(this.getPeerProtocol())) continue;
            Runnable processMessageTask = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            ConnectionOrientedMessageChannel.this.processMessage((SIPMessage)sipMessage.clone());
                        }
                        catch (Exception ex) {
                            if (!logger.isLoggingEnabled(4)) break block2;
                            logger.logError("Error self routing message cause by: ", ex);
                        }
                    }
                }
            };
            this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Self routing message");
            }
            return;
        }
        byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
        long time = System.currentTimeMillis();
        if (this.peerPortAdvertisedInHeaders <= 0 && sipMessage instanceof SIPResponse && (via = (sipResponse = (SIPResponse)sipMessage).getTopmostVia()).getRPort() > 0) {
            this.peerPortAdvertisedInHeaders = via.getPort() <= 0 ? 5060 : via.getPort();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("1.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for via port = " + via.getPort() + " via rport = " + via.getRPort() + " and peer port = " + this.peerPort + " for this channel " + this + " key " + this.key);
            }
        }
        this.sendMessage(msg, sipMessage instanceof SIPRequest);
        sipMessage.setRemoteAddress(this.peerAddress);
        sipMessage.setRemotePort(this.peerPort);
        sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        sipMessage.setLocalPort(this.getPort());
        if (logger.isLoggingEnabled(16)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    protected abstract void sendMessage(byte[] var1, boolean var2) throws IOException;

    public void processMessage(SIPMessage sipMessage, InetAddress address) {
        block2: {
            this.peerAddress = address;
            try {
                this.processMessage(sipMessage);
            }
            catch (Exception e) {
                if (!logger.isLoggingEnabled(4)) break block2;
                logger.logError("ERROR processing self routing", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(SIPMessage sipMessage) throws Exception {
        block43: {
            if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
                String badmsg = sipMessage.encode();
                if (logger.isLoggingEnabled()) {
                    logger.logError("bad message " + badmsg);
                    logger.logError(">>> Dropped Bad Msg");
                }
                return;
            }
            sipMessage.setRemoteAddress(this.peerAddress);
            sipMessage.setRemotePort(this.getPeerPort());
            sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
            sipMessage.setLocalPort(this.getPort());
            ViaList viaList = sipMessage.getViaHeaders();
            if (sipMessage instanceof SIPRequest) {
                Via v = (Via)viaList.getFirst();
                Hop hop = this.sipStack.addressResolver.resolveAddress(v.getHop());
                this.peerProtocol = v.getTransport();
                int hopPort = v.getPort();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("hop port = " + hopPort + " for request " + sipMessage + " for this channel " + this + " key " + this.key);
                }
                this.peerPortAdvertisedInHeaders = hopPort <= 0 ? 5060 : hopPort;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("3.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
                }
                if (this.peerAddressAdvertisedInHeaders == null) {
                    this.peerAddressAdvertisedInHeaders = hop.getHost();
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("3.Storing peerAddressAdvertisedInHeaders = " + this.peerAddressAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
                    }
                }
                try {
                    if (this.mySock != null) {
                        this.peerAddress = this.mySock.getInetAddress();
                    }
                    if (v.hasParameter("rport") || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                        v.setParameter("received", this.peerAddress.getHostAddress());
                    }
                    v.setParameter("rport", Integer.toString(this.peerPort));
                }
                catch (ParseException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (!this.isCached && this.mySock != null) {
                    this.isCached = true;
                    int remotePort = ((InetSocketAddress)this.mySock.getRemoteSocketAddress()).getPort();
                    String key = IOHandler.makeKey(this.mySock.getInetAddress(), remotePort);
                    if (this.messageProcessor instanceof NioTcpMessageProcessor) {
                        ((NioTcpMessageProcessor)this.messageProcessor).nioHandler.putSocket(key, this.mySock.getChannel());
                    } else {
                        this.sipStack.ioHandler.putSocket(key, this.mySock);
                    }
                    ((ConnectionOrientedMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                }
            }
            long receptionTime = System.currentTimeMillis();
            if (sipMessage instanceof SIPRequest) {
                String cseqMethod;
                SIPRequest sipRequest = (SIPRequest)sipMessage;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("----Processing Message---");
                }
                if (logger.isLoggingEnabled(16)) {
                    this.sipStack.serverLogger.logMessage(sipMessage, this.getPeerHostPort().toString(), this.messageProcessor.getIpAddress().getHostAddress() + ":" + this.messageProcessor.getPort(), false, receptionTime);
                }
                if (this.sipStack.getMaxMessageSize() > 0 && sipRequest.getSize() + (sipRequest.getContentLength() == null ? 0 : sipRequest.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                    SIPResponse sipResponse = sipRequest.createResponse(513);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, false);
                    throw new Exception("Message size exceeded");
                }
                String sipVersion = ((SIPRequest)sipMessage).getRequestLine().getSipVersion();
                if (!sipVersion.equals("SIP/2.0")) {
                    SIPResponse versionNotSupported = ((SIPRequest)sipMessage).createResponse(505, "Bad SIP version " + sipVersion);
                    this.sendMessage(versionNotSupported.encodeAsBytes(this.getTransport()), false);
                    throw new Exception("Bad version ");
                }
                String method = ((SIPRequest)sipMessage).getMethod();
                if (!method.equalsIgnoreCase(cseqMethod = ((SIPRequest)sipMessage).getCSeqHeader().getMethod())) {
                    SIPResponse sipResponse = sipRequest.createResponse(400);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, false);
                    throw new Exception("Bad CSeq method" + sipMessage + " method " + method);
                }
                ServerRequestInterface sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this);
                if (sipServerRequest != null) {
                    try {
                        sipServerRequest.processRequest(sipRequest, this);
                        break block43;
                    }
                    finally {
                        SIPServerTransaction sipServerTx;
                        if (sipServerRequest instanceof SIPTransaction && !(sipServerTx = (SIPServerTransaction)sipServerRequest).passToListener()) {
                            ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        }
                    }
                }
                if (this.sipStack.sipMessageValve != null) break block43;
                SIPResponse response = sipRequest.createResponse(503);
                RetryAfter retryAfter = new RetryAfter();
                try {
                    retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                    response.setHeader(retryAfter);
                    this.sendMessage(response);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (logger.isLoggingEnabled()) {
                    logger.logWarning("Dropping message -- could not acquire semaphore");
                }
                break block43;
            }
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("Dropping Badly formatted response message >>> " + sipResponse);
                }
                return;
            }
            if (this.sipStack.getMaxMessageSize() > 0 && sipResponse.getSize() + (sipResponse.getContentLength() == null ? 0 : sipResponse.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Message size exceeded");
                }
                return;
            }
            ServerResponseInterface sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this);
            if (sipServerResponse != null) {
                try {
                    if (sipServerResponse instanceof SIPClientTransaction && !((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) {
                        if (logger.isLoggingEnabled()) {
                            logger.logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        return;
                    }
                    sipServerResponse.processResponse(sipResponse, this);
                    break block43;
                }
                finally {
                    if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)((Object)sipServerResponse)).passToListener()) {
                        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    }
                }
            }
            logger.logWarning("Application is blocked -- could not acquire semaphore -- dropping response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        hispipe = null;
        hispipe = new Pipeline(this.myClientInputStream, this.sipStack.readTimeout, this.sipStack.getTimer());
        this.myParser = new PipelinedMsgParser(this.sipStack, this, hispipe, this.sipStack.getMaxMessageSize());
        this.myParser.processInput();
        bufferSize = 4096;
        ++((ConnectionOrientedMessageProcessor)this.messageProcessor).useCount;
        this.isRunning = true;
        while (true) lbl-1000:
        // 3 sources

        {
            if ((nbytes = this.myClientInputStream.read(msg = new byte[bufferSize], 0, bufferSize)) == -1) {
                hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                try {
                    if (this.sipStack.maxConnections != -1) {
                        var5_11 = this.messageProcessor;
                        synchronized (var5_11) {
                            --((ConnectionOrientedMessageProcessor)this.messageProcessor).nConnections;
                            this.messageProcessor.notify();
                        }
                    }
                    hispipe.close();
                    this.close();
                }
                catch (IOException ioex) {
                    // empty catch block
                }
                return;
            }
            try {
                hispipe.write(msg, 0, nbytes);
            }
            catch (IOException ex) {
                try {
                    hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (ConnectionOrientedMessageChannel.logger.isLoggingEnabled(32)) {
                        ConnectionOrientedMessageChannel.logger.logDebug("IOException  closing sock " + ex);
                    }
                    try {
                        if (this.sipStack.maxConnections != -1) {
                            e = this.messageProcessor;
                            synchronized (e) {
                                --((ConnectionOrientedMessageProcessor)this.messageProcessor).nConnections;
                                this.messageProcessor.notify();
                            }
                        }
                        this.close();
                        hispipe.close();
                    }
                    catch (IOException ioex) {
                    }
                }
                catch (Exception ex1) {
                    // empty catch block
                }
                return;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex, ConnectionOrientedMessageChannel.logger);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.isRunning = false;
            ((ConnectionOrientedMessageProcessor)this.messageProcessor).remove(this);
            --((ConnectionOrientedMessageProcessor)this.messageProcessor).useCount;
            if (this.myParser != null) {
                this.myParser.close();
            }
        }
    }

    @Override
    protected void uncache() {
        if (this.isCached && !this.isRunning) {
            ((ConnectionOrientedMessageProcessor)this.messageProcessor).remove(this);
        }
    }

    @Override
    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, this.getTransport());
        return this.key;
    }

    @Override
    public String getViaHost() {
        return this.myAddress;
    }

    @Override
    public int getViaPort() {
        return this.myPort;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    @Override
    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSingleCLRF() throws Exception {
        this.lastKeepAliveReceivedTime = System.currentTimeMillis();
        if (this.mySock != null && !this.mySock.isClosed()) {
            this.sendMessage("\r\n".getBytes("UTF-8"), false);
        }
        ConnectionOrientedMessageChannel connectionOrientedMessageChannel = this;
        synchronized (connectionOrientedMessageChannel) {
            if (this.isRunning && this.keepAliveTimeout > 0L) {
                this.rescheduleKeepAliveTimeout(this.keepAliveTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPingKeepAliveTimeoutTaskIfStarted() {
        if (this.pingKeepAliveTimeoutTask != null && this.pingKeepAliveTimeoutTask.getSipTimerTask() != null) {
            try {
                this.keepAliveSemaphore.acquire();
            }
            catch (InterruptedException e) {
                logger.logError("Couldn't acquire keepAliveSemaphore");
                return;
            }
            try {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("~~~ cancelPingKeepAliveTimeoutTaskIfStarted for MessageChannel(key=" + this.key + "), clientAddress=" + this.peerAddress + ", clientPort=" + this.peerPort + ", timeout=" + this.keepAliveTimeout + ")");
                }
                this.sipStack.getTimer().cancel(this.pingKeepAliveTimeoutTask);
            }
            finally {
                this.keepAliveSemaphore.release();
            }
        }
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        boolean isKeepAliveTimeoutTaskScheduled;
        if (keepAliveTimeout < 0L) {
            this.cancelPingKeepAliveTimeoutTaskIfStarted();
        }
        if (keepAliveTimeout == 0L) {
            keepAliveTimeout = this.messageProcessor.getSIPStack().getReliableConnectionKeepAliveTimeout();
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("~~~ setKeepAliveTimeout for MessageChannel(key=" + this.key + "), clientAddress=" + this.peerAddress + ", clientPort=" + this.peerPort + ", timeout=" + keepAliveTimeout + ")");
        }
        this.keepAliveTimeout = keepAliveTimeout;
        if (this.keepAliveSemaphore == null) {
            this.keepAliveSemaphore = new Semaphore(1);
        }
        boolean bl = isKeepAliveTimeoutTaskScheduled = this.pingKeepAliveTimeoutTask != null;
        if (isKeepAliveTimeoutTaskScheduled && keepAliveTimeout > 0L) {
            this.rescheduleKeepAliveTimeout(keepAliveTimeout);
        }
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescheduleKeepAliveTimeout(long newKeepAliveTimeout) {
        StringBuilder methodLog = new StringBuilder();
        if (logger.isLoggingEnabled(32)) {
            methodLog.append("~~~ rescheduleKeepAliveTimeout for MessageChannel(key=" + this.key + "), clientAddress=" + this.peerAddress + ", clientPort=" + this.peerPort + ", timeout=" + this.keepAliveTimeout + "): newKeepAliveTimeout=");
            if (newKeepAliveTimeout == Long.MAX_VALUE) {
                methodLog.append("Long.MAX_VALUE");
            } else {
                methodLog.append(newKeepAliveTimeout);
            }
        }
        try {
            this.keepAliveSemaphore.acquire();
        }
        catch (InterruptedException e) {
            logger.logWarning("Couldn't acquire keepAliveSemaphore");
            return;
        }
        try {
            if (this.pingKeepAliveTimeoutTask == null) {
                this.pingKeepAliveTimeoutTask = new KeepAliveTimeoutTimerTask();
                if (logger.isLoggingEnabled(32)) {
                    methodLog.append(", scheduling pingKeepAliveTimeoutTask to execute after ");
                    methodLog.append(this.keepAliveTimeout / 1000L);
                    methodLog.append(" seconds");
                    logger.logDebug(methodLog.toString());
                }
                this.sipStack.getTimer().schedule(this.pingKeepAliveTimeoutTask, this.keepAliveTimeout);
            } else {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("~~~ cancelPingKeepAliveTimeout for MessageChannel(key=" + this.key + "), clientAddress=" + this.peerAddress + ", clientPort=" + this.peerPort + ", timeout=" + this.keepAliveTimeout + ")");
                }
                this.sipStack.getTimer().cancel(this.pingKeepAliveTimeoutTask);
                this.pingKeepAliveTimeoutTask = new KeepAliveTimeoutTimerTask();
                if (logger.isLoggingEnabled(32)) {
                    methodLog.append(", scheduling pingKeepAliveTimeoutTask to execute after ");
                    methodLog.append(this.keepAliveTimeout / 1000L);
                    methodLog.append(" seconds");
                    logger.logDebug(methodLog.toString());
                }
                this.sipStack.getTimer().schedule(this.pingKeepAliveTimeoutTask, this.keepAliveTimeout);
            }
        }
        finally {
            this.keepAliveSemaphore.release();
        }
    }

    class KeepAliveTimeoutTimerTask
    extends SIPStackTimerTask {
        KeepAliveTimeoutTimerTask() {
        }

        @Override
        public void runTask() {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("~~~ Starting processing of KeepAliveTimeoutEvent( " + ConnectionOrientedMessageChannel.this.peerAddress.getHostAddress() + "," + ConnectionOrientedMessageChannel.this.peerPort + ")...");
            }
            ConnectionOrientedMessageChannel.this.close(true, true);
            if (ConnectionOrientedMessageChannel.this.sipStack instanceof SipStackImpl) {
                Iterator<SipProviderImpl> it = ((SipStackImpl)ConnectionOrientedMessageChannel.this.sipStack).getSipProviders();
                while (it.hasNext()) {
                    ListeningPoint[] listeningPoints;
                    SipProviderImpl nextProvider = it.next();
                    SipListener sipListener = nextProvider.getSipListener();
                    for (ListeningPoint listeningPoint : listeningPoints = nextProvider.getListeningPoints()) {
                        if (sipListener == null || !(sipListener instanceof SipListenerExt) || !listeningPoint.getIPAddress().equalsIgnoreCase(ConnectionOrientedMessageChannel.this.myAddress) || listeningPoint.getPort() != ConnectionOrientedMessageChannel.this.myPort || !listeningPoint.getTransport().equalsIgnoreCase(ConnectionOrientedMessageChannel.this.getTransport())) continue;
                        ((SipListenerExt)sipListener).processIOException(new IOExceptionEventExt(nextProvider, IOExceptionEventExt.Reason.KeepAliveTimeout, ConnectionOrientedMessageChannel.this.myAddress, ConnectionOrientedMessageChannel.this.myPort, ConnectionOrientedMessageChannel.this.peerAddress.getHostAddress(), ConnectionOrientedMessageChannel.this.peerPort, ConnectionOrientedMessageChannel.this.getTransport()));
                    }
                }
            } else {
                SipListener sipListener = ConnectionOrientedMessageChannel.this.sipStack.getSipListener();
                if (sipListener instanceof SipListenerExt) {
                    ((SipListenerExt)sipListener).processIOException(new IOExceptionEventExt(this, IOExceptionEventExt.Reason.KeepAliveTimeout, ConnectionOrientedMessageChannel.this.myAddress, ConnectionOrientedMessageChannel.this.myPort, ConnectionOrientedMessageChannel.this.peerAddress.getHostAddress(), ConnectionOrientedMessageChannel.this.peerPort, ConnectionOrientedMessageChannel.this.getTransport()));
                }
            }
        }
    }
}

