/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.CommonLogger;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.RequestEventExt;
import gov.nist.javax.sip.ResponseEventExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.MessageFactoryImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.header.ReferToHeader;
import javax.sip.header.ServerHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

class DialogFilter
implements ServerRequestInterface,
ServerResponseInterface {
    private static StackLogger logger = CommonLogger.getLogger(DialogFilter.class);
    protected SIPTransaction transactionChannel;
    protected ListeningPointImpl listeningPoint;
    private SIPTransactionStack sipStack;

    public DialogFilter(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    private void sendRequestPendingResponse(SIPRequest sipRequest, SIPServerTransaction transaction) {
        if (transaction.getState() != TransactionState.TERMINATED) {
            SIPResponse sipResponse = sipRequest.createResponse(491);
            ServerHeader serverHeader = MessageFactoryImpl.getDefaultServerHeader();
            if (serverHeader != null) {
                sipResponse.setHeader(serverHeader);
            }
            try {
                RetryAfter retryAfter = new RetryAfter();
                retryAfter.setRetryAfter(1);
                sipResponse.setHeader(retryAfter);
                if (sipRequest.getMethod().equals("INVITE")) {
                    this.sipStack.addTransactionPendingAck(transaction);
                }
                transaction.sendResponse(sipResponse);
                transaction.releaseSem();
            }
            catch (Exception ex) {
                logger.logError("Problem sending error response", ex);
                transaction.releaseSem();
                this.sipStack.removeTransaction(transaction);
            }
        }
    }

    private void sendBadRequestResponse(SIPRequest sipRequest, SIPServerTransaction transaction, String reasonPhrase) {
        if (transaction.getState() != TransactionState.TERMINATED) {
            ServerHeader serverHeader;
            SIPResponse sipResponse = sipRequest.createResponse(400);
            if (reasonPhrase != null) {
                sipResponse.setReasonPhrase(reasonPhrase);
            }
            if ((serverHeader = MessageFactoryImpl.getDefaultServerHeader()) != null) {
                sipResponse.setHeader(serverHeader);
            }
            try {
                if (sipRequest.getMethod().equals("INVITE")) {
                    this.sipStack.addTransactionPendingAck(transaction);
                }
                transaction.sendResponse(sipResponse);
                transaction.releaseSem();
            }
            catch (Exception ex) {
                logger.logError("Problem sending error response", ex);
                transaction.releaseSem();
                this.sipStack.removeTransaction(transaction);
            }
        }
    }

    private void sendCallOrTransactionDoesNotExistResponse(SIPRequest sipRequest, SIPServerTransaction transaction) {
        if (transaction.getState() != TransactionState.TERMINATED) {
            SIPResponse sipResponse = sipRequest.createResponse(481);
            ServerHeader serverHeader = MessageFactoryImpl.getDefaultServerHeader();
            if (serverHeader != null) {
                sipResponse.setHeader(serverHeader);
            }
            try {
                if (sipRequest.getMethod().equals("INVITE")) {
                    this.sipStack.addTransactionPendingAck(transaction);
                }
                transaction.sendResponse(sipResponse);
                transaction.releaseSem();
            }
            catch (Exception ex) {
                logger.logError("Problem sending error response", ex);
                transaction.releaseSem();
                this.sipStack.removeTransaction(transaction);
            }
        }
    }

    private void sendLoopDetectedResponse(SIPRequest sipRequest, SIPServerTransaction transaction) {
        SIPResponse sipResponse = sipRequest.createResponse(482);
        if (transaction.getState() != TransactionState.TERMINATED) {
            ServerHeader serverHeader = MessageFactoryImpl.getDefaultServerHeader();
            if (serverHeader != null) {
                sipResponse.setHeader(serverHeader);
            }
            try {
                this.sipStack.addTransactionPendingAck(transaction);
                transaction.sendResponse(sipResponse);
                transaction.releaseSem();
            }
            catch (Exception ex) {
                logger.logError("Problem sending error response", ex);
                transaction.releaseSem();
                this.sipStack.removeTransaction(transaction);
            }
        }
    }

    private void sendTryingResponse(SIPRequest sipRequest, SIPServerTransaction transaction) {
        SIPResponse sipResponse = sipRequest.createResponse(100);
        if (transaction.getState() != TransactionState.TERMINATED) {
            ServerHeader serverHeader = MessageFactoryImpl.getDefaultServerHeader();
            if (serverHeader != null) {
                sipResponse.setHeader(serverHeader);
            }
            try {
                transaction.sendResponse(sipResponse);
                transaction.releaseSem();
            }
            catch (Exception ex) {
                logger.logError("Problem sending error response", ex);
                transaction.releaseSem();
                this.sipStack.removeTransaction(transaction);
            }
        }
    }

    private void sendServerInternalErrorResponse(SIPRequest sipRequest, SIPServerTransaction transaction) {
        if (transaction.getState() != TransactionState.TERMINATED) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Sending 500 response for out of sequence message");
            }
            SIPResponse sipResponse = sipRequest.createResponse(500);
            sipResponse.setReasonPhrase("Request out of order");
            if (MessageFactoryImpl.getDefaultServerHeader() != null) {
                ServerHeader serverHeader = MessageFactoryImpl.getDefaultServerHeader();
                sipResponse.setHeader(serverHeader);
            }
            try {
                RetryAfter retryAfter = new RetryAfter();
                retryAfter.setRetryAfter(10);
                sipResponse.setHeader(retryAfter);
                this.sipStack.addTransactionPendingAck(transaction);
                transaction.sendResponse(sipResponse);
                transaction.releaseSem();
            }
            catch (Exception ex) {
                logger.logError("Problem sending response", ex);
                transaction.releaseSem();
                this.sipStack.removeTransaction(transaction);
            }
        }
    }

    @Override
    public void processRequest(SIPRequest sipRequest, MessageChannel incomingMessageChannel) {
        RequestEventExt sipEvent;
        SIPServerTransaction st;
        String sipRequestMethod;
        Contact contact;
        String dialogId;
        SIPDialog dialog;
        SIPServerTransaction transaction;
        if (logger.isLoggingEnabled(32) && this.listeningPoint != null) {
            logger.logDebug("PROCESSING INCOMING REQUEST " + sipRequest + " transactionChannel = " + this.transactionChannel + " listening point = " + this.listeningPoint.getIPAddress() + ":" + this.listeningPoint.getPort());
        }
        if (this.listeningPoint == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping message: No listening point registered!");
            }
            return;
        }
        SIPTransactionStack sipStack = this.transactionChannel.getSIPStack();
        SipProviderImpl sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("No provider - dropping !!");
            }
            return;
        }
        if (sipStack == null) {
            InternalErrorHandler.handleException("Egads! no sip stack!");
        }
        if ((transaction = (SIPServerTransaction)this.transactionChannel) != null && logger.isLoggingEnabled(32)) {
            logger.logDebug("transaction state = " + transaction.getState());
        }
        if ((dialog = sipStack.getDialog(dialogId = sipRequest.getDialogId(true))) != null && sipProvider != dialog.getSipProvider() && (contact = dialog.getMyContactHeader()) != null) {
            SipUri contactUri = (SipUri)contact.getAddress().getURI();
            String ipAddress = contactUri.getHost();
            int contactPort = contactUri.getPort();
            String contactTransport = contactUri.getTransportParam();
            if (contactTransport == null) {
                contactTransport = "udp";
            }
            if (contactPort == -1) {
                contactPort = contactTransport.equals("udp") || contactTransport.equals("tcp") ? 5060 : 5061;
            }
            if (!(ipAddress == null || ipAddress.equals(this.listeningPoint.getIPAddress()) && contactPort == this.listeningPoint.getPort())) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("nulling dialog -- listening point mismatch!  " + contactPort + "  lp port = " + this.listeningPoint.getPort());
                }
                dialog = null;
            }
        }
        if (sipProvider.isDialogErrorsAutomaticallyHandled() && sipRequest.getToTag() == null && sipStack.findMergedTransaction(sipRequest)) {
            this.sendLoopDetectedResponse(sipRequest, transaction);
            return;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("dialogId = " + dialogId);
            logger.logDebug("dialog = " + dialog);
        }
        if (sipRequest.getHeader("Route") != null && transaction.getDialog() != null) {
            RouteList routes = sipRequest.getRouteHeaders();
            Route route = (Route)routes.getFirst();
            SipUri uri = (SipUri)route.getAddress().getURI();
            HostPort hostPort = uri.getHostPort();
            int port = hostPort.hasPort() ? hostPort.getPort() : (this.listeningPoint.getTransport().equalsIgnoreCase("TLS") ? 5061 : 5060);
            String host = hostPort.getHost().encode();
            if ((host.equals(this.listeningPoint.getIPAddress()) || host.equalsIgnoreCase(this.listeningPoint.getSentBy())) && port == this.listeningPoint.getPort()) {
                if (routes.size() == 1) {
                    sipRequest.removeHeader("Route");
                } else {
                    routes.removeFirst();
                }
            }
        }
        if ((sipRequestMethod = sipRequest.getMethod()).equals("REFER") && dialog != null && sipProvider.isDialogErrorsAutomaticallyHandled()) {
            ReferToHeader sipHeader = (ReferToHeader)sipRequest.getHeader("Refer-To");
            if (sipHeader == null) {
                this.sendBadRequestResponse(sipRequest, transaction, "Refer-To header is missing");
                return;
            }
            SIPTransaction lastTransaction = dialog.getLastTransaction();
            if (lastTransaction != null && sipProvider.isDialogErrorsAutomaticallyHandled()) {
                String lastTransactionMethod = lastTransaction.getMethod();
                if (lastTransaction instanceof SIPServerTransaction) {
                    if ((lastTransaction.getInternalState() == 2 || lastTransaction.getInternalState() == 1) && lastTransactionMethod.equals("INVITE")) {
                        this.sendRequestPendingResponse(sipRequest, transaction);
                        return;
                    }
                } else if (lastTransaction instanceof SIPClientTransaction && lastTransactionMethod.equals("INVITE") && lastTransaction.getInternalState() != 5 && lastTransaction.getInternalState() != 3) {
                    this.sendRequestPendingResponse(sipRequest, transaction);
                    return;
                }
            }
        } else if (sipRequestMethod.equals("UPDATE")) {
            if (sipProvider.isAutomaticDialogSupportEnabled() && dialog == null) {
                this.sendCallOrTransactionDoesNotExistResponse(sipRequest, transaction);
                return;
            }
        } else if (sipRequestMethod.equals("ACK")) {
            if (transaction != null && transaction.isInviteTransaction()) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Processing ACK for INVITE Tx ");
                }
            } else {
                SIPServerTransaction ackTransaction;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Processing ACK for dialog " + dialog);
                }
                if (dialog == null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Dialog does not exist " + sipRequest.getFirstLine() + " isServerTransaction = " + true);
                    }
                    if ((st = sipStack.getRetransmissionAlertTransaction(dialogId)) != null && st.isRetransmissionAlertEnabled()) {
                        st.disableRetransmissionAlerts();
                    }
                    if ((ackTransaction = sipStack.findTransactionPendingAck(sipRequest)) != null) {
                        block162: {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("Found Tx pending ACK");
                            }
                            try {
                                ackTransaction.setAckSeen();
                                sipStack.removeTransaction(ackTransaction);
                                sipStack.removeTransactionPendingAck(ackTransaction);
                            }
                            catch (Exception ex) {
                                if (!logger.isLoggingEnabled()) break block162;
                                logger.logError("Problem terminating transaction", ex);
                            }
                        }
                        return;
                    }
                } else if (!dialog.handleAck(transaction)) {
                    if (!dialog.isSequenceNumberValidation()) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Dialog exists with loose dialog validation " + sipRequest.getFirstLine() + " isServerTransaction = " + true + " dialog = " + dialog.getDialogId());
                        }
                        if ((st = sipStack.getRetransmissionAlertTransaction(dialogId)) != null && st.isRetransmissionAlertEnabled()) {
                            st.disableRetransmissionAlerts();
                        }
                        if ((ackTransaction = sipStack.findTransactionPendingAck(sipRequest)) != null) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("Found Tx pending ACK");
                            }
                            try {
                                ackTransaction.setAckSeen();
                                sipStack.removeTransaction(ackTransaction);
                                sipStack.removeTransactionPendingAck(ackTransaction);
                            }
                            catch (Exception ex) {
                                if (logger.isLoggingEnabled()) {
                                    logger.logError("Problem terminating transaction", ex);
                                }
                            }
                        }
                    } else {
                        SIPServerTransaction ackTransaction2;
                        block164: {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("Dropping ACK - cannot find a transaction or dialog");
                            }
                            if ((ackTransaction2 = sipStack.findTransactionPendingAck(sipRequest)) != null) {
                                if (logger.isLoggingEnabled(32)) {
                                    logger.logDebug("Found Tx pending ACK");
                                }
                                try {
                                    ackTransaction2.setAckSeen();
                                    sipStack.removeTransaction(ackTransaction2);
                                    sipStack.removeTransactionPendingAck(ackTransaction2);
                                }
                                catch (Exception ex) {
                                    if (!logger.isLoggingEnabled()) break block164;
                                    logger.logError("Problem terminating transaction", ex);
                                }
                            }
                        }
                        if (!sipStack.isDeliverRetransmittedAckToListener() || ackTransaction2 != null && !sipStack.isNon2XXAckPassedToListener()) {
                            return;
                        }
                    }
                } else {
                    dialog.addTransaction(transaction);
                    transaction.passToListener();
                    dialog.addRoute(sipRequest);
                    transaction.setDialog(dialog, dialogId);
                    if (sipRequest.getMethod().equals("INVITE") && sipProvider.isDialogErrorsAutomaticallyHandled()) {
                        sipStack.putInMergeTable(transaction, sipRequest);
                    }
                    if (sipStack.isDeliverTerminatedEventForAck()) {
                        try {
                            sipStack.addTransaction(transaction);
                            transaction.scheduleAckRemoval();
                        }
                        catch (IOException ex) {}
                    } else {
                        transaction.setMapped(true);
                    }
                }
            }
        } else if (sipRequestMethod.equals("PRACK")) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Processing PRACK for dialog " + dialog);
            }
            if (dialog == null && sipProvider.isAutomaticDialogSupportEnabled()) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dialog does not exist " + sipRequest.getFirstLine() + " isServerTransaction = " + true);
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Sending 481 for PRACK - automatic dialog support is enabled -- cant find dialog!");
                }
                SIPResponse notExist = sipRequest.createResponse(481);
                try {
                    sipProvider.sendResponse(notExist);
                }
                catch (SipException e) {
                    logger.logError("error sending response", e);
                }
                if (transaction != null) {
                    sipStack.removeTransaction(transaction);
                    transaction.releaseSem();
                }
                return;
            }
            if (dialog != null) {
                if (!dialog.handlePrack(sipRequest)) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Dropping out of sequence PRACK ");
                    }
                    if (transaction != null) {
                        sipStack.removeTransaction(transaction);
                        transaction.releaseSem();
                    }
                    return;
                }
                try {
                    sipStack.addTransaction(transaction);
                    dialog.addTransaction(transaction);
                    dialog.addRoute(sipRequest);
                    transaction.setDialog(dialog, dialogId);
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex);
                }
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Processing PRACK without a DIALOG -- this must be a proxy element");
            }
        } else if (sipRequestMethod.equals("BYE")) {
            if (dialog != null && !dialog.isRequestConsumable(sipRequest)) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dropping out of sequence BYE " + dialog.getRemoteSeqNumber() + " " + sipRequest.getCSeq().getSeqNumber());
                }
                if (dialog.getRemoteSeqNumber() > sipRequest.getCSeq().getSeqNumber()) {
                    this.sendServerInternalErrorResponse(sipRequest, transaction);
                } else if (transaction.getInternalState() == 2) {
                    this.sendTryingResponse(sipRequest, transaction);
                }
                sipStack.removeTransaction(transaction);
                return;
            }
            if (dialog == null && sipProvider.isAutomaticDialogSupportEnabled()) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("dropping request -- automatic dialog support enabled and dialog does not exist!");
                }
                this.sendCallOrTransactionDoesNotExistResponse(sipRequest, transaction);
                if (transaction != null) {
                    sipStack.removeTransaction(transaction);
                    transaction.releaseSem();
                    transaction = null;
                }
                return;
            }
            if (transaction != null && dialog != null) {
                try {
                    if (sipProvider == dialog.getSipProvider()) {
                        sipStack.addTransaction(transaction);
                        dialog.addTransaction(transaction);
                        transaction.setDialog(dialog, dialogId);
                    }
                }
                catch (IOException ex) {
                    InternalErrorHandler.handleException(ex);
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("BYE Tx = " + transaction + " isMapped =" + transaction.isTransactionMapped());
            }
        } else if (sipRequestMethod.equals("CANCEL")) {
            st = (SIPServerTransaction)sipStack.findCancelTransaction(sipRequest, true);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Got a CANCEL, InviteServerTx = " + st + " cancel Server Tx ID = " + transaction + " isMapped = " + transaction.isTransactionMapped());
            }
            if (sipRequest.getMethod().equals("CANCEL")) {
                if (st != null && st.getInternalState() == 5) {
                    block165: {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Too late to cancel Transaction");
                        }
                        try {
                            transaction.sendResponse(sipRequest.createResponse(200));
                        }
                        catch (Exception ex) {
                            if (ex.getCause() == null || !(ex.getCause() instanceof IOException)) break block165;
                            st.raiseIOExceptionEvent();
                        }
                    }
                    return;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Cancel transaction = " + st);
                }
            }
            if (transaction != null && st != null && st.getDialog() != null) {
                transaction.setDialog((SIPDialog)st.getDialog(), dialogId);
                dialog = (SIPDialog)st.getDialog();
            } else if (st == null && sipProvider.isAutomaticDialogSupportEnabled() && transaction != null) {
                SIPResponse response = sipRequest.createResponse(481);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("dropping request -- automatic dialog support enabled and INVITE ST does not exist!");
                }
                try {
                    sipProvider.sendResponse(response);
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (transaction != null) {
                    sipStack.removeTransaction(transaction);
                    transaction.releaseSem();
                }
                return;
            }
            if (st != null) {
                st.setPassToListener();
                try {
                    if (transaction != null) {
                        sipStack.addTransaction(transaction);
                        transaction.setPassToListener();
                        transaction.setInviteTransaction(st);
                        st.acquireSem();
                    }
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex);
                }
            }
        } else if (sipRequestMethod.equals("INVITE")) {
            SIPTransaction lastTransaction;
            SIPTransaction sIPTransaction = lastTransaction = dialog == null ? null : dialog.getInviteTransaction();
            if (dialog != null && transaction != null && lastTransaction != null && sipRequest.getCSeq().getSeqNumber() > lastTransaction.getCSeq() && lastTransaction instanceof SIPServerTransaction && sipProvider.isDialogErrorsAutomaticallyHandled() && dialog.isSequenceNumberValidation() && lastTransaction.isInviteTransaction() && lastTransaction.getInternalState() != 3 && lastTransaction.getInternalState() != 5 && lastTransaction.getInternalState() != 4) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Sending 500 response for out of sequence message");
                }
                this.sendServerInternalErrorResponse(sipRequest, transaction);
                return;
            }
            SIPTransaction sIPTransaction2 = lastTransaction = dialog == null ? null : dialog.getLastTransaction();
            if (dialog != null && sipProvider.isDialogErrorsAutomaticallyHandled() && lastTransaction != null && lastTransaction.isInviteTransaction() && lastTransaction instanceof ClientTransaction && lastTransaction.getState() != TransactionState.COMPLETED && lastTransaction.getState() != TransactionState.TERMINATED) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("DialogFilter::processRequest:lastTransaction.getState(): " + lastTransaction.getState() + " Sending 491 response for clientTx.");
                }
                this.sendRequestPendingResponse(sipRequest, transaction);
                return;
            }
            if (dialog != null && lastTransaction != null && sipProvider.isDialogErrorsAutomaticallyHandled() && lastTransaction.isInviteTransaction() && lastTransaction instanceof ServerTransaction && sipRequest.getCSeq().getSeqNumber() > lastTransaction.getCSeq() && (lastTransaction.getInternalState() == 2 || lastTransaction.getInternalState() == 1)) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Sending 491 response. Last transaction is in PROCEEDING state.");
                    logger.logDebug("last Transaction state = " + lastTransaction + " state " + lastTransaction.getState());
                }
                this.sendRequestPendingResponse(sipRequest, transaction);
                return;
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("CHECK FOR OUT OF SEQ MESSAGE " + dialog + " transaction " + transaction);
        }
        if (!(dialog == null || transaction == null || sipRequestMethod.equals("BYE") || sipRequestMethod.equals("CANCEL") || sipRequestMethod.equals("ACK") || sipRequestMethod.equals("PRACK"))) {
            if (!dialog.isRequestConsumable(sipRequest)) {
                block166: {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Dropping out of sequence message " + dialog.getRemoteSeqNumber() + " " + sipRequest.getCSeq());
                    }
                    if (dialog.getRemoteSeqNumber() > sipRequest.getCSeq().getSeqNumber() && sipProvider.isDialogErrorsAutomaticallyHandled()) {
                        this.sendServerInternalErrorResponse(sipRequest, transaction);
                    } else {
                        try {
                            transaction.terminate();
                        }
                        catch (ObjectInUseException e) {
                            if (!logger.isLoggingEnabled()) break block166;
                            logger.logError("Unexpected exception", e);
                        }
                    }
                }
                return;
            }
            try {
                if (sipProvider == dialog.getSipProvider()) {
                    sipStack.addTransaction(transaction);
                    if (!dialog.addTransaction(transaction)) {
                        return;
                    }
                    dialog.addRoute(sipRequest);
                    transaction.setDialog(dialog, dialogId);
                }
            }
            catch (IOException ex) {
                transaction.raiseIOExceptionEvent();
                sipStack.removeTransaction(transaction);
                return;
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(sipRequest.getMethod() + " transaction.isMapped = " + transaction.isTransactionMapped());
        }
        if (dialog == null && sipRequestMethod.equals("NOTIFY")) {
            SIPClientTransaction pendingSubscribeClientTx = sipStack.findSubscribeTransaction(sipRequest, this.listeningPoint);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("PROCESSING NOTIFY  DIALOG == null " + pendingSubscribeClientTx);
            }
            if (sipProvider.isAutomaticDialogSupportEnabled() && pendingSubscribeClientTx == null && !sipStack.isDeliverUnsolicitedNotify()) {
                try {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Could not find Subscription for Notify Tx.");
                    }
                    SIPResponse errorResponse = sipRequest.createResponse(481);
                    errorResponse.setReasonPhrase("Subscription does not exist");
                    sipProvider.sendResponse(errorResponse);
                    return;
                }
                catch (Exception ex) {
                    logger.logError("Exception while sending error response statelessly", ex);
                    return;
                }
            }
            if (pendingSubscribeClientTx != null) {
                transaction.setPendingSubscribe(pendingSubscribeClientTx);
                SIPDialog subscriptionDialog = pendingSubscribeClientTx.getDefaultDialog();
                if (subscriptionDialog == null || subscriptionDialog.getDialogId() == null || !subscriptionDialog.getDialogId().equals(dialogId)) {
                    Event event;
                    if (subscriptionDialog != null && subscriptionDialog.getDialogId() == null) {
                        subscriptionDialog.setDialogId(dialogId);
                    } else {
                        subscriptionDialog = pendingSubscribeClientTx.getDialog(dialogId);
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("PROCESSING NOTIFY Subscribe DIALOG " + subscriptionDialog);
                    }
                    if (subscriptionDialog == null && (sipProvider.isAutomaticDialogSupportEnabled() || pendingSubscribeClientTx.getDefaultDialog() != null) && sipStack.isEventForked((event = (Event)sipRequest.getHeader("Event")).getEventType())) {
                        subscriptionDialog = sipStack.createDialog(pendingSubscribeClientTx, transaction);
                    }
                    if (subscriptionDialog != null) {
                        transaction.setDialog(subscriptionDialog, dialogId);
                        if (subscriptionDialog.getState() != DialogState.CONFIRMED) {
                            subscriptionDialog.setPendingRouteUpdateOn202Response(sipRequest);
                        }
                        subscriptionDialog.setState(DialogState.CONFIRMED.getValue());
                        sipStack.putDialog(subscriptionDialog);
                        pendingSubscribeClientTx.setDialog(subscriptionDialog, dialogId);
                        if (!transaction.isTransactionMapped()) {
                            this.sipStack.mapTransaction(transaction);
                            transaction.setPassToListener();
                            try {
                                this.sipStack.addTransaction(transaction);
                            }
                            catch (Exception ex) {}
                        }
                    }
                } else {
                    transaction.setDialog(subscriptionDialog, dialogId);
                    dialog = subscriptionDialog;
                    if (!transaction.isTransactionMapped()) {
                        this.sipStack.mapTransaction(transaction);
                        transaction.setPassToListener();
                        try {
                            this.sipStack.addTransaction(transaction);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    sipStack.putDialog(subscriptionDialog);
                    if (pendingSubscribeClientTx != null) {
                        subscriptionDialog.addTransaction(pendingSubscribeClientTx);
                        pendingSubscribeClientTx.setDialog(subscriptionDialog, dialogId);
                    }
                }
                sipEvent = transaction != null && transaction.isTransactionMapped() ? new RequestEventExt(sipProvider, transaction, subscriptionDialog, sipRequest) : new RequestEventExt(sipProvider, null, subscriptionDialog, sipRequest);
            } else {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("could not find subscribe tx");
                }
                sipEvent = new RequestEventExt(sipProvider, null, null, sipRequest);
            }
        } else {
            sipEvent = transaction != null && transaction.isTransactionMapped() ? new RequestEventExt(sipProvider, transaction, dialog, sipRequest) : new RequestEventExt(sipProvider, null, dialog, sipRequest);
        }
        sipEvent.setRemoteIpAddress(sipRequest.getRemoteAddress().getHostAddress());
        sipEvent.setRemotePort(sipRequest.getRemotePort());
        sipProvider.handleEvent(sipEvent, transaction);
    }

    @Override
    public void processResponse(SIPResponse response, MessageChannel incomingMessageChannel, SIPDialog dialog) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("PROCESSING INCOMING RESPONSE" + response.encodeMessage(new StringBuilder()));
        }
        if (this.listeningPoint == null) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Dropping message: No listening point registered!");
            }
            return;
        }
        if (this.sipStack.checkBranchId() && !Utils.getInstance().responseBelongsToUs(response)) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Dropping response - topmost VIA header does not originate from this stack");
            }
            return;
        }
        SipProviderImpl sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Dropping message:  no provider");
            }
            return;
        }
        if (sipProvider.getSipListener() == null) {
            if (logger.isLoggingEnabled()) {
                logger.logError("No listener -- dropping response!");
            }
            return;
        }
        SIPClientTransaction transaction = (SIPClientTransaction)this.transactionChannel;
        SipStackImpl sipStackImpl = sipProvider.sipStack;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Transaction = " + transaction);
        }
        if (transaction == null) {
            if (dialog != null) {
                if (response.getStatusCode() / 100 != 2) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Response is not a final response and dialog is found for response -- dropping response!");
                    }
                    return;
                }
                if (dialog.getState() == DialogState.TERMINATED) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Dialog is terminated -- dropping response!");
                    }
                    return;
                }
                boolean ackAlreadySent = false;
                if (dialog.isAckSeen() && dialog.getLastAckSent() != null && dialog.getLastAckSent().getCSeq().getSeqNumber() == response.getCSeq().getSeqNumber()) {
                    ackAlreadySent = true;
                }
                if (ackAlreadySent && response.getCSeq().getMethod().equals(dialog.getMethod())) {
                    try {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Retransmission of OK detected: Resending last ACK");
                        }
                        dialog.resendAck();
                        return;
                    }
                    catch (SipException ex) {
                        logger.logError("could not resend ack", ex);
                    }
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("could not find tx, handling statelessly Dialog =  " + dialog);
            }
            ResponseEventExt sipEvent = new ResponseEventExt((Object)sipProvider, transaction, (Dialog)dialog, (Response)response);
            if (this.sipStack.getMaxForkTime() != 0 && SIPTransactionStack.isDialogCreated(response.getCSeqHeader().getMethod())) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Trying to find forked Transaction for forked id " + response.getForkId());
                }
                SIPClientTransaction forked = this.sipStack.getForkedTransaction(response.getForkId());
                if (dialog != null && forked != null) {
                    dialog.checkRetransmissionForForking(response);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("original dialog " + forked.getDefaultDialog() + " forked dialog " + dialog);
                    }
                    if (forked.getDefaultDialog() != null && !dialog.equals(forked.getDefaultDialog())) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("forkedId= " + response.getForkId() + " forked dialog " + dialog + " original tx " + forked + " original dialog " + forked.getDefaultDialog());
                        }
                        sipEvent.setOriginalTransaction(forked);
                        sipEvent.setForkedResponse(true);
                        if (transaction == null && dialog.getState() == DialogState.EARLY && response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                            dialog.setLastResponse(transaction, response);
                        }
                    }
                }
            }
            sipEvent.setRetransmission(response.isRetransmission());
            sipEvent.setRemoteIpAddress(response.getRemoteAddress().getHostAddress());
            sipEvent.setRemotePort(response.getRemotePort());
            sipProvider.handleEvent(sipEvent, transaction);
            return;
        }
        ResponseEventExt responseEvent = new ResponseEventExt((Object)sipProvider, transaction, (Dialog)dialog, (Response)response);
        if (this.sipStack.getMaxForkTime() != 0 && SIPTransactionStack.isDialogCreated(response.getCSeqHeader().getMethod())) {
            SIPClientTransaction forked = this.sipStack.getForkedTransaction(response.getForkId());
            if (dialog != null && forked != null) {
                dialog.checkRetransmissionForForking(response);
                if (forked.getDefaultDialog() != null && !dialog.equals(forked.getDefaultDialog())) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("forkedId= " + response.getForkId() + " forked dialog " + dialog + " original tx " + forked + " original dialog " + forked.getDefaultDialog());
                    }
                    responseEvent.setOriginalTransaction(forked);
                    responseEvent.setForkedResponse(true);
                }
            }
        }
        if (dialog != null && response.getStatusCode() != 100) {
            dialog.setLastResponse(transaction, response);
            transaction.setDialog(dialog, dialog.getDialogId());
        }
        responseEvent.setRetransmission(response.isRetransmission());
        responseEvent.setRemoteIpAddress(response.getRemoteAddress().getHostAddress());
        responseEvent.setRemotePort(response.getRemotePort());
        sipProvider.handleEvent(responseEvent, transaction);
    }

    public String getProcessingInfo() {
        return null;
    }

    @Override
    public void processResponse(SIPResponse sipResponse, MessageChannel incomingChannel) {
        String dialogID = sipResponse.getDialogId(false);
        SIPDialog sipDialog = this.sipStack.getDialog(dialogID);
        String method = sipResponse.getCSeq().getMethod();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("PROCESSING INCOMING RESPONSE: " + sipResponse.encodeMessage(new StringBuilder()));
        }
        if (this.sipStack.checkBranchId() && !Utils.getInstance().responseBelongsToUs(sipResponse)) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Detected stray response -- dropping");
            }
            return;
        }
        if (this.listeningPoint == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping message: No listening point registered!");
            }
            return;
        }
        SipProviderImpl sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping message:  no provider");
            }
            return;
        }
        if (sipProvider.getSipListener() == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping message:  no sipListener registered!");
            }
            return;
        }
        SIPClientTransaction transaction = (SIPClientTransaction)this.transactionChannel;
        if (sipDialog == null && transaction != null && (sipDialog = transaction.getDialog(dialogID)) != null && sipDialog.getState() == DialogState.TERMINATED) {
            sipDialog = null;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Transaction = " + transaction + " sipDialog = " + sipDialog);
        }
        if (this.transactionChannel != null) {
            String originalFrom = ((SIPRequest)this.transactionChannel.getRequest()).getFromTag();
            if (originalFrom == null ^ sipResponse.getFrom().getTag() == null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("From tag mismatch -- dropping response");
                }
                return;
            }
            if (originalFrom != null && !originalFrom.equalsIgnoreCase(sipResponse.getFrom().getTag())) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("From tag mismatch -- dropping response");
                }
                return;
            }
        }
        boolean createDialog = false;
        if (SIPTransactionStack.isDialogCreated(method) && sipResponse.getStatusCode() != 100 && sipResponse.getFrom().getTag() != null && sipResponse.getTo().getTag() != null && sipDialog == null) {
            if (sipProvider.isAutomaticDialogSupportEnabled()) {
                createDialog = true;
            } else {
                SIPClientTransaction originalTx = this.sipStack.getForkedTransaction(sipResponse.getForkId());
                if (originalTx != null && originalTx.getDefaultDialog() != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Need to create dialog for response = " + sipResponse);
                    }
                    createDialog = true;
                }
            }
            if (createDialog) {
                if (this.transactionChannel != null) {
                    if (sipDialog == null) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Creating dialog for forked response " + sipResponse);
                        }
                        sipDialog = this.sipStack.createDialog((SIPClientTransaction)this.transactionChannel, sipResponse);
                        this.transactionChannel.setDialog(sipDialog, sipResponse.getDialogId(false));
                    }
                } else {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Creating dialog for forked response " + sipResponse);
                    }
                    sipDialog = this.sipStack.createDialog(sipProvider, sipResponse);
                }
            }
        } else if (sipDialog != null && transaction == null && sipDialog.getState() != DialogState.TERMINATED) {
            if (sipResponse.getStatusCode() / 100 != 2) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("status code != 200 ; statusCode = " + sipResponse.getStatusCode());
                }
            } else {
                if (sipDialog.getState() == DialogState.TERMINATED) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Dialog is terminated -- dropping response!");
                    }
                    if (sipResponse.getStatusCode() / 100 == 2 && sipResponse.getCSeq().getMethod().equals("INVITE")) {
                        try {
                            Request ackRequest = sipDialog.createAck(sipResponse.getCSeq().getSeqNumber());
                            sipDialog.sendAck(ackRequest);
                        }
                        catch (Exception ex) {
                            logger.logError("Error creating ack", ex);
                        }
                    }
                    return;
                }
                boolean ackAlreadySent = false;
                if (sipDialog.getLastAckSent() != null && sipDialog.getLastAckSent().getCSeq().getSeqNumber() == sipResponse.getCSeq().getSeqNumber() && sipResponse.getDialogId(false).equals(sipDialog.getLastAckSent().getDialogId(false))) {
                    ackAlreadySent = true;
                }
                if (ackAlreadySent && sipResponse.getCSeq().getMethod().equals(sipDialog.getMethod())) {
                    try {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("resending ACK");
                        }
                        sipDialog.resendAck();
                        return;
                    }
                    catch (SipException ex) {
                        // empty catch block
                    }
                }
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sending response " + sipResponse.toString() + " to TU for processing ");
        }
        ResponseEventExt responseEvent = new ResponseEventExt((Object)sipProvider, transaction, (Dialog)sipDialog, (Response)sipResponse);
        responseEvent.setRemoteIpAddress(sipResponse.getRemoteAddress().getHostAddress());
        responseEvent.setRemotePort(sipResponse.getRemotePort());
        if (this.sipStack.getMaxForkTime() != 0 && SIPTransactionStack.isDialogCreated(sipResponse.getCSeqHeader().getMethod())) {
            SIPClientTransaction originalTx = this.sipStack.getForkedTransaction(sipResponse.getForkId());
            if (sipDialog != null && originalTx != null) {
                sipDialog.checkRetransmissionForForking(sipResponse);
                if (originalTx.getDefaultDialog() != null && !sipDialog.equals(originalTx.getDefaultDialog())) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("forkedId= " + sipResponse.getForkId() + " forked dialog " + sipDialog + " original tx " + originalTx + " original dialog " + originalTx.getDefaultDialog());
                    }
                    responseEvent.setOriginalTransaction(originalTx);
                    responseEvent.setForkedResponse(true);
                }
            }
        }
        if (sipDialog != null && sipResponse.getStatusCode() != 100 && sipResponse.getTo().getTag() != null) {
            sipDialog.setLastResponse(transaction, sipResponse);
        }
        responseEvent.setRetransmission(sipResponse.isRetransmission());
        responseEvent.setRemoteIpAddress(sipResponse.getRemoteAddress().getHostAddress());
        sipProvider.handleEvent(responseEvent, transaction);
    }
}

