/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.HandlerOperations;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperationTransformer;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.LoggingResourceTransformer;

abstract class AbstractHandlerDefinition
extends SimpleResourceDefinition {
    public static final String UPDATE_OPERATION_NAME = "update-properties";
    public static final String CHANGE_LEVEL_OPERATION_NAME = "change-log-level";
    static final AttributeDefinition[] DEFAULT_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.LEVEL, CommonAttributes.ENABLED, CommonAttributes.ENCODING, CommonAttributes.FORMATTER, CommonAttributes.FILTER_SPEC};
    static final AttributeDefinition[] LEGACY_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.FILTER};
    static final ResourceDescriptionResolver HANDLER_RESOLVER = LoggingExtension.getResourceDescriptionResolver(CommonAttributes.HANDLER.getName());
    static final SimpleOperationDefinition ENABLE_HANDLER = new SimpleOperationDefinitionBuilder("enable", HANDLER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build();
    static final SimpleOperationDefinition DISABLE_HANDLER = new SimpleOperationDefinitionBuilder("disable", HANDLER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build();
    static final SimpleOperationDefinition CHANGE_LEVEL = new SimpleOperationDefinitionBuilder("change-log-level", HANDLER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(new AttributeDefinition[]{CommonAttributes.LEVEL}).build();
    private final OperationStepHandler writeHandler;
    private final AttributeDefinition[] writableAttributes;
    private final AttributeDefinition[] readOnlyAttributes;

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, AttributeDefinition[] attributes) {
        this(path, type, attributes, null, attributes, new ConfigurationProperty[0]);
    }

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, AttributeDefinition[] attributes, ConfigurationProperty<?> ... constructionProperties) {
        this(path, type, attributes, null, attributes, constructionProperties);
    }

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, AttributeDefinition[] addAttributes, AttributeDefinition[] readOnlyAttributes, AttributeDefinition[] writableAttributes, ConfigurationProperty<?> ... constructionProperties) {
        super(path, HANDLER_RESOLVER, (OperationStepHandler)new HandlerOperations.HandlerAddOperationStepHandler(type, addAttributes, constructionProperties), HandlerOperations.REMOVE_HANDLER);
        this.writableAttributes = writableAttributes;
        this.writeHandler = new HandlerOperations.LogHandlerWriteAttributeHandler(this.writableAttributes);
        this.readOnlyAttributes = readOnlyAttributes;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : this.writableAttributes) {
            if (def.getName().equals(CommonAttributes.FILTER.getName())) {
                resourceRegistration.registerReadWriteAttribute(def, (OperationStepHandler)LoggingOperations.ReadFilterOperationStepHandler.INSTANCE, this.writeHandler);
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(def, null, this.writeHandler);
        }
        if (this.readOnlyAttributes != null) {
            for (AttributeDefinition def : this.readOnlyAttributes) {
                resourceRegistration.registerReadOnlyAttribute(def, null);
            }
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CommonAttributes.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        registration.registerOperationHandler((OperationDefinition)ENABLE_HANDLER, (OperationStepHandler)HandlerOperations.ENABLE_HANDLER);
        registration.registerOperationHandler((OperationDefinition)DISABLE_HANDLER, (OperationStepHandler)HandlerOperations.DISABLE_HANDLER);
        registration.registerOperationHandler((OperationDefinition)CHANGE_LEVEL, HandlerOperations.CHANGE_LEVEL);
        SimpleOperationDefinition updateProperties = new SimpleOperationDefinitionBuilder(UPDATE_OPERATION_NAME, HANDLER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(this.writableAttributes).build();
        registration.registerOperationHandler((OperationDefinition)updateProperties, (OperationStepHandler)new HandlerOperations.HandlerUpdateOperationStepHandler(this.writableAttributes));
    }

    static ResourceTransformationDescriptionBuilder registerTransformers(ResourceTransformationDescriptionBuilder handlerBuilder) {
        handlerBuilder.addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)LoggingOperationTransformer.INSTANCE).inheritResourceAttributeDefinitions().end().addOperationTransformationOverride("write-attribute").setCustomOperationTransformer((OperationTransformer)LoggingOperationTransformer.INSTANCE).inheritResourceAttributeDefinitions().end().addOperationTransformationOverride(UPDATE_OPERATION_NAME).setCustomOperationTransformer((OperationTransformer)LoggingOperationTransformer.INSTANCE).inheritResourceAttributeDefinitions().end().setCustomResourceTransformer((ResourceTransformer)new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.NAME, CommonAttributes.FILTER_SPEC, CommonAttributes.ENABLED}));
        return ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)handlerBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, DEFAULT_ATTRIBUTES)).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, LEGACY_ATTRIBUTES)).end();
    }
}

