/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.proxy;

import gov.nist.javax.sip.TransactionExt;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.MessageExt;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.sip.ClientTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.ProxyBranchListener;
import org.mobicents.javax.servlet.sip.ResponseType;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.core.DispatcherException;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxy;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxyBranch;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyBranchTimerTask;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.proxy.ProxyUtils;
import org.mobicents.servlet.sip.rfc5626.IncorrectFlowIdentifierException;
import org.mobicents.servlet.sip.rfc5626.RFC5626Helper;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class ProxyBranchImpl
implements MobicentsProxyBranch,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ProxyBranchImpl.class);
    private transient ProxyImpl proxy;
    private transient SipServletRequestImpl originalRequest;
    private transient SipServletRequestImpl prackOriginalRequest;
    private transient SipServletRequestImpl outgoingRequest;
    private transient SipServletResponseImpl lastResponse;
    private URI targetURI;
    private transient SipURI outboundInterface;
    private transient SipURI recordRouteURI;
    private boolean recordRoutingEnabled;
    private boolean appSpecifiedRecordRoutingEnabled = false;
    private boolean recurse;
    private transient SipURI pathURI;
    private boolean started;
    private boolean timedOut;
    private int proxyBranchTimeout;
    private int proxyBranch1xxTimeout;
    private transient ProxyBranchTimerTask proxyTimeoutTask;
    private transient ProxyBranchTimerTask proxy1xxTimeoutTask;
    private transient boolean proxyBranchTimerStarted;
    private transient boolean proxyBranch1xxTimerStarted;
    private transient Object cTimerLock;
    private boolean canceled;
    private boolean isAddToPath;
    private transient List<ProxyBranch> recursedBranches;
    private boolean waitingForPrack;
    public transient ViaHeader viaHeader;
    public transient List<TransactionRequest> ongoingTransactions = new LinkedList<TransactionRequest>();

    public ProxyBranchImpl() {
    }

    public ProxyBranchImpl(URI uri, ProxyImpl proxy) {
        this.targetURI = uri;
        this.proxy = proxy;
        this.isAddToPath = proxy.getAddToPath();
        this.originalRequest = (SipServletRequestImpl)proxy.getOriginalRequest();
        this.recordRouteURI = proxy.recordRouteURI;
        this.pathURI = proxy.pathURI;
        this.outboundInterface = proxy.getOutboundInterface();
        if (this.recordRouteURI != null) {
            this.recordRouteURI = ((SipURIImpl)this.recordRouteURI).clone();
        }
        this.proxyBranchTimeout = proxy.getProxyTimeout();
        this.proxyBranch1xxTimeout = proxy.getProxy1xxTimeout();
        this.canceled = false;
        this.recursedBranches = new ArrayList<ProxyBranch>();
        this.proxyBranchTimerStarted = false;
        this.cTimerLock = new Object();
        Request cloned = (Request)this.originalRequest.getMessage().clone();
        ((MessageExt)cloned).setApplicationData(null);
        this.outgoingRequest = (SipServletRequestImpl)proxy.getSipFactoryImpl().getMobicentsSipServletMessageFactory().createSipServletRequest(cloned, this.originalRequest.getSipSession(), null, null, false);
    }

    public void cancel() {
        this.cancel(null, null, null);
    }

    public void cancel(String[] protocol, int[] reasonCode, String[] reasonText) {
        if (this.proxy.getAckReceived()) {
            throw new IllegalStateException("There has been an ACK received on this branch. Can not cancel.");
        }
        try {
            this.cancelTimer();
            if (this.isStarted() && !this.canceled && !this.timedOut && (this.outgoingRequest.getMethod().equalsIgnoreCase("INVITE") || this.outgoingRequest.getMethod().equalsIgnoreCase("PRACK") || this.outgoingRequest.getMethod().equalsIgnoreCase("UPDATE"))) {
                if (this.lastResponse != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Trying to cancel ProxyBranch for outgoing request " + this.outgoingRequest));
                    }
                    if (this.lastResponse.getStatus() > 200 && !this.recursedBranches.isEmpty()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("lastResponse status for this branch is " + this.lastResponse.getStatus() + " and it has " + this.recursedBranches.size() + " to cancel"));
                        }
                        return;
                    }
                    SipServletRequest cancelRequest = null;
                    cancelRequest = this.outgoingRequest.getMethod().equalsIgnoreCase("PRACK") || this.outgoingRequest.getMethod().equalsIgnoreCase("UPDATE") ? this.originalRequest.getLinkedRequest().createCancel() : this.outgoingRequest.createCancel();
                    if (protocol != null && reasonCode != null && reasonText != null && protocol.length == reasonCode.length && reasonCode.length == reasonText.length) {
                        for (int i = 0; i < protocol.length; ++i) {
                            String reasonHeaderValue = protocol[i] + ";cause=" + reasonCode[i];
                            if (reasonText[i] != null && reasonText[i].trim().length() > 0) {
                                reasonHeaderValue = reasonHeaderValue.concat(";text=\"" + reasonText[i] + "\"");
                            }
                            ((SipServletRequestImpl)cancelRequest).setHeaderInternal("Reason", reasonHeaderValue, false);
                        }
                    }
                    cancelRequest.send();
                } else {
                    SIPClientTransaction tx = (SIPClientTransaction)this.outgoingRequest.getTransaction();
                    if (tx != null) {
                        StaticServiceHolder.disableRetransmissionTimer.invoke((Object)tx, new Object[0]);
                    } else {
                        logger.warn((Object)"Transaction is null. Can not stop retransmission, they are already dead in the branch.");
                    }
                }
                this.canceled = true;
            }
            if (!this.isStarted() && (this.outgoingRequest.getMethod().equalsIgnoreCase("INVITE") || this.outgoingRequest.getMethod().equalsIgnoreCase("PRACK"))) {
                this.canceled = true;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed canceling proxy branch", e);
        }
        finally {
            this.onBranchTerminated();
        }
    }

    public void onBranchTerminated() {
        if (this.outgoingRequest != null) {
            String txid = ((ViaHeader)this.outgoingRequest.getMessage().getHeader("Via")).getBranch();
            this.proxy.removeTransaction(txid);
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public int getProxyBranchTimeout() {
        return this.proxyBranchTimeout;
    }

    public SipURI getRecordRouteURI() {
        if (this.getRecordRoute()) {
            if (this.recordRouteURI == null) {
                this.recordRouteURI = this.proxy.getSipFactoryImpl().createSipURI("proxy", "localhost");
            }
            return this.recordRouteURI;
        }
        throw new IllegalStateException("Record Route not enabled for this ProxyBranch. You must call proxyBranch.setRecordRoute(true) before getting an URI.");
    }

    public List<ProxyBranch> getRecursedProxyBranches() {
        return this.recursedBranches;
    }

    public void addRecursedBranch(ProxyBranchImpl branch) {
        this.recursedBranches.add((ProxyBranch)branch);
    }

    public SipServletRequestImpl getMatchingRequest(SipServletRequestImpl request) {
        if (request.getMethod().equals("ACK")) {
            Iterator<TransactionApplicationData> ongoingTransactions = this.proxy.getTransactionMap().values().iterator();
            if (ongoingTransactions != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"going through all tx to check if we have the matching request to the ACK for branchId");
                }
                while (ongoingTransactions.hasNext()) {
                    TransactionApplicationData transactionApplicationData = ongoingTransactions.next();
                    SipServletMessageImpl sipServletMessage = transactionApplicationData.getSipServletMessage();
                    if (sipServletMessage == null || !(sipServletMessage instanceof SipServletRequestImpl) || ((MessageExt)request.getMessage()).getCSeqHeader().getSeqNumber() != ((MessageExt)sipServletMessage.getMessage()).getCSeqHeader().getSeqNumber() || !((MessageExt)request.getMessage()).getCallIdHeader().getCallId().equals(((MessageExt)sipServletMessage.getMessage()).getCallIdHeader().getCallId())) continue;
                    return (SipServletRequestImpl)sipServletMessage;
                }
            }
            return null;
        }
        return this.outgoingRequest;
    }

    public SipServletRequest getRequest() {
        return this.outgoingRequest;
    }

    public MobicentsSipServletResponse getResponse() {
        return this.lastResponse;
    }

    public void setResponse(MobicentsSipServletResponse response) {
        this.lastResponse = (SipServletResponseImpl)response;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setProxyBranchTimeout(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Negative or zero timeout not allowed");
        }
        if (this.isCanceled() || this.isTimedOut()) {
            logger.error((Object)"Cancelled or timed out proxy branch should not be updated with new timeout values");
            return;
        }
        this.proxyBranchTimeout = seconds;
        if (this.started) {
            this.updateTimer(false);
        }
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("Proxy branch alredy started!");
        }
        if (this.canceled) {
            throw new IllegalStateException("Proxy branch was cancelled, you must create a new branch!");
        }
        if (this.timedOut) {
            throw new IllegalStateException("Proxy brnach has timed out!");
        }
        if (this.proxy.getAckReceived()) {
            throw new IllegalStateException("An ACK request has been received on this proxy. Can not start new branches.");
        }
        this.updateTimer(false);
        SipURI recordRoute = null;
        if (this.proxy.getRecordRoute() || this.getRecordRoute()) {
            if (this.recordRouteURI == null) {
                this.recordRouteURI = this.proxy.getSipFactoryImpl().createSipURI("proxy", "localhost");
            }
            recordRoute = this.recordRouteURI;
        }
        this.addTransaction(this.originalRequest);
        Request cloned = ProxyUtils.createProxiedRequest(this.outgoingRequest, this, this.targetURI, this.outboundInterface, recordRoute, this.pathURI);
        this.originalRequest.setRoutingState(RoutingState.PROXIED);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Proxy Branch 1xx Timeout set to " + this.proxyBranch1xxTimeout));
        }
        if (this.proxyBranch1xxTimeout > 0) {
            this.proxy1xxTimeoutTask = new ProxyBranchTimerTask(this, ResponseType.INFORMATIONAL);
            this.proxy.getProxyTimerService().schedule((TimerTask)this.proxy1xxTimeoutTask, (long)this.proxyBranch1xxTimeout * 1000L);
            this.proxyBranch1xxTimerStarted = true;
        }
        this.started = true;
        this.forwardRequest(cloned, false);
    }

    private void forwardRequest(Request request, boolean subsequent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("creating cloned Request for proxybranch " + request));
        }
        SipServletRequestImpl clonedRequest = (SipServletRequestImpl)this.proxy.getSipFactoryImpl().getMobicentsSipServletMessageFactory().createSipServletRequest(request, null, null, null, false);
        if (subsequent) {
            clonedRequest.setRoutingState(RoutingState.SUBSEQUENT);
        }
        this.outgoingRequest = clonedRequest;
        MobicentsSipSession originalSipSession = this.originalRequest.getSipSession();
        clonedRequest.setCurrentApplicationName(this.originalRequest.getCurrentApplicationName());
        if (clonedRequest.getCurrentApplicationName() == null && subsequent) {
            clonedRequest.setCurrentApplicationName(originalSipSession.getSipApplicationSession().getApplicationName());
        }
        clonedRequest.setSipSession(originalSipSession);
        MobicentsSipSession newSession = clonedRequest.getSipSession();
        try {
            newSession.setHandler(originalSipSession.getHandler());
        }
        catch (ServletException e) {
            logger.error((Object)"could not set the session handler while forwarding the request", (Throwable)e);
            throw new RuntimeException("could not set the session handler while forwarding the request", e);
        }
        newSession.setProxy((MobicentsProxy)this.proxy);
        try {
            RFC5626Helper.checkRequest(this, request, this.originalRequest);
        }
        catch (IncorrectFlowIdentifierException e1) {
            logger.warn((Object)e1.getMessage());
            this.cancel();
            try {
                this.originalRequest.createResponse(403).send();
            }
            catch (IOException e) {
                logger.error((Object)"couldn't send 403 response", (Throwable)e1);
            }
            return;
        }
        if (!subsequent) {
            clonedRequest.setRoutingDirective(SipApplicationRoutingDirective.CONTINUE, (SipServletRequest)this.originalRequest);
        }
        clonedRequest.getTransactionApplicationData().setProxyBranch(this);
        try {
            clonedRequest.send();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.proxy.putTransaction(clonedRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(MobicentsSipServletResponse response, int status) throws DispatcherException {
        String contact;
        block30: {
            if (this.canceled && status < 200) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ProxyBranch " + this + " with outgoing request " + this.outgoingRequest + " cancelled and still receiving provisional response, trying to cancel them"));
                }
                try {
                    SipServletRequest cancelRequest = this.outgoingRequest.createCancel();
                    cancelRequest.send();
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block30;
                    logger.debug((Object)("Failed to cancel again a provisional response " + response.toString()), (Throwable)e);
                }
            }
        }
        if (status == 100) {
            if (logger.isDebugEnabled() && this.proxyBranch1xxTimerStarted) {
                logger.debug((Object)"1xx received, cancelling 1xx timer ");
            }
            this.cancel1xxTimer();
            return;
        }
        if (status > 100 && status < 200 || status == 200 && ("PRACK".equals(response.getMethod()) || "UPDATE".equals(response.getMethod()))) {
            SipServletResponseImpl proxiedResponse;
            if (response.getHeader("RSeq") != null) {
                this.setWaitingForPrack(true);
            }
            if ((proxiedResponse = ProxyUtils.createProxiedResponse(response, this)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Response dropped because it was addressed to this machine.");
                }
                return;
            }
            try {
                String branch = ((Via)proxiedResponse.getMessage().getHeader("Via")).getBranch();
                List<TransactionRequest> list = this.ongoingTransactions;
                synchronized (list) {
                    for (TransactionRequest tr : this.ongoingTransactions) {
                        if (!tr.branchId.equals(branch)) continue;
                        proxiedResponse.setTransaction(tr.request.getTransaction());
                        proxiedResponse.setOriginalRequest(tr.request);
                        break;
                    }
                }
                proxiedResponse.send();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Proxy response sent out sucessfully");
                }
            }
            catch (Exception e) {
                logger.error((Object)"A problem occured while proxying a response", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SipSession state " + response.getSipSession().getState()));
            }
            if (status == 200 && ("PRACK".equals(response.getMethod()) || "UPDATE".equals(response.getMethod())) && SipSession.State.EARLY.equals((Object)response.getSipSession().getState())) {
                this.updateTimer(true);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"About to return from onResponse");
            }
            return;
        }
        this.cancelTimer();
        if (status >= 600) {
            this.proxy.cancelAllExcept((ProxyBranch)this, null, null, null, false);
        }
        boolean recursed = false;
        if (status >= 300 && status < 400 && this.recurse && (contact = response.getHeader("Contact")) != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Processing recursed response");
                }
                int start = contact.indexOf(60);
                int end = contact.indexOf(62);
                contact = contact.substring(start + 1, end);
                URI uri = this.proxy.getSipFactoryImpl().createURI(contact);
                ArrayList<SipURI> list = new ArrayList<SipURI>();
                list.add((SipURI)uri);
                List<ProxyBranch> pblist = this.proxy.createProxyBranches(list);
                ProxyBranchImpl pbi = (ProxyBranchImpl)pblist.get(0);
                this.addRecursedBranch(pbi);
                pbi.start();
                recursed = true;
            }
            catch (ServletParseException e) {
                throw new IllegalArgumentException("Can not parse contact header", e);
            }
        }
        if (status >= 200 && !recursed) {
            if (this.proxy.getFinalBranchForSubsequentRequests() == null || this.outgoingRequest != null && this.outgoingRequest.isInitial()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Handling final response for initial request");
                }
                this.proxy.onFinalResponse(this);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Handling final response for non-initial request");
                }
                this.proxy.sendFinalResponse(response, this);
            }
        }
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void addTransaction(SipServletRequestImpl request) {
        String branch;
        if (!request.getMethod().equalsIgnoreCase("ACK") && !request.getMethod().equalsIgnoreCase("PRACK") && this.ongoingTransactions.add(new TransactionRequest(branch = ((Via)request.getMessage().getHeader("Via")).getBranch(), request))) {
            request.getTransactionApplicationData().setProxyBranch(this);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added transaction " + branch + " to proxy branch."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(String branch) {
        List<TransactionRequest> list = this.ongoingTransactions;
        synchronized (list) {
            TransactionRequest remove = null;
            for (TransactionRequest tr : this.ongoingTransactions) {
                if (!tr.branchId.equals(branch)) continue;
                remove = tr;
                break;
            }
            if (remove != null) {
                boolean removed = this.ongoingTransactions.remove(remove);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed transaction " + branch + " from proxy branch ? " + removed));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing transaction " + branch + " from proxy branch FAILED. Not found."));
            }
        }
    }

    public void proxySubsequentRequest(MobicentsSipServletRequest sipServletRequest) {
        block14: {
            SipServletRequestImpl request = (SipServletRequestImpl)sipServletRequest;
            MobicentsSipServletResponse lastFinalResponse = (MobicentsSipServletResponse)request.getLastFinalResponse();
            if (lastFinalResponse != null && lastFinalResponse.isMessageSent()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not proxying request as final response has already been sent for " + request));
                }
                return;
            }
            this.addTransaction(request);
            if (request.getMethod().equalsIgnoreCase("INVITE")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Proxying reinvite request " + request));
                }
                this.proxyDialogStateless(request);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Proxying subsequent request " + request));
            }
            request.setRoutingState(RoutingState.PROXIED);
            this.proxy.setOriginalRequest(request);
            this.originalRequest = request;
            Request clonedRequest = ProxyUtils.createProxiedRequest(request, this, null, null, null, null);
            this.updateTimer(false);
            try {
                this.proxy.setSupervised(true);
                if (clonedRequest.getMethod().equalsIgnoreCase("ACK")) {
                    MobicentsSipSession sipSession = request.getSipSession();
                    MobicentsSipApplicationSession sipApplicationSession = sipSession.getSipApplicationSession();
                    sipSession.access();
                    if (sipApplicationSession != null) {
                        sipApplicationSession.access();
                    }
                    String transport = JainSipUtils.findTransport((Message)clonedRequest);
                    SipFactoryImpl sipFactoryImpl = this.proxy.getSipFactoryImpl();
                    SipNetworkInterfaceManager sipNetworkInterfaceManager = sipFactoryImpl.getSipNetworkInterfaceManager();
                    SipProvider sipProvider = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false).getSipProvider();
                    SipConnector sipConnector = StaticServiceHolder.sipStandardService.findSipConnector(transport);
                    if (sipConnector.isUseStaticAddress()) {
                        JainSipUtils.optimizeRouteHeaderAddressForInternalRoutingrequest(sipConnector, clonedRequest, sipSession, sipFactoryImpl, transport);
                        try {
                            JainSipUtils.optimizeViaHeaderAddressForStaticAddress(sipConnector, clonedRequest, sipFactoryImpl, transport);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    try {
                        RFC5626Helper.checkRequest(this, clonedRequest, this.originalRequest);
                    }
                    catch (IncorrectFlowIdentifierException e1) {
                        logger.warn((Object)e1.getMessage());
                        this.cancel();
                        return;
                    }
                    sipProvider.sendRequest(clonedRequest);
                    sipFactoryImpl.getSipApplicationDispatcher().updateRequestsStatistics(clonedRequest, false);
                    break block14;
                }
                this.forwardRequest(clonedRequest, true);
            }
            catch (SipException e) {
                logger.error((Object)"A problem occured while proxying a subsequent request", (Throwable)e);
            }
        }
    }

    public void proxyDialogStateless(SipServletRequestImpl request) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Proxying request dialog-statelessly " + request));
        }
        SipFactoryImpl sipFactoryImpl = this.proxy.getSipFactoryImpl();
        SipApplicationDispatcher sipApplicationDispatcher = sipFactoryImpl.getSipApplicationDispatcher();
        MobicentsSipSession sipSession = request.getSipSession();
        MobicentsSipApplicationSession sipAppSession = sipSession.getSipApplicationSession();
        request.setRoutingState(RoutingState.PROXIED);
        this.prackOriginalRequest = request;
        URI targetURI = null;
        if (request.getMethod().equals("PRACK") || request.getMethod().equals("ACK")) {
            targetURI = this.targetURI;
        }
        if (!((MessageExt)request.getMessage()).getFromHeader().getTag().toString().equals(this.proxy.getCallerFromTag())) {
            targetURI = this.proxy.getPreviousNode();
        }
        Request clonedRequest = ProxyUtils.createProxiedRequest(request, this, targetURI, null, this.recordRouteURI, null);
        ViaHeader viaHeader = (ViaHeader)clonedRequest.getHeader("Via");
        try {
            String branch = JainSipUtils.createBranch(sipSession.getKey().getApplicationSessionId(), sipApplicationDispatcher.getHashFromApplicationName(sipSession.getKey().getApplicationName()));
            viaHeader.setBranch(branch);
        }
        catch (ParseException pe) {
            logger.error((Object)"A problem occured while setting the via branch while proxying a request", (Throwable)pe);
        }
        String transport = JainSipUtils.findTransport((Message)clonedRequest);
        SipProvider sipProvider = sipFactoryImpl.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false).getSipProvider();
        try {
            RFC5626Helper.checkRequest(this, clonedRequest, request);
        }
        catch (IncorrectFlowIdentifierException e1) {
            logger.warn((Object)e1.getMessage());
            this.cancel();
            try {
                this.originalRequest.createResponse(403).send();
            }
            catch (IOException e) {
                logger.error((Object)"couldn't send 403 response", (Throwable)e1);
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting new Client Tx for request " + clonedRequest + "\n transport = " + transport));
        }
        sipSession.access();
        if (sipAppSession != null) {
            sipAppSession.access();
        }
        SipConnector sipConnector = StaticServiceHolder.sipStandardService.findSipConnector(transport);
        ClientTransaction ctx = null;
        try {
            if (sipConnector != null && sipConnector.isUseStaticAddress()) {
                javax.sip.address.URI uri = clonedRequest.getRequestURI();
                RouteHeader route = (RouteHeader)clonedRequest.getHeader("Route");
                if (route != null) {
                    uri = route.getAddress().getURI();
                }
                if (uri.isSipURI()) {
                    javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)uri;
                    String host = sipUri.getHost();
                    int port = sipUri.getPort();
                    if (sipFactoryImpl.getSipApplicationDispatcher().isExternal(host, port, transport)) {
                        viaHeader.setHost(sipConnector.getStaticServerAddress());
                        viaHeader.setPort(sipConnector.getStaticServerPort());
                    }
                }
                JainSipUtils.optimizeRouteHeaderAddressForInternalRoutingrequest(sipConnector, clonedRequest, sipSession, sipFactoryImpl, transport);
            }
            ctx = sipProvider.getNewClientTransaction(clonedRequest);
            JainSipUtils.setTransactionTimers((TransactionExt)ctx, sipApplicationDispatcher);
            TransactionApplicationData appData = request.getTransactionApplicationData();
            appData.setProxyBranch(this);
            ctx.setApplicationData((Object)appData);
            SipServletRequestImpl clonedSipServletRequest = (SipServletRequestImpl)this.proxy.getSipFactoryImpl().getMobicentsSipServletMessageFactory().createSipServletRequest(clonedRequest, sipSession, (Transaction)ctx, null, false);
            appData.setSipServletMessage(clonedSipServletRequest);
            clonedSipServletRequest.setRoutingState(RoutingState.SUBSEQUENT);
            this.outgoingRequest = clonedSipServletRequest;
            ctx.sendRequest();
            sipFactoryImpl.getSipApplicationDispatcher().updateRequestsStatistics(clonedRequest, false);
        }
        catch (Exception e) {
            logger.error((Object)("A problem occured while proxying a request " + request + " in a dialog-stateless transaction"), (Throwable)e);
            JainSipUtils.terminateTransaction((Transaction)ctx);
        }
    }

    public void onTimeout(ResponseType responseType) throws DispatcherException {
        if (!this.proxy.getAckReceived()) {
            this.cancel();
            if (responseType == ResponseType.FINAL) {
                this.cancel1xxTimer();
            }
            this.timedOut = true;
            List proxyBranchListeners = this.originalRequest.getSipSession().getSipApplicationSession().getSipContext().getListeners().getProxyBranchListeners();
            if (proxyBranchListeners != null) {
                for (ProxyBranchListener proxyBranchListener : proxyBranchListeners) {
                    proxyBranchListener.onProxyBranchResponseTimeout(responseType, (ProxyBranch)this);
                }
            }
            this.proxy.onBranchTimeOut(this);
            logger.warn((Object)"Proxy branch has timed out");
        } else {
            logger.debug((Object)"ACKed proxybranch has timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimer(boolean cancel1xxTimer) {
        if (cancel1xxTimer) {
            this.cancel1xxTimer();
        }
        this.cancelTimer();
        if (this.proxyBranchTimeout > 0) {
            Object object = this.cTimerLock;
            synchronized (object) {
                if (!this.proxyBranchTimerStarted) {
                    try {
                        ProxyBranchTimerTask timerCTask = new ProxyBranchTimerTask(this, ResponseType.FINAL);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Proxy Branch Timeout set to " + this.proxyBranchTimeout));
                        }
                        this.proxy.getProxyTimerService().schedule((TimerTask)timerCTask, (long)this.proxyBranchTimeout * 1000L);
                        this.proxyTimeoutTask = timerCTask;
                        this.proxyBranchTimerStarted = true;
                    }
                    catch (IllegalStateException e) {
                        logger.error((Object)"Unexpected exception while scheduling Timer C", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimer() {
        Object object = this.cTimerLock;
        synchronized (object) {
            if (this.proxyTimeoutTask != null && this.proxyBranchTimerStarted) {
                this.proxyTimeoutTask.cancel();
                this.proxyTimeoutTask = null;
                this.proxyBranchTimerStarted = false;
            }
        }
    }

    public void cancel1xxTimer() {
        if (this.proxy1xxTimeoutTask != null && this.proxyBranch1xxTimerStarted) {
            this.proxy1xxTimeoutTask.cancel();
            this.proxy1xxTimeoutTask = null;
            this.proxyBranch1xxTimerStarted = false;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean getAddToPath() {
        return this.isAddToPath;
    }

    public SipURI getPathURI() {
        if (!this.isAddToPath) {
            throw new IllegalStateException("addToPath is not enabled!");
        }
        return this.pathURI;
    }

    public boolean getRecordRoute() {
        return this.recordRoutingEnabled;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public void setAddToPath(boolean isAddToPath) {
        if (this.started) {
            throw new IllegalStateException("Cannot set a record route on an already started proxy");
        }
        if (this.pathURI == null) {
            this.pathURI = new SipURIImpl(JainSipUtils.createRecordRouteURI(this.proxy.getSipFactoryImpl().getSipNetworkInterfaceManager(), null), AddressImpl.ModifiableRule.NotModifiable);
        }
        this.isAddToPath = isAddToPath;
    }

    public boolean isAddToPath() {
        return this.isAddToPath;
    }

    public void setOutboundInterface(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new NullPointerException("outbound Interface param shouldn't be null");
        }
        this.checkSessionValidity();
        String address = inetAddress.getHostAddress();
        List list = this.proxy.getSipFactoryImpl().getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + this.outboundInterface + " not found");
        }
        this.outboundInterface = this.proxy.getSipFactoryImpl().createSipURI(null, address);
    }

    public void setOutboundInterface(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            throw new NullPointerException("outbound Interface param shouldn't be null");
        }
        this.checkSessionValidity();
        String address = inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        List list = this.proxy.getSipFactoryImpl().getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + this.outboundInterface + " not found");
        }
        this.outboundInterface = this.proxy.getSipFactoryImpl().createSipURI(null, address);
    }

    public void setOutboundInterface(SipURI outboundInterface) {
        this.checkSessionValidity();
        if (outboundInterface == null) {
            throw new NullPointerException("outbound Interface param shouldn't be null");
        }
        List list = this.proxy.getSipFactoryImpl().getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.equals((Object)outboundInterface)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + outboundInterface + " not found");
        }
        this.outboundInterface = networkInterface;
    }

    public void setRecordRoute(boolean isRecordRoute) {
        if (this.started) {
            throw new IllegalStateException("Proxy branch alredy started!");
        }
        this.recordRoutingEnabled = isRecordRoute;
    }

    public void setRecurse(boolean isRecurse) {
        this.recurse = isRecurse;
    }

    private void checkSessionValidity() {
        if (this.originalRequest.getSipSession().isValidInternal() && this.originalRequest.getSipSession().getSipApplicationSession().isValidInternal()) {
            return;
        }
        throw new IllegalStateException("Invalid session.");
    }

    public void setPrackOriginalRequest(SipServletRequestImpl prackOriginalRequest) {
        this.prackOriginalRequest = prackOriginalRequest;
    }

    public SipServletRequestImpl getPrackOriginalRequest() {
        return this.prackOriginalRequest;
    }

    public boolean isWaitingForPrack() {
        return this.waitingForPrack;
    }

    public void setWaitingForPrack(boolean waitingForPrack) {
        this.waitingForPrack = waitingForPrack;
    }

    public void setProxy(ProxyImpl proxy) {
        this.proxy = proxy;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cTimerLock = new Object();
        this.recurse = in.readBoolean();
        this.recordRoutingEnabled = in.readBoolean();
        this.started = in.readBoolean();
        this.timedOut = in.readBoolean();
        this.proxyBranchTimeout = in.readInt();
        this.proxyBranch1xxTimeout = in.readInt();
        this.canceled = in.readBoolean();
        this.isAddToPath = in.readBoolean();
        this.waitingForPrack = in.readBoolean();
        this.appSpecifiedRecordRoutingEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.recurse);
        out.writeBoolean(this.recordRoutingEnabled);
        out.writeBoolean(this.started);
        out.writeBoolean(this.timedOut);
        out.writeInt(this.proxyBranchTimeout);
        out.writeInt(this.proxyBranch1xxTimeout);
        out.writeBoolean(this.canceled);
        out.writeBoolean(this.isAddToPath);
        out.writeBoolean(this.waitingForPrack);
        out.writeBoolean(this.appSpecifiedRecordRoutingEnabled);
    }

    public int getProxyBranch1xxTimeout() {
        return this.proxyBranch1xxTimeout;
    }

    public void setProxyBranch1xxTimeout(int timeout) {
        this.proxyBranch1xxTimeout = timeout;
    }

    public void setOutgoingRequest(SipServletRequestImpl outgoingRequest) {
        this.outgoingRequest = outgoingRequest;
    }

    public void setOriginalRequest(SipServletRequestImpl originalRequest) {
        this.originalRequest = originalRequest;
    }

    public SipServletRequestImpl getOriginalRequest() {
        return this.originalRequest;
    }

    public void setTargetURI(URI targetURI) {
        this.targetURI = targetURI;
    }

    public URI getTargetURI() {
        return this.targetURI;
    }

    public void setRecordRouteURI(SipURI uri) {
        this.recordRouteURI = uri;
    }

    public boolean isAppSpecifiedRecordRoutingEnabled() {
        return this.appSpecifiedRecordRoutingEnabled;
    }

    public static class TransactionRequest {
        public String branchId;
        public SipServletRequestImpl request;

        public TransactionRequest(String branch, SipServletRequestImpl request) {
            this.branchId = branch;
            this.request = request;
        }
    }
}

