/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.SipFactoryExt;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.session.ConvergedSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.message.SipFactoryImpl;

public class SipFactoryFacade
implements SipFactoryExt,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)SipFactoryFacade.class.getName());
    private SipFactoryImpl sipFactoryImpl;
    private transient SipContext sipContext;
    private static transient ThreadLocal<HttpSession> threadLocalHttpSession = new ThreadLocal();

    public SipFactoryFacade(SipFactoryImpl sipFactoryImpl, SipContext sipContext) {
        this.sipFactoryImpl = sipFactoryImpl;
        this.sipContext = sipContext;
    }

    public Address createAddress(String sipAddress) throws ServletParseException {
        return this.sipFactoryImpl.createAddress(sipAddress);
    }

    public Address createAddress(URI uri) {
        return this.sipFactoryImpl.createAddress(uri);
    }

    public Address createAddress(URI uri, String displayName) {
        return this.sipFactoryImpl.createAddress(uri, displayName);
    }

    public SipApplicationSession createApplicationSession() {
        return this.createApplicationSession(true);
    }

    public SipApplicationSession createApplicationSession(boolean managed) {
        MobicentsSipApplicationSession sipApplicationSessionImpl = null;
        HttpSession httpSession = threadLocalHttpSession.get();
        if (httpSession != null) {
            ConvergedSession convergedSession = (ConvergedSession)httpSession;
            sipApplicationSessionImpl = convergedSession.getApplicationSession(false);
        }
        if (sipApplicationSessionImpl == null) {
            sipApplicationSessionImpl = (MobicentsSipApplicationSession)this.sipFactoryImpl.createApplicationSessionByAppName(this.sipContext.getApplicationName(), managed);
            this.associateHttpSession(sipApplicationSessionImpl);
        }
        return sipApplicationSessionImpl;
    }

    private void associateHttpSession(MobicentsSipApplicationSession sipApplicationSessionImpl) {
        HttpSession httpSession = threadLocalHttpSession.get();
        if (httpSession != null) {
            sipApplicationSessionImpl.addHttpSession(httpSession);
        }
    }

    public Parameterable createParameterable(String s) throws ServletParseException {
        return this.sipFactoryImpl.createParameterable(s);
    }

    public SipServletRequest createRequest(SipApplicationSession appSession, String method, Address from, Address to) {
        SipServletRequest sipServletRequest = this.sipFactoryImpl.createRequest(appSession, method, from, to, ((MobicentsSipApplicationSession)appSession).getCurrentRequestHandler(), null, null);
        return sipServletRequest;
    }

    public SipServletRequest createRequest(SipApplicationSession appSession, String method, String from, String to) throws ServletParseException {
        SipServletRequest sipServletRequest = this.sipFactoryImpl.createRequest(appSession, method, from, to, ((MobicentsSipApplicationSession)appSession).getCurrentRequestHandler());
        return sipServletRequest;
    }

    public SipServletRequest createRequest(SipApplicationSession appSession, String method, URI from, URI to) {
        SipServletRequest sipServletRequest = this.sipFactoryImpl.createRequest(appSession, method, from, to, ((MobicentsSipApplicationSession)appSession).getCurrentRequestHandler());
        return sipServletRequest;
    }

    public SipServletRequest createRequest(SipServletRequest origRequest, boolean sameCallId) {
        SipServletRequest sipServletRequest = this.sipFactoryImpl.createRequest(origRequest, sameCallId);
        this.checkHandler(sipServletRequest);
        return sipServletRequest;
    }

    private void checkHandler(SipServletRequest request) {
        MobicentsSipSession sipSessionImpl = (MobicentsSipSession)request.getSession();
        if (sipSessionImpl.getHandler() == null) {
            try {
                sipSessionImpl.setHandler(this.sipContext.getServletHandler());
            }
            catch (ServletException se) {
                logger.error((Object)("Impossible to set the default handler on the newly created request " + request.toString()), (Throwable)se);
            }
        }
    }

    public SipURI createSipURI(String user, String host) {
        return this.sipFactoryImpl.createSipURI(user, host);
    }

    public URI createURI(String uri) throws ServletParseException {
        return this.sipFactoryImpl.createURI(uri);
    }

    public void storeHttpSession(HttpSession httpSession) {
        threadLocalHttpSession.set(httpSession);
    }

    public void removeHttpSession() {
        threadLocalHttpSession.set(null);
        threadLocalHttpSession.remove();
    }

    public HttpSession retrieveHttpSession() {
        return threadLocalHttpSession.get();
    }

    public SipApplicationSession createApplicationSessionByKey(String sipApplicationKey) {
        return this.createApplicationSessionByKey(sipApplicationKey, true);
    }

    public SipApplicationSession createApplicationSessionByKey(String sipApplicationKey, boolean managed) {
        MobicentsSipApplicationSession sipApplicationSessionImpl = null;
        HttpSession httpSession = threadLocalHttpSession.get();
        if (httpSession != null) {
            ConvergedSession convergedSession = (ConvergedSession)httpSession;
            sipApplicationSessionImpl = convergedSession.getApplicationSession(false);
        }
        if (sipApplicationSessionImpl == null) {
            sipApplicationSessionImpl = (MobicentsSipApplicationSession)this.sipContext.getSipSessionsUtil().getApplicationSessionByKey(sipApplicationKey, true, managed);
            this.associateHttpSession(sipApplicationSessionImpl);
        }
        return sipApplicationSessionImpl;
    }

    public AuthInfo createAuthInfo() {
        return this.sipFactoryImpl.createAuthInfo();
    }

    public SipApplicationSession createApplicationSessionByAppName(String arg0) {
        return null;
    }

    public boolean isRouteOrphanRequests() {
        return this.sipFactoryImpl.isRouteOrphanRequests();
    }

    public void setRouteOrphanRequests(boolean routeOrphanRequets) {
        this.sipFactoryImpl.setRouteOrphanRequests(routeOrphanRequets);
    }
}

