/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.dns;

import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.sip.URI;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import org.mobicents.ext.javax.sip.dns.DNSServerLocator;
import org.mobicents.javax.servlet.sip.dns.DNSResolver;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.URIImpl;

public class MobicentsDNSResolver
implements DNSResolver {
    private DNSServerLocator dnsServerLocator;

    public MobicentsDNSResolver(DNSServerLocator dnsServerLocator) {
        this.dnsServerLocator = dnsServerLocator;
    }

    public javax.servlet.sip.SipURI getSipURI(URI uri) {
        SipURI jainSipURI = this.dnsServerLocator.getSipURI(((URIImpl)uri).getURI());
        SipURIImpl sipURI = new SipURIImpl(jainSipURI, AddressImpl.ModifiableRule.NotModifiable);
        return sipURI;
    }

    public void setDnsTimeout(int timeout) {
        this.dnsServerLocator.getDnsLookupPerformer().setDNSTimeout(timeout);
    }

    public int getDnsTimeout() {
        return this.dnsServerLocator.getDnsLookupPerformer().getDNSTimeout();
    }

    public Set<String> resolveHost(String host) {
        CopyOnWriteArraySet<String> ipAddresses = new CopyOnWriteArraySet<String>();
        Queue hops = this.dnsServerLocator.resolveHostByAandAAAALookup(host, -1, null);
        if (hops != null) {
            for (Hop hop : hops) {
                ipAddresses.add(hop.getHost());
            }
        }
        return ipAddresses;
    }
}

