/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import javax.servlet.sip.SipSession;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.SipSessionAsynchronousWork;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionKey;

public class SipSessionAsyncTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(SipSessionAsyncTask.class);
    private SipSessionKey key;
    private SipSessionAsynchronousWork work;
    private MobicentsSipFactory sipFactoryImpl;

    public SipSessionAsyncTask(SipSessionKey key, SipSessionAsynchronousWork work, MobicentsSipFactory sipFactory) {
        this.key = key;
        this.work = work;
        this.sipFactoryImpl = sipFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SipContext sipContext = this.sipFactoryImpl.getSipApplicationDispatcher().findSipApplication(this.key.getApplicationName());
        if (sipContext != null) {
            SipApplicationSessionKey sipApplicationSessionKey;
            MobicentsSipApplicationSession sipApplicationSession;
            SipManager sipManager = sipContext.getSipManager();
            MobicentsSipSession sipSession = sipManager.getSipSession((MobicentsSipSessionKey)this.key, false, this.sipFactoryImpl, sipApplicationSession = sipManager.getSipApplicationSession((MobicentsSipApplicationSessionKey)(sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(this.key.getApplicationName(), this.key.getApplicationSessionId(), null)), false));
            if (sipSession != null) {
                boolean batchStarted = false;
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    sipContext.enterSipContext();
                    sipContext.enterSipApp(sipApplicationSession, sipSession, false, true);
                    batchStarted = sipContext.enterSipAppHa(true);
                    this.work.doAsynchronousWork((SipSession)sipSession);
                }
                catch (Throwable t) {
                    logger.error((Object)("An unexpected exception happened in the SipSessionAsynchronousWork callback on sip session " + this.key), t);
                }
                finally {
                    sipContext.exitSipAppHa(null, null, batchStarted);
                    sipContext.exitSipApp(sipApplicationSession, sipSession);
                    sipContext.exitSipContext(oldClassLoader);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("SipSession " + this.key + " couldn't be found, it may have been already invalidated."));
            }
        }
    }
}

