/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import javax.sip.SipProvider;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.DispatcherException;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;

public abstract class DispatchTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(DispatchTask.class);
    protected SipServletMessageImpl sipServletMessage;
    protected SipProvider sipProvider;

    public DispatchTask(SipServletMessageImpl sipServletMessage, SipProvider sipProvider) {
        this.sipProvider = sipProvider;
        this.sipServletMessage = sipServletMessage;
    }

    public abstract void dispatch() throws DispatcherException;

    @Override
    public void run() {
        this.dispatchAndHandleExceptions();
    }

    public void dispatchAndHandleExceptions() {
        block2: {
            try {
                this.dispatch();
            }
            catch (Throwable t) {
                SipServletRequestImpl sipServletRequest;
                logger.error((Object)("Unexpected exception while processing message " + this.sipServletMessage), t);
                if (!(this.sipServletMessage instanceof SipServletRequestImpl) || "ACK".equalsIgnoreCase((sipServletRequest = (SipServletRequestImpl)this.sipServletMessage).getMethod()) || "PRACK".equalsIgnoreCase(sipServletRequest.getMethod())) break block2;
                MessageDispatcher.sendErrorResponse(sipServletRequest.getSipSession().getSipApplicationSession().getSipContext().getSipApplicationDispatcher(), 500, sipServletRequest, this.sipProvider);
            }
        }
    }
}

