/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.ilbc;

import org.mobicents.media.server.impl.dsp.audio.ilbc.BasicFunctions;
import org.mobicents.media.server.impl.dsp.audio.ilbc.CbSearchData;
import org.mobicents.media.server.impl.dsp.audio.ilbc.CbUpdateIndexData;
import org.mobicents.media.server.impl.dsp.audio.ilbc.Constants;
import org.mobicents.media.server.impl.dsp.audio.ilbc.CorrData;
import org.mobicents.media.server.impl.dsp.audio.ilbc.DecoderState;
import org.mobicents.media.server.impl.dsp.audio.ilbc.EncoderBits;
import org.mobicents.media.server.impl.dsp.audio.ilbc.EncoderState;

public class CodingFunctions {
    private static final short[] emptyArray = new short[150];
    private static final short bestIndexMin = -21299;
    private static final short bestIndexMax = 21299;
    private static final int bestIndexMinI = -21299;
    private static final int bestIndexMaxI = 21299;

    public static void hpInput(EncoderState encoderState, short[] data, int startIndex, int length) {
        short[] ba = Constants.HP_IN_COEFICIENTS;
        short[] y = encoderState.getHpiMemY();
        short[] x = encoderState.getHpiMemX();
        int currIndex = startIndex + length;
        for (int i = startIndex; i < currIndex; ++i) {
            int current = y[1] * ba[3];
            current += y[3] * ba[4];
            current >>= 15;
            current += y[0] * ba[3];
            current += y[2] * ba[4];
            current <<= 1;
            current += data[i] * ba[0];
            current += x[0] * ba[1];
            x[1] = x[0];
            x[0] = data[i];
            data[i] = (current += x[1] * ba[2]) > 0xFFFEFFF ? Short.MAX_VALUE : (current < -268439552 ? Short.MIN_VALUE : (short)(current + 4096 >> 13));
            y[2] = y[0];
            y[3] = y[1];
            current = current > 0xFFFFFFF ? Integer.MAX_VALUE : (current < -268435456 ? Integer.MIN_VALUE : (current <<= 3));
            y[0] = (short)(current >> 16);
            y[1] = (short)(current - (y[0] << 16) >> 1);
        }
    }

    public static void hpOutput(short[] signal, short[] ba, short[] y, short[] x, short len) {
        for (int i = 0; i < len; ++i) {
            int temp = y[1] * ba[3];
            temp += y[3] * ba[4];
            temp >>= 15;
            temp += y[0] * ba[3];
            temp += y[2] * ba[4];
            temp <<= 1;
            temp += signal[i] * ba[0];
            temp += x[0] * ba[1];
            x[1] = x[0];
            x[0] = signal[i];
            int temp2 = (temp += x[1] * ba[2]) + 1024;
            if (temp2 > 0x3FFFFFF) {
                temp2 = 0x3FFFFFF;
            } else if (temp2 < -67108864) {
                temp2 = -67108864;
            }
            signal[i] = (short)(temp2 >> 11);
            y[2] = y[0];
            y[3] = y[1];
            temp = temp > 0xFFFFFFF ? Integer.MAX_VALUE : (temp < -268435456 ? Integer.MIN_VALUE : (temp <<= 3));
            y[0] = (short)(temp >> 16);
            int tempShift = y[0] << 16;
            y[1] = (short)(temp - tempShift >> 1);
        }
    }

    public static void lpcEncode(EncoderState encoderState, EncoderBits encoderBits, short[] synthDenum, int synthDenumIndex, short[] weightDenum, int weightDenumIndex, short[] data, int startIndex) {
        short[] lsf = new short[20];
        short[] lsfDeq = new short[20];
        CodingFunctions.simpleLpcAnalysis(encoderState, lsf, 0, data, startIndex);
        CodingFunctions.simpleLsfQ(encoderBits, lsfDeq, 0, lsf, 0);
        CodingFunctions.lsfCheck(lsfDeq, 0, 10);
        CodingFunctions.simpleInterpolateLsf(encoderState, synthDenum, synthDenumIndex, weightDenum, weightDenumIndex, lsf, 0, lsfDeq, 0, 10);
    }

    public static short[] simpleLpcAnalysis(EncoderState encoderState, short[] lsf, int lsfIndex, short[] data, int startIndex) {
        short[] A = new short[11];
        short[] windowedData = new short[240];
        short[] rc = new short[10];
        int[] R = new int[11];
        short[] lpcBuffer = encoderState.getLpcBuffer();
        System.arraycopy(data, startIndex, lpcBuffer, 300 - 160, 160);
        int j = 0;
        BasicFunctions.multWithRightShift(windowedData, 0, lpcBuffer, 60, Constants.LPC_ASYM_WIN, 0, 240, 15);
        CodingFunctions.autoCorrelation(windowedData, 0, 240, 10, R, 0);
        CodingFunctions.windowMultiply(R, 0, R, 0, Constants.LPC_LAG_WIN, 11);
        if (!CodingFunctions.levinsonDurbin(R, 0, A, 0, rc, 0, 10)) {
            A[0] = 4096;
            for (j = 1; j < 11; ++j) {
                A[j] = 0;
            }
        }
        BasicFunctions.expand(A, 0, A, 0, Constants.LPC_CHIRP_SYNT_DENUM, 11);
        CodingFunctions.poly2Lsf(lsf, lsfIndex, A, 0);
        System.arraycopy(lpcBuffer, 160, lpcBuffer, 0, 300 - 160);
        return A;
    }

    public static void autoCorrelation(short[] input, int inputIndex, int inputLength, int order, int[] result, int resultIndex) {
        short scale;
        short tempS;
        int i;
        short max = 0;
        if (order < 0) {
            order = inputLength;
        }
        for (i = 0; i < inputLength; ++i) {
            if ((tempS = BasicFunctions.abs(input[inputIndex++])) <= max) continue;
            max = tempS;
        }
        inputIndex -= inputLength;
        if (max == 0) {
            scale = 0;
        } else {
            short nBits = BasicFunctions.getSize(inputLength);
            tempS = BasicFunctions.norm(max * max);
            scale = tempS > nBits ? (short)0 : (short)(nBits - tempS);
        }
        for (i = 0; i < order + 1; ++i) {
            result[resultIndex] = 0;
            int currIndex1 = inputIndex;
            int currIndex2 = inputIndex + i;
            for (int j = inputLength - i; j > 0; --j) {
                int n = resultIndex;
                result[n] = result[n] + (input[currIndex1++] * input[currIndex2++] >> scale);
            }
            ++resultIndex;
        }
    }

    public static void windowMultiply(int[] output, int outputIndex, int[] input, int inputIndex, int[] window, int length) {
        short nBits = BasicFunctions.norm(input[inputIndex]);
        BasicFunctions.bitShiftLeft(input, inputIndex, input, inputIndex, length, nBits);
        for (int i = 0; i < length; ++i) {
            short xHi = (short)(input[inputIndex] >> 16);
            short yHi = (short)(window[i] >> 16);
            short xLow = (short)(input[inputIndex++] - (xHi << 16) >> 1);
            short yLow = (short)(window[i] - (yHi << 16) >> 1);
            output[outputIndex] = xHi * yHi << 1;
            int n = outputIndex;
            output[n] = output[n] + (xHi * yLow >> 14);
            int n2 = outputIndex++;
            output[n2] = output[n2] + (xLow * yHi >> 14);
        }
        BasicFunctions.bitShiftRight(output, outputIndex -= length, output, outputIndex, length, nBits);
    }

    public static boolean levinsonDurbin(int[] R, int rIndex, short[] A, int aIndex, short[] K, int kIndex, int order) {
        int temp;
        int i;
        short[] rHi = new short[21];
        short[] rLow = new short[21];
        short[] aHi = new short[21];
        short[] aLow = new short[21];
        short[] aUpdHi = new short[21];
        short[] aUpdLow = new short[21];
        short nBits = BasicFunctions.norm(R[rIndex]);
        int currIndex = rIndex + order;
        for (i = order; i >= 0; --i) {
            temp = R[currIndex--] << nBits;
            rHi[i] = (short)(temp >> 16);
            rLow[i] = (short)(temp - (rHi[i] << 16) >> 1);
        }
        int temp2 = rHi[1] << 16;
        int temp3 = rLow[1] << 1;
        temp3 = (temp2 += temp3) > 0 ? temp2 : -temp2;
        temp = BasicFunctions.div(temp3, rHi[0], rLow[0]);
        if (temp2 > 0) {
            temp = -temp;
        }
        short xHi = (short)(temp >> 16);
        short xLow = (short)(temp - (xHi << 16) >> 1);
        K[kIndex++] = xHi;
        aHi[1] = (short)((temp >>= 4) >> 16);
        aLow[1] = (short)(temp - (aHi[1] << 16) >> 1);
        temp = xHi * xLow >> 14;
        temp += xHi * xHi;
        if ((temp <<= 1) < 0) {
            temp = 0 - temp;
        }
        temp = Integer.MAX_VALUE - temp;
        short tempS = (short)(temp >> 16);
        short tempS2 = (short)(temp - (tempS << 16) >> 1);
        temp = rHi[0] * tempS;
        temp += rHi[0] * tempS2 >> 15;
        temp += rLow[0] * tempS >> 15;
        short alphaExp = BasicFunctions.norm(temp <<= 1);
        short yHi = (short)((temp <<= alphaExp) >> 16);
        short yLow = (short)(temp - (yHi << 16) >> 1);
        for (i = 2; i <= order; ++i) {
            int j;
            temp = 0;
            currIndex = i - 1;
            for (j = 1; j < i; ++j) {
                temp2 = rHi[j] * aLow[currIndex] >> 15;
                temp += (temp2 += rLow[j] * aHi[currIndex] >> 15) << 1;
                temp += rHi[j] * aHi[currIndex] << 1;
                --currIndex;
            }
            temp <<= 4;
            temp += rHi[i] << 16;
            temp2 = Math.abs(temp += rLow[i] << 1);
            temp3 = BasicFunctions.div(temp2, yHi, yLow);
            if (temp > 0) {
                temp3 = -temp3;
            }
            temp3 = alphaExp <= (nBits = BasicFunctions.norm(temp3)) || temp3 == 0 ? (temp3 <<= alphaExp) : (temp3 > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
            xHi = (short)(temp3 >> 16);
            xLow = (short)(temp3 - (xHi << 16) >> 1);
            K[kIndex++] = xHi;
            if (BasicFunctions.abs(xHi) > 32750) {
                return false;
            }
            currIndex = i - 1;
            currIndex = i - 1;
            for (j = 1; j < i; ++j) {
                temp = aHi[j] << 16;
                temp += aLow[j] << 1;
                temp2 = xLow * aHi[currIndex] >> 15;
                temp2 += xHi * aLow[currIndex] >> 15;
                aUpdHi[j] = (short)((temp += (temp2 += xHi * aHi[currIndex]) << 1) >> 16);
                aUpdLow[j] = (short)(temp - (aUpdHi[j] << 16) >> 1);
                --currIndex;
            }
            aUpdHi[i] = (short)((temp3 >>= 4) >> 16);
            aUpdLow[i] = (short)(temp3 - (aUpdHi[i] << 16) >> 1);
            temp = (xHi * xLow >> 14) + xHi * xHi << 1;
            if (temp < 0) {
                temp = 0 - temp;
            }
            temp = Integer.MAX_VALUE - temp;
            tempS = (short)(temp >> 16);
            tempS2 = (short)(temp - (tempS << 16) >> 1);
            temp2 = yHi * tempS2 >> 15;
            temp2 += yLow * tempS >> 15;
            temp = (temp2 += yHi * tempS) << 1;
            nBits = BasicFunctions.norm(temp);
            yHi = (short)((temp <<= nBits) >> 16);
            yLow = (short)(temp - (yHi << 16) >> 1);
            alphaExp = (short)(alphaExp + nBits);
            for (j = 1; j <= i; ++j) {
                aHi[j] = aUpdHi[j];
                aLow[j] = aUpdLow[j];
            }
        }
        A[aIndex++] = 4096;
        for (i = 1; i <= order; ++i) {
            temp = aHi[i] << 16;
            temp += aLow[i] << 1;
            temp <<= 1;
            A[aIndex++] = (short)((temp += 32768) >> 16);
        }
        return true;
    }

    public static void simpleInterpolateLsf(EncoderState encoderState, short[] synthdenum, int synthDenumIndex, short[] weightDenum, int weightDenumIndex, short[] lsf, int lsfIndex, short[] lsfDeq, int lsfDeqIndex, int length) {
        short[] lsfOld = encoderState.getLsfOld();
        short[] lsfDeqOld = encoderState.getLsfDeqOld();
        short[] lp = new short[11];
        int step = length + 1;
        int index = 0;
        int i = 0;
        while (true) {
            if (i >= 4) break;
            CodingFunctions.lsfInterpolate2PolyEnc(lp, (short)0, lsfDeqOld, 0, lsfDeq, lsfDeqIndex, Constants.LSF_WEIGHT_20MS[i], length);
            System.arraycopy(lp, 0, synthdenum, synthDenumIndex + index, step);
            CodingFunctions.lsfInterpolate2PolyEnc(lp, (short)0, lsfOld, 0, lsf, lsfIndex, Constants.LSF_WEIGHT_20MS[i], length);
            BasicFunctions.expand(weightDenum, weightDenumIndex + index, lp, 0, Constants.LPC_CHIRP_WEIGHT_DENUM, step);
            index += step;
            ++i;
        }
        System.arraycopy(lsf, lsfIndex, lsfOld, 0, length);
        System.arraycopy(lsfDeq, lsfDeqIndex, lsfDeqOld, 0, length);
    }

    public static void lsfInterpolate2PolyEnc(short[] a, short aIndex, short[] lsf1, int lsf1Index, short[] lsf2, int lsf2Index, short coef, int length) {
        short[] lsfTemp = new short[10];
        CodingFunctions.interpolate(lsfTemp, 0, lsf1, lsf1Index, lsf2, lsf2Index, coef, length);
        CodingFunctions.lsf2Poly(a, aIndex, lsfTemp, 0);
    }

    public static void interpolate(short[] out, int outIndex, short[] in1, int in1Index, short[] in2, int in2Index, short coef, int length) {
        short tempS = (short)(16384 - coef);
        for (int k = 0; k < length; ++k) {
            out[outIndex++] = (short)(coef * in1[in1Index++] + tempS * in2[in2Index++] + 8192 >> 14);
        }
    }

    public static void lsf2Poly(short[] a, int aIndex, short[] lsf, int lsfIndex) {
        int k;
        int[] f1 = new int[6];
        int[] f2 = new int[6];
        short[] lsp = new short[10];
        CodingFunctions.lsf2Lsp(lsf, lsfIndex, lsp, 0, 10);
        CodingFunctions.getLspPoly(lsp, 0, f1, 0);
        CodingFunctions.getLspPoly(lsp, 1, f2, 0);
        for (k = 5; k > 0; --k) {
            int n = k;
            f1[n] = f1[n] + f1[k - 1];
            int n2 = k;
            f2[n2] = f2[n2] - f2[k - 1];
        }
        a[aIndex] = 4096;
        int aStartIndex = aIndex + 1;
        int aEndIndex = aIndex + 10;
        int currIndex = 1;
        for (k = 5; k > 0; --k) {
            a[aStartIndex++] = (short)(f1[currIndex] + f2[currIndex] + 4096 >> 13);
            a[aEndIndex--] = (short)(f1[currIndex] - f2[currIndex] + 4096 >> 13);
            ++currIndex;
        }
    }

    public static void lsf2Lsp(short[] lsf, int lsfIndex, short[] lsp, int lspIndex, int count) {
        for (int j = 0; j < count; ++j) {
            short tempS = (short)(lsf[lsfIndex++] * 20861 >> 15);
            int tempS2 = tempS >> 8;
            tempS = (short)(tempS & 0xFF);
            if (tempS2 > 63 || tempS2 < 0) {
                tempS2 = 63;
            }
            lsp[lspIndex++] = (short)((Constants.COS_DERIVATIVE[tempS2] * tempS >> 12) + Constants.COS[tempS2]);
        }
    }

    public static void getLspPoly(short[] lsp, int lspIndex, int[] f, int fIndex) {
        f[fIndex++] = 0x1000000;
        f[fIndex++] = lsp[lspIndex] * -1024;
        lspIndex += 2;
        for (int k = 2; k <= 5; ++k) {
            f[fIndex] = f[fIndex - 2];
            for (int j = k; j > 1; --j) {
                short xHi = (short)(f[fIndex - 1] >> 16);
                short xLow = (short)(f[fIndex - 1] - (xHi << 16) >> 1);
                int n = fIndex;
                f[n] = f[n] + f[fIndex - 2];
                int n2 = fIndex--;
                f[n2] = f[n2] - ((xHi * lsp[lspIndex] << 2) + (xLow * lsp[lspIndex] >> 15 << 2));
            }
            int n = fIndex;
            f[n] = f[n] - (lsp[lspIndex] << 10);
            fIndex += k;
            lspIndex += 2;
        }
    }

    public static void poly2Lsf(short[] lsf, int lsfIndex, short[] A, int aIndex) {
        short[] lsp = new short[10];
        CodingFunctions.poly2Lsp(A, aIndex, lsp, 0);
        CodingFunctions.lspToLsf(lsp, 0, lsf, lsfIndex, 10);
    }

    public static void poly2Lsp(short[] A, int aIndex, short[] lsp, int lspIndex) {
        int i;
        short[] f1 = new short[6];
        short[] f2 = new short[6];
        int aLowIndex = aIndex + 1;
        int aHighIndex = aIndex + 10;
        f1[0] = 1024;
        f2[0] = 1024;
        for (i = 0; i < 5; ++i) {
            f1[i + 1] = (short)((A[aLowIndex] + A[aHighIndex] >> 2) - f1[i]);
            f2[i + 1] = (short)((A[aLowIndex] - A[aHighIndex] >> 2) + f2[i]);
            ++aLowIndex;
            --aHighIndex;
        }
        short[] current = f1;
        int currIndex = lspIndex;
        int foundFreqs = 0;
        short xLow = Constants.COS_GRID[0];
        short yLow = CodingFunctions.chebushev(xLow, current, 0);
        for (int j = 1; j < Constants.COS_GRID.length && foundFreqs < 10; ++j) {
            short xHi = xLow;
            short yHi = yLow;
            xLow = Constants.COS_GRID[j];
            yLow = CodingFunctions.chebushev(xLow, current, 0);
            if (yLow * yHi > 0) continue;
            for (i = 0; i < 4; ++i) {
                short xMid = (short)((xLow >> 1) + (xHi >> 1));
                short yMid = CodingFunctions.chebushev(xMid, current, 0);
                if (yLow * yMid <= 0) {
                    yHi = yMid;
                    xHi = xMid;
                    continue;
                }
                yLow = yMid;
                xLow = xMid;
            }
            short x = (short)(xHi - xLow);
            int y = yHi - yLow;
            if (y == 0) {
                lsp[currIndex++] = xLow;
            } else {
                int temp = y;
                y = BasicFunctions.abs((short)y);
                short nBits = (short)(BasicFunctions.norm(y) - 16);
                y = (y = (short)(y << nBits)) != 0 ? (int)((short)(536838144 / y)) : -1;
                y = (short)(x * y >> 19 - nBits & 0xFFFF);
                if (temp < 0) {
                    y = (short)(-y);
                }
                lsp[currIndex++] = (short)(xLow - (yLow * y >> 10 & 0xFFFF));
            }
            if (++foundFreqs >= 10) continue;
            xLow = lsp[currIndex - 1];
            current = foundFreqs % 2 == 0 ? f1 : f2;
            yLow = CodingFunctions.chebushev(xLow, current, 0);
        }
        if (foundFreqs < 10) {
            System.arraycopy(Constants.LSP_MEAN, 0, lsp, lspIndex, 10);
        }
    }

    public static short chebushev(short value, short[] coefs, int coefsIndex) {
        short b1Low;
        short b1Hi;
        int b2 = 0x1000000;
        int temp = value << 10;
        int n = ++coefsIndex;
        ++coefsIndex;
        temp += coefs[n] << 14;
        for (int n2 = 2; n2 < 5; ++n2) {
            int temp2 = temp;
            b1Hi = (short)(temp >> 16);
            b1Low = (short)(temp - (b1Hi << 16) >> 1);
            temp = (b1Low * value >> 15) + b1Hi * value << 2;
            temp -= b2;
            temp += coefs[coefsIndex++] << 14;
            b2 = temp2;
        }
        b1Hi = (short)(temp >> 16);
        b1Low = (short)(temp - (b1Hi << 16) >> 1);
        temp = (b1Low * value >> 15 << 1) + (b1Hi * value << 1);
        temp -= b2;
        if ((temp += coefs[coefsIndex] << 13) > 33553408) {
            return Short.MAX_VALUE;
        }
        if (temp < -33554432) {
            return Short.MIN_VALUE;
        }
        return (short)(temp >> 10);
    }

    public static void lspToLsf(short[] lsp, int lspIndex, short[] lsf, int lsfIndex, int coefsNumber) {
        int j = 63;
        int currLspIndex = lspIndex + coefsNumber - 1;
        int currLsfIndex = lsfIndex + coefsNumber - 1;
        for (int i = coefsNumber - 1; i >= 0; --i) {
            while (Constants.COS[j] < lsp[currLspIndex] && j > 0) {
                --j;
            }
            int currValue = (j << 9) + (Constants.ACOS_DERIVATIVE[j] * (lsp[currLspIndex--] - Constants.COS[j]) >> 11);
            lsf[currLsfIndex--] = (short)(currValue * 25736 >> 15);
        }
    }

    public static void simpleLsfQ(EncoderBits encoderBits, short[] lsfdeq, int lsfdeqIndex, short[] lsfArray, int lsfArrrayIndex) {
        CodingFunctions.splitVq(lsfdeq, lsfdeqIndex, encoderBits.getLSF(), 0, lsfArray, lsfArrrayIndex);
    }

    public static void splitVq(short[] qX, int qXIndex, short[] lsf, int lsfIndex, short[] X, int xIndex) {
        CodingFunctions.vq3(qX, qXIndex, lsf, lsfIndex, Constants.LSF_INDEX_CB[0], X, xIndex, Constants.LSF_SIZE_CB[0]);
        CodingFunctions.vq3(qX, qXIndex + Constants.LSF_DIM_CB[0], lsf, lsfIndex + 1, Constants.LSF_INDEX_CB[1], X, xIndex + Constants.LSF_DIM_CB[0], Constants.LSF_SIZE_CB[1]);
        CodingFunctions.vq4(qX, qXIndex + Constants.LSF_DIM_CB[0] + Constants.LSF_DIM_CB[1], lsf, lsfIndex + 2, Constants.LSF_INDEX_CB[2], X, xIndex + Constants.LSF_DIM_CB[0] + Constants.LSF_DIM_CB[1], Constants.LSF_SIZE_CB[2]);
    }

    public static void vq3(short[] qX, int qXIndex, short[] lsf, int lsfIndex, int cbIndex, short[] X, int xIndex, int cbSize) {
        int minValue = Integer.MAX_VALUE;
        int currIndex = 0;
        for (int j = 0; j < cbSize; ++j) {
            short tempS = (short)(X[xIndex++] - Constants.LSF_CB[cbIndex++]);
            int temp = tempS * tempS;
            tempS = (short)(X[xIndex++] - Constants.LSF_CB[cbIndex++]);
            temp += tempS * tempS;
            tempS = (short)(X[xIndex++] - Constants.LSF_CB[cbIndex++]);
            xIndex -= 3;
            if ((temp += tempS * tempS) >= minValue) continue;
            minValue = temp;
            currIndex = j;
        }
        lsf[lsfIndex] = (short)currIndex;
        currIndex *= 3;
        currIndex += (cbIndex -= 3 * cbSize);
        for (int i = 0; i < 3; ++i) {
            qX[qXIndex++] = Constants.LSF_CB[currIndex++];
        }
    }

    public static void vq4(short[] qX, int qXIndex, short[] lsf, int lsfIndex, int cbIndex, short[] X, int xIndex, int cbSize) {
        int i;
        int minValue = Integer.MAX_VALUE;
        int currIndex = 0;
        for (int j = 0; j < cbSize; ++j) {
            short tempS = (short)(X[xIndex++] - Constants.LSF_CB[cbIndex++]);
            int temp = tempS * tempS;
            for (i = 1; i < 4; ++i) {
                tempS = (short)(X[xIndex++] - Constants.LSF_CB[cbIndex++]);
                temp += tempS * tempS;
            }
            xIndex -= 4;
            if (temp >= minValue) continue;
            minValue = temp;
            currIndex = j;
        }
        lsf[lsfIndex] = (short)currIndex;
        currIndex *= 4;
        currIndex += (cbIndex -= 4 * cbSize);
        for (i = 0; i < 4; ++i) {
            qX[qXIndex++] = Constants.LSF_CB[currIndex++];
        }
    }

    public static void lsfCheck(short[] lsf, int lsfIndex, int lsfSize) {
        for (int n = 0; n < 2; ++n) {
            for (int k = 0; k < lsfSize - 1; ++k) {
                int currIndex1 = lsfIndex + k;
                int currIndex2 = currIndex1 + 1;
                if (lsf[currIndex2] - lsf[currIndex1] < 319) {
                    if (lsf[currIndex2] < lsf[currIndex1]) {
                        lsf[currIndex2] = (short)(lsf[currIndex1] + 160);
                        lsf[currIndex1] = (short)(lsf[currIndex2] - 160);
                    } else {
                        int n2 = currIndex1;
                        lsf[n2] = (short)(lsf[n2] - 160);
                        int n3 = currIndex2;
                        lsf[n3] = (short)(lsf[n3] + 160);
                    }
                }
                if (lsf[currIndex1] < 82) {
                    lsf[currIndex1] = 82;
                }
                if (lsf[currIndex1] <= 25723) continue;
                lsf[currIndex1] = 25723;
            }
        }
    }

    public static short gainDequant(short index, short maxIn, short stage) {
        if (maxIn < 0) {
            maxIn = (short)(0 - maxIn);
        }
        if (maxIn < 1638) {
            maxIn = (short)1638;
        }
        return (short)(maxIn * Constants.GAIN[stage][index] + 8192 >> 14);
    }

    public static short gainQuant(short gain, short maxIn, short stage, short[] index, int indexIndex) {
        int scale = maxIn > 1638 ? maxIn : 1638;
        short[] cb = Constants.GAIN[stage];
        int temp = gain << 14;
        int cbIndex = 32 >> stage >> 1;
        int nBits = cbIndex;
        for (int n = 4 - stage; n > 0; --n) {
            nBits >>= 1;
            if (temp > scale * cb[cbIndex]) {
                cbIndex += nBits;
                continue;
            }
            cbIndex -= nBits;
        }
        int temp2 = scale * cb[cbIndex];
        if (temp > temp2) {
            if (scale * cb[cbIndex + 1] - temp < temp - temp2) {
                ++cbIndex;
            }
        } else if (temp - scale * cb[cbIndex - 1] <= temp2 - temp) {
            --cbIndex;
        }
        if (cbIndex > (temp = (32 >> stage) - 1)) {
            cbIndex = temp;
        }
        index[indexIndex] = (short)cbIndex;
        return (short)(scale * cb[cbIndex] + 8192 >> 14);
    }

    public static void cbMemEnergyAugmentation(short[] interpSamples, int interpSamplesIndex, short[] cbMem, int cbMemIndex, short scale, short baseSize, short[] energy, int energyIndex, short[] energyShifts, int energyShiftsIndex) {
        energyIndex = energyIndex + baseSize - 20;
        energyShiftsIndex = energyShiftsIndex + baseSize - 20;
        int en1 = BasicFunctions.scaleRight(cbMem, (cbMemIndex += 147) - 19, cbMem, cbMemIndex - 19, 15, scale);
        int currIndex = cbMemIndex - 20;
        for (int n = 20; n <= 39; ++n) {
            int currValue = en1 += cbMem[--currIndex] * cbMem[currIndex] >> scale;
            currValue += BasicFunctions.scaleRight(interpSamples, interpSamplesIndex, interpSamples, interpSamplesIndex, 4, scale);
            interpSamplesIndex += 4;
            energyShifts[energyShiftsIndex] = BasicFunctions.norm(currValue += BasicFunctions.scaleRight(cbMem, cbMemIndex - n, cbMem, cbMemIndex - n, 40 - n, scale));
            energy[energyIndex++] = (short)((currValue <<= energyShifts[energyShiftsIndex++]) >> 16);
        }
    }

    public static void cbMemEnergy(short range, short[] cb, int cbIndex, short[] filteredCB, int filteredCbIndex, short length, short targetLength, short[] energy, int energyIndex, short[] energyShifts, int energyShiftsIndex, short scale, short baseSize) {
        int currValue = BasicFunctions.scaleRight(cb, cbIndex + length - targetLength, cb, cbIndex + length - targetLength, targetLength, scale);
        energyShifts[energyShiftsIndex] = BasicFunctions.norm(currValue);
        energy[energyIndex] = (short)(currValue << energyShifts[energyShiftsIndex] >> 16);
        CodingFunctions.energyCalc(currValue, range, cb, cbIndex + length - targetLength - 1, cb, cbIndex + length - 1, energy, energyIndex, energyShifts, energyShiftsIndex, scale, (short)0);
        currValue = BasicFunctions.scaleRight(filteredCB, filteredCbIndex + length - targetLength, filteredCB, filteredCbIndex + length - targetLength, targetLength, scale);
        energyShifts[baseSize + energyShiftsIndex] = BasicFunctions.norm(currValue);
        energy[baseSize + energyIndex] = (short)(currValue << energyShifts[baseSize + energyShiftsIndex] >> 16);
        CodingFunctions.energyCalc(currValue, range, filteredCB, filteredCbIndex + length - targetLength - 1, filteredCB, filteredCbIndex + length - 1, energy, energyIndex, energyShifts, energyShiftsIndex, scale, baseSize);
    }

    public static void cbSearch(EncoderState encoderState, EncoderBits encoderBits, CbSearchData searchData, CbUpdateIndexData updateIndexData, short[] inTarget, int inTargetIndex, short[] decResidual, int decResidualIndex, int length, int vectorLength, short[] weightDenum, int weightDenumindex, int blockNumber, int cbIndexIndex, int gainIndexIndex) {
        short scale;
        int i;
        short[] cbIndex = encoderBits.getCbIndex();
        short[] gainIndex = encoderBits.getGainIndex();
        short[] gains = new short[4];
        short[] cbBuf = new short[161];
        short[] energyShifts = new short[256];
        short[] targetVec = new short[50];
        short[] cbVectors = new short[147];
        short[] codedVec = new short[40];
        short[] interpSamples = new short[80];
        short[] interSamplesFilt = new short[80];
        short[] energy = new short[256];
        short[] augVec = new short[256];
        short[] inverseEnergy = energy;
        short[] inverseEnergyShifts = energyShifts;
        short[] buf = cbBuf;
        short[] target = targetVec;
        int[] cDot = new int[128];
        int[] crit = new int[128];
        short baseSize = (short)(length - vectorLength + 1);
        if (vectorLength == 40) {
            baseSize = (short)(length - 19);
        }
        int numberOfZeroes = length - Constants.FILTER_RANGE[blockNumber];
        BasicFunctions.filterAR(decResidual, decResidualIndex + numberOfZeroes, buf, 10 + numberOfZeroes, weightDenum, weightDenumindex, 11, Constants.FILTER_RANGE[blockNumber]);
        System.arraycopy(cbBuf, length, targetVec, 0, 10);
        BasicFunctions.filterAR(inTarget, inTargetIndex, target, 10, weightDenum, weightDenumindex, 11, vectorLength);
        System.arraycopy(target, 10, codedVec, 0, vectorLength);
        int currIndex = 10;
        short tempS = 0;
        for (i = 0; i < length; ++i) {
            if (buf[currIndex] > 0 && buf[currIndex] > tempS) {
                tempS = buf[currIndex];
            } else if (0 - buf[currIndex] > tempS) {
                tempS = (short)(0 - buf[currIndex]);
            }
            ++currIndex;
        }
        currIndex = 10;
        short tempS2 = 0;
        for (i = 0; i < vectorLength; ++i) {
            if (target[currIndex] > 0 && target[currIndex] > tempS2) {
                tempS2 = target[currIndex];
            } else if (0 - target[currIndex] > tempS2) {
                tempS2 = (short)(0 - target[currIndex]);
            }
            ++currIndex;
        }
        if (tempS > 0 && tempS2 > 0) {
            if (tempS2 > tempS) {
                tempS = tempS2;
            }
            scale = BasicFunctions.getSize(tempS * tempS);
        } else {
            scale = 30;
        }
        scale = (short)(scale - 25);
        if (scale < 0) {
            scale = 0;
        }
        short scale2 = scale;
        int targetEner = BasicFunctions.scaleRight(target, 10, target, 10, vectorLength, scale2);
        CodingFunctions.filteredCBVecs(cbVectors, 0, buf, 10, length, Constants.FILTER_RANGE[blockNumber]);
        short range = Constants.SEARCH_RANGE[blockNumber][0];
        if (vectorLength == 40) {
            CodingFunctions.interpolateSamples(interpSamples, 0, buf, 10, length);
            CodingFunctions.interpolateSamples(interSamplesFilt, 0, cbVectors, 0, length);
            CodingFunctions.cbMemEnergyAugmentation(interpSamples, 0, buf, 10, scale2, (short)20, energy, 0, energyShifts, 0);
            CodingFunctions.cbMemEnergyAugmentation(interSamplesFilt, 0, cbVectors, 0, scale2, (short)(baseSize + 20), energy, 0, energyShifts, 0);
            CodingFunctions.cbMemEnergy(range, buf, 10, cbVectors, 0, (short)length, (short)vectorLength, energy, 20, energyShifts, 20, scale2, baseSize);
        } else {
            CodingFunctions.cbMemEnergy(range, buf, 10, cbVectors, 0, (short)length, (short)vectorLength, energy, 0, energyShifts, 0, scale2, baseSize);
        }
        CodingFunctions.energyInverse(energy, 0, baseSize * 2);
        gains[0] = 16384;
        for (int stage = 0; stage < 3; ++stage) {
            int ppIndex;
            short[] pp;
            range = Constants.SEARCH_RANGE[blockNumber][stage];
            updateIndexData.setCritMax(0);
            updateIndexData.setShTotMax((short)-100);
            updateIndexData.setBestIndex((short)0);
            updateIndexData.setBestGain((short)0);
            if (vectorLength == 40) {
                CodingFunctions.augmentCbCorr(target, 10, buf, 10 + length, interpSamples, 0, cDot, 0, 20, 39, scale2);
                currIndex = 20;
            } else {
                currIndex = 0;
            }
            CodingFunctions.crossCorrelation(cDot, currIndex, target, 10, buf, 10 + length - vectorLength, (short)vectorLength, range, scale2, (short)-1);
            range = vectorLength == 40 ? (short)(Constants.SEARCH_RANGE[blockNumber][stage] + 20) : Constants.SEARCH_RANGE[blockNumber][stage];
            CodingFunctions.cbSearchCore(searchData, cDot, 0, range, (short)stage, inverseEnergy, 0, inverseEnergyShifts, 0, crit, 0);
            CodingFunctions.updateBestIndex(updateIndexData, searchData.getCritNew(), searchData.getCritNewSh(), searchData.getIndexNew(), cDot[searchData.getIndexNew()], inverseEnergy[searchData.getIndexNew()], inverseEnergyShifts[searchData.getIndexNew()]);
            short sInd = (short)(updateIndexData.getBestIndex() - 17);
            int eInd = sInd + 34;
            if (sInd < 0) {
                eInd -= sInd;
                sInd = 0;
            }
            if (eInd >= range) {
                eInd = (short)(range - 1);
                sInd = (short)(eInd - 34);
            }
            range = Constants.SEARCH_RANGE[blockNumber][stage];
            if (vectorLength == 40) {
                i = sInd;
                if (sInd < 20) {
                    if (eInd + 20 > 39) {
                        CodingFunctions.augmentCbCorr(target, 10, cbVectors, length, interSamplesFilt, 0, cDot, 0, sInd + 20, 39, scale2);
                    } else {
                        CodingFunctions.augmentCbCorr(target, 10, cbVectors, length, interSamplesFilt, 0, cDot, 0, sInd + 20, eInd + 20, scale2);
                    }
                    i = 20;
                }
                currIndex = 20 - sInd > 0 ? 20 - sInd : 0;
                CodingFunctions.crossCorrelation(cDot, currIndex, target, 10, cbVectors, length - 20 - i, (short)vectorLength, (short)(eInd - i + 1), scale2, (short)-1);
            } else {
                CodingFunctions.crossCorrelation(cDot, 0, target, 10, cbVectors, length - vectorLength - sInd, (short)vectorLength, (short)(eInd - sInd + 1), scale2, (short)-1);
            }
            CodingFunctions.cbSearchCore(searchData, cDot, 0, (short)(eInd - sInd + 1), (short)stage, inverseEnergy, baseSize + sInd, inverseEnergyShifts, baseSize + sInd, crit, 0);
            CodingFunctions.updateBestIndex(updateIndexData, searchData.getCritNew(), searchData.getCritNewSh(), (short)(searchData.getIndexNew() + baseSize + sInd), cDot[searchData.getIndexNew()], inverseEnergy[searchData.getIndexNew() + baseSize + sInd], inverseEnergyShifts[searchData.getIndexNew() + baseSize + sInd]);
            cbIndex[cbIndexIndex + stage] = updateIndexData.getBestIndex();
            if (gains[stage] > 0) {
                updateIndexData.setBestGain(CodingFunctions.gainQuant(updateIndexData.getBestGain(), gains[stage], (short)stage, gainIndex, gainIndexIndex + stage));
            } else {
                updateIndexData.setBestGain(CodingFunctions.gainQuant(updateIndexData.getBestGain(), (short)(0 - gains[stage]), (short)stage, gainIndex, gainIndexIndex + stage));
            }
            if (vectorLength == 80 - 57) {
                if (cbIndex[cbIndexIndex + stage] < baseSize) {
                    pp = buf;
                    ppIndex = 10 + length - vectorLength - cbIndex[cbIndexIndex + stage];
                } else {
                    pp = cbVectors;
                    ppIndex = length - vectorLength - cbIndex[cbIndexIndex + stage] + baseSize;
                }
            } else if (cbIndex[cbIndexIndex + stage] < baseSize) {
                if (cbIndex[cbIndexIndex + stage] >= 20) {
                    int n = cbIndexIndex + stage;
                    cbIndex[n] = (short)(cbIndex[n] - 20);
                    pp = buf;
                    ppIndex = 10 + length - vectorLength - cbIndex[cbIndexIndex + stage];
                } else {
                    int n = cbIndexIndex + stage;
                    cbIndex[n] = (short)(cbIndex[n] + (baseSize - 20));
                    CodingFunctions.createAugmentVector((short)(cbIndex[cbIndexIndex + stage] - baseSize + 40), buf, 10 + length, augVec, 0);
                    pp = augVec;
                    ppIndex = 0;
                }
            } else if (cbIndex[cbIndexIndex + stage] - baseSize >= 20) {
                int n = cbIndexIndex + stage;
                cbIndex[n] = (short)(cbIndex[n] - 20);
                pp = cbVectors;
                ppIndex = length - vectorLength - cbIndex[cbIndexIndex + stage] + baseSize;
            } else {
                int n = cbIndexIndex + stage;
                cbIndex[n] = (short)(cbIndex[n] + (baseSize - 20));
                CodingFunctions.createAugmentVector((short)(cbIndex[cbIndexIndex + stage] - 2 * baseSize + 40), cbVectors, length, augVec, 0);
                pp = augVec;
                ppIndex = 0;
            }
            BasicFunctions.addAffineVectorToVector(target, 10, pp, ppIndex, (short)(0 - updateIndexData.getBestGain()), 8192, (short)14, vectorLength);
            gains[stage + 1] = updateIndexData.getBestGain();
        }
        currIndex = 10;
        i = 0;
        while (i < vectorLength) {
            int n = i++;
            codedVec[n] = (short)(codedVec[n] - target[currIndex++]);
        }
        int codedEner = BasicFunctions.scaleRight(codedVec, 0, codedVec, 0, vectorLength, scale2);
        int j = gainIndex[gainIndexIndex];
        tempS = BasicFunctions.norm(codedEner);
        short nBits = tempS < (tempS2 = BasicFunctions.norm(targetEner)) ? (short)(16 - tempS) : (short)(16 - tempS2);
        targetEner = nBits < 0 ? (targetEner << 0 - nBits) * (gains[1] * gains[1] >> 14) : (targetEner >> nBits) * (gains[1] * gains[1] >> 14);
        int gainResult = gains[1] - 1 << 1;
        tempS = nBits < 0 ? (short)(codedEner << -nBits) : (short)(codedEner >> nBits);
        for (i = gainIndex[gainIndexIndex]; i < 32; ++i) {
            if (tempS * Constants.GAIN_SQ5_SQ[i] - targetEner >= 0 || Constants.GAIN_SQ5[j] >= gainResult) continue;
            j = i;
        }
        gainIndex[gainIndexIndex] = (short)j;
    }

    public static void cbSearchCore(CbSearchData searchData, int[] cDot, int cDotIndex, short range, short stage, short[] inverseEnergy, int inverseEnergyIndex, short[] inverseEnergyShift, int inverseEnergyShiftIndex, int[] crit, int critIndex) {
        short tempS;
        int n;
        if (stage == 0) {
            for (n = 0; n < range; ++n) {
                if (cDot[cDotIndex] < 0) {
                    cDot[cDotIndex] = 0;
                }
                ++cDotIndex;
            }
            cDotIndex -= range;
        }
        int current = 0;
        for (n = 0; n < range; ++n) {
            if (cDot[cDotIndex] > 0 && cDot[cDotIndex] > current) {
                current = cDot[cDotIndex];
            } else if (0 - cDot[cDotIndex] > current) {
                current = 0 - cDot[cDotIndex];
            }
            ++cDotIndex;
        }
        cDotIndex -= range;
        short nBits = BasicFunctions.norm(current);
        short max = Short.MIN_VALUE;
        for (n = 0; n < range; ++n) {
            tempS = (short)(cDot[cDotIndex++] << nBits >> 16);
            crit[critIndex] = (tempS * tempS >> 16) * inverseEnergy[inverseEnergyIndex++];
            if (crit[critIndex] != 0 && inverseEnergyShift[inverseEnergyShiftIndex] > max) {
                max = inverseEnergyShift[inverseEnergyShiftIndex];
            }
            ++inverseEnergyShiftIndex;
            ++critIndex;
        }
        if (max == Short.MIN_VALUE) {
            max = 0;
        }
        critIndex -= range;
        inverseEnergyShiftIndex -= range;
        for (n = 0; n < range; ++n) {
            if (max - inverseEnergyShift[inverseEnergyShiftIndex] > 16) {
                crit[critIndex] = crit[critIndex] >> 16;
            } else {
                tempS = (short)(max - inverseEnergyShift[inverseEnergyShiftIndex]);
                if (tempS < 0) {
                    int n2 = critIndex;
                    crit[n2] = crit[n2] << -tempS;
                } else {
                    int n3 = critIndex;
                    crit[n3] = crit[n3] >> tempS;
                }
            }
            ++inverseEnergyShiftIndex;
            ++critIndex;
        }
        int maxCrit = crit[critIndex -= range];
        ++critIndex;
        searchData.setIndexNew((short)0);
        for (n = 1; n < range; ++n) {
            if (crit[critIndex] > maxCrit) {
                maxCrit = crit[critIndex];
                searchData.setIndexNew((short)n);
            }
            ++critIndex;
        }
        searchData.setCritNew(maxCrit);
        searchData.setCritNewSh((short)(32 - 2 * nBits + max));
    }

    public static void cbConstruct(EncoderBits encoderBits, short[] decVector, int decVectorIndex, short[] mem, int memIndex, short length, short vectorLength, int cbIndexIndex, int gainIndexIndex) {
        short[] cbIndex = encoderBits.getCbIndex();
        short[] gainIndex = encoderBits.getGainIndex();
        short[] gain = new short[3];
        short[] cbVec0 = new short[40];
        short[] cbVec1 = new short[40];
        short[] cbVec2 = new short[40];
        gain[0] = CodingFunctions.gainDequant(gainIndex[gainIndexIndex], (short)16384, (short)0);
        gain[1] = CodingFunctions.gainDequant(gainIndex[gainIndexIndex + 1], gain[0], (short)1);
        gain[2] = CodingFunctions.gainDequant(gainIndex[gainIndexIndex + 2], gain[1], (short)2);
        System.arraycopy(emptyArray, 0, cbVec0, 0, 40);
        System.arraycopy(emptyArray, 0, cbVec1, 0, 40);
        System.arraycopy(emptyArray, 0, cbVec2, 0, 40);
        CodingFunctions.getCbVec(cbVec0, 0, mem, memIndex, cbIndex[cbIndexIndex], length, vectorLength);
        CodingFunctions.getCbVec(cbVec1, 0, mem, memIndex, cbIndex[cbIndexIndex + 1], length, vectorLength);
        CodingFunctions.getCbVec(cbVec2, 0, mem, memIndex, cbIndex[cbIndexIndex + 2], length, vectorLength);
        for (int i = 0; i < vectorLength; ++i) {
            decVector[decVectorIndex++] = (short)(gain[0] * cbVec0[i] + gain[1] * cbVec1[i] + gain[2] * cbVec2[i] + 8192 >> 14);
        }
    }

    public static void stateSearch(EncoderState encoderState, EncoderBits encoderBits, short[] residual, int residualIndex, short[] syntDenum, int syntIndex, short[] weightDenum, int weightIndex) {
        short tempS;
        short[] numerator = new short[11];
        short[] residualLongVec = new short[126];
        short[] sampleMa = new short[116];
        short[] residualLong = residualLongVec;
        short[] sampleAr = residualLongVec;
        short max = 0;
        int n = 0;
        while (true) {
            if (n >= 57) break;
            if ((tempS = residual[residualIndex++]) < 0) {
                tempS = (short)(0 - tempS);
            }
            if (tempS > max) {
                max = tempS;
            }
            ++n;
        }
        tempS = (short)(BasicFunctions.getSize(max) - 12);
        if (tempS < 0) {
            tempS = 0;
        }
        int currIndex = syntIndex + 10;
        for (n = 0; n < 11; ++n) {
            numerator[n] = (short)(syntDenum[currIndex--] >> tempS);
        }
        System.arraycopy(residual, residualIndex -= 57, residualLong, 10, 57);
        System.arraycopy(emptyArray, 0, residualLong, 10 + 57, 57);
        System.arraycopy(emptyArray, 0, residualLongVec, 0, 10);
        BasicFunctions.filterMA(residualLong, 10, sampleMa, 0, numerator, 0, 11, 57 + 10);
        System.arraycopy(emptyArray, 0, sampleMa, 57 + 10, 57 - 10);
        BasicFunctions.filterAR(sampleMa, 0, sampleAr, 10, syntDenum, syntIndex, 11, 2 * 57);
        int arIndex = 10;
        int arIndex2 = 10 + 57;
        n = 0;
        while (true) {
            if (n >= 57) break;
            int n2 = arIndex++;
            sampleAr[n2] = (short)(sampleAr[n2] + sampleAr[arIndex2++]);
            ++n;
        }
        max = 0;
        arIndex = 10;
        n = 0;
        while (true) {
            short tempS2;
            if (n >= 57) break;
            if ((tempS2 = sampleAr[arIndex++]) < 0) {
                tempS2 = (short)(0 - tempS2);
            }
            if (tempS2 > max) {
                max = tempS2;
            }
            ++n;
        }
        int temp = max << tempS < 23170 ? max * max << 2 + 2 * tempS : Integer.MAX_VALUE;
        currIndex = 0;
        for (n = 0; n < 63; ++n) {
            if (temp >= Constants.CHOOSE_FRG_QUANT[n]) {
                currIndex = n + 1;
                continue;
            }
            n = 63;
        }
        encoderBits.setIdxForMax((short)currIndex);
        int nBits = currIndex < 27 ? 4 : 9;
        BasicFunctions.scaleVector(sampleAr, 10, sampleAr, 10, Constants.SCALE[currIndex], 57, nBits - tempS);
        CodingFunctions.absQuant(encoderBits, sampleAr, 10, weightDenum, weightIndex);
    }

    public static void stateConstruct(EncoderBits encoderBits, short[] syntDenum, int syntDenumIndex, short[] outFix, int outFixIndex, int stateLen) {
        int bitShift;
        int coef;
        int k;
        short[] numerator = new short[11];
        short[] sampleValVec = new short[126];
        short[] sampleMaVec = new short[126];
        short[] sampleVal = sampleValVec;
        short[] sampleMa = sampleMaVec;
        short[] sampleAr = sampleValVec;
        short[] idxVec = encoderBits.getIdxVec();
        int currIndex = syntDenumIndex + 10;
        for (k = 0; k < 11; ++k) {
            numerator[k] = syntDenum[currIndex--];
        }
        short max = Constants.FRQ_QUANT_MOD[encoderBits.getIdxForMax()];
        if (encoderBits.getIdxForMax() < 37) {
            coef = 0x200000;
            bitShift = 22;
        } else if (encoderBits.getIdxForMax() < 59) {
            coef = 262144;
            bitShift = 19;
        } else {
            coef = 65536;
            bitShift = 17;
        }
        currIndex = 10;
        int currIndex2 = stateLen - 1;
        for (k = 0; k < stateLen; ++k) {
            sampleVal[currIndex++] = (short)(max * Constants.STATE_SQ3[idxVec[currIndex2--]] + coef >> bitShift);
        }
        System.arraycopy(emptyArray, 0, sampleVal, 10 + stateLen, stateLen);
        System.arraycopy(emptyArray, 0, sampleValVec, 0, 10);
        BasicFunctions.filterMA(sampleVal, 10, sampleMa, 10, numerator, 0, 11, 11 + stateLen);
        System.arraycopy(emptyArray, 0, sampleMa, 20 + stateLen, stateLen - 10);
        BasicFunctions.filterAR(sampleMa, 10, sampleAr, 10, syntDenum, syntDenumIndex, 11, 2 * stateLen);
        currIndex = 10 + stateLen - 1;
        currIndex2 = 10 + 2 * stateLen - 1;
        for (k = 0; k < stateLen; ++k) {
            outFix[outFixIndex++] = (short)(sampleAr[currIndex--] + sampleAr[currIndex2--]);
        }
    }

    public static void filteredCBVecs(short[] cbVectors, int cbVectorsIndex, short[] cbMem, int cbMemIndex, int length, int samples) {
        System.arraycopy(emptyArray, 0, cbMem, cbMemIndex + length, 4);
        System.arraycopy(emptyArray, 0, cbMem, cbMemIndex - 4, 4);
        System.arraycopy(emptyArray, 0, cbVectors, cbVectorsIndex, length - samples);
        BasicFunctions.filterMA(cbMem, cbMemIndex + 4 + length - samples, cbVectors, cbVectorsIndex + length - samples, Constants.CB_FILTERS_REV, 0, 8, samples);
    }

    public static void crossCorrelation(int[] crossCorrelation, int crossCorrelationIndex, short[] seq1, int seq1Index, short[] seq2, int seq2Index, short dimSeq, short dimCrossCorrelation, short rightShifts, short stepSeq2) {
        for (int i = 0; i < dimCrossCorrelation; ++i) {
            crossCorrelation[crossCorrelationIndex] = 0;
            for (int j = 0; j < dimSeq; ++j) {
                int n = crossCorrelationIndex;
                crossCorrelation[n] = crossCorrelation[n] + (seq1[seq1Index++] * seq2[seq2Index++] >> rightShifts);
            }
            seq1Index -= dimSeq;
            seq2Index = seq2Index + stepSeq2 - dimSeq;
            ++crossCorrelationIndex;
        }
    }

    public static void updateBestIndex(CbUpdateIndexData updateIndexData, int critNew, short critNewSh, short indexNew, int cDotNew, short inverseEnergyNew, short energyShiftNew) {
        int shNew;
        int shOld;
        int current = critNewSh - updateIndexData.getShTotMax();
        if (current > 31) {
            shOld = 31;
            shNew = 0;
        } else if (current > 0) {
            shOld = current;
            shNew = 0;
        } else if (current > -31) {
            shNew = 0 - current;
            shOld = 0;
        } else {
            shNew = 31;
            shOld = 0;
        }
        if (critNew >> shNew > updateIndexData.getCritMax() >> shOld) {
            int gain;
            short tempShort = (short)(16 - BasicFunctions.norm(cDotNew));
            int tempScale = 31 - energyShiftNew - tempShort;
            if (tempScale > 31) {
                tempScale = 31;
            }
            if ((gain = tempShort < 0 ? (cDotNew << -tempShort) * inverseEnergyNew >> tempScale : (cDotNew >> tempShort) * inverseEnergyNew >> tempScale) > 21299) {
                updateIndexData.setBestGain((short)21299);
            } else if (gain < -21299) {
                updateIndexData.setBestGain((short)-21299);
            } else {
                updateIndexData.setBestGain((short)gain);
            }
            updateIndexData.setCritMax(critNew);
            updateIndexData.setShTotMax(critNewSh);
            updateIndexData.setBestIndex(indexNew);
        }
    }

    public static void getCbVec(short[] cbVec, int cbVecIndex, short[] mem, int memIndex, short index, int length, int vectorLength) {
        short[] tempBuffer = new short[45];
        int baseSize = length - vectorLength + 1;
        if (vectorLength == 40) {
            baseSize += vectorLength >> 1;
        }
        if (index < length - vectorLength + 1) {
            int k = index + vectorLength;
            System.arraycopy(mem, memIndex + length - k, cbVec, cbVecIndex, vectorLength);
        } else if (index < baseSize) {
            int k = 2 * (index - (length - vectorLength + 1)) + vectorLength;
            CodingFunctions.createAugmentVector((short)(k >> 1), mem, memIndex + length, cbVec, cbVecIndex);
        } else if (index - baseSize < length - vectorLength + 1) {
            System.arraycopy(emptyArray, 0, mem, memIndex - 4, 4);
            System.arraycopy(emptyArray, 0, mem, memIndex + length, 4);
            BasicFunctions.filterMA(mem, memIndex + length - (index - baseSize + vectorLength) + 4, cbVec, cbVecIndex, Constants.CB_FILTERS_REV, 0, 8, vectorLength);
        } else {
            System.arraycopy(emptyArray, 0, mem, memIndex + length, 4);
            BasicFunctions.filterMA(mem, memIndex + length - vectorLength - 1, tempBuffer, 0, Constants.CB_FILTERS_REV, 0, 8, vectorLength + 5);
            CodingFunctions.createAugmentVector((short)((vectorLength << 1) - 20 + index - baseSize - length - 1), tempBuffer, 45, cbVec, cbVecIndex);
        }
    }

    public static void createAugmentVector(short index, short[] buf, int bufIndex, short[] cbVec, int cbVecIndex) {
        short[] cbVecTmp = new short[4];
        int currIndex = cbVecIndex + index - 4;
        System.arraycopy(buf, bufIndex - index, cbVec, cbVecIndex, index);
        BasicFunctions.multWithRightShift(cbVec, currIndex, buf, bufIndex - index - 4, Constants.ALPHA, 0, 4, 15);
        BasicFunctions.reverseMultiplyRight(cbVecTmp, 0, buf, bufIndex - 4, Constants.ALPHA, 3, 4, 15);
        BasicFunctions.addWithRightShift(cbVec, currIndex, cbVec, currIndex, cbVecTmp, 0, 4, 0);
        System.arraycopy(buf, bufIndex - index, cbVec, cbVecIndex + index, 40 - index);
    }

    public static void energyInverse(short[] energy, int energyIndex, int length) {
        for (int n = 0; n < length; ++n) {
            if (energy[energyIndex] < 16384) {
                energy[energyIndex++] = Short.MAX_VALUE;
                continue;
            }
            energy[energyIndex] = (short)(0x1FFFFFFF / energy[energyIndex]);
            ++energyIndex;
        }
    }

    public static void energyCalc(int energy, short range, short[] ppi, int ppiIndex, short[] ppo, int ppoIndex, short[] energyArray, int energyArrayIndex, short[] energyShifts, int energyShiftsIndex, short scale, short baseSize) {
        energyShiftsIndex += 1 + baseSize;
        energyArrayIndex += 1 + baseSize;
        for (int n = 0; n < range - 1; ++n) {
            if ((energy += ppi[ppiIndex] * ppi[ppiIndex] - ppo[ppoIndex] * ppo[ppoIndex] >> scale) < 0) {
                energy = 0;
            }
            --ppiIndex;
            --ppoIndex;
            energyShifts[energyShiftsIndex] = BasicFunctions.norm(energy);
            energyArray[energyArrayIndex++] = (short)(energy << energyShifts[energyShiftsIndex] >> 16);
            ++energyShiftsIndex;
        }
    }

    public static void augmentCbCorr(short[] target, int targetIndex, short[] buf, int bufIndex, short[] interpSamples, int interpSamplesIndex, int[] cDot, int cDotIndex, int low, int high, int scale) {
        for (int n = low; n <= high; ++n) {
            cDot[cDotIndex] = BasicFunctions.scaleRight(target, targetIndex, buf, bufIndex - n, n - 4, scale);
            int n2 = cDotIndex;
            cDot[n2] = cDot[n2] + BasicFunctions.scaleRight(target, targetIndex + n - 4, interpSamples, interpSamplesIndex, 4, scale);
            interpSamplesIndex += 4;
            int n3 = cDotIndex++;
            cDot[n3] = cDot[n3] + BasicFunctions.scaleRight(target, targetIndex + n, buf, bufIndex - n, 40 - n, scale);
        }
    }

    public static void absQuant(EncoderBits encoderBits, short[] in, int inIndex, short[] weightDenum, int weightDenumIndex) {
        short[] inWeightedVec;
        short[] quantLen = new short[2];
        short[] syntOutBuf = new short[68];
        short[] inWeighted = inWeightedVec = new short[68];
        System.arraycopy(emptyArray, 0, syntOutBuf, 0, 68);
        System.arraycopy(emptyArray, 0, inWeightedVec, 0, 10);
        if (encoderBits.getStateFirst()) {
            quantLen[0] = 40;
            quantLen[1] = 17;
        } else {
            quantLen[0] = 17;
            quantLen[1] = 40;
        }
        BasicFunctions.filterAR(in, inIndex, inWeighted, 10, weightDenum, weightDenumIndex, 11, quantLen[0]);
        BasicFunctions.filterAR(in, inIndex + quantLen[0], inWeighted, 10 + quantLen[0], weightDenum, weightDenumIndex + 11, 11, quantLen[1]);
        CodingFunctions.absQUantLoop(encoderBits, syntOutBuf, 10, inWeighted, 10, weightDenum, weightDenumIndex, quantLen, 0);
    }

    public static void absQUantLoop(EncoderBits encoderBits, short[] syntOut, int syntOutIndex, short[] inWeighted, int inWeightedIndex, short[] weightDenum, int weightDenumIndex, short[] quantLen, int quantLenIndex) {
        short[] idxVec = encoderBits.getIdxVec();
        int startIndex = 0;
        for (int i = 0; i < 2; ++i) {
            int currIndex = quantLenIndex + i;
            for (int j = 0; j < quantLen[currIndex]; ++j) {
                int k;
                BasicFunctions.filterAR(syntOut, syntOutIndex, syntOut, syntOutIndex, weightDenum, weightDenumIndex, 11, 1);
                int temp = inWeighted[inWeightedIndex] - syntOut[syntOutIndex];
                int temp2 = temp << 2;
                if (temp2 > Short.MAX_VALUE) {
                    temp2 = Short.MAX_VALUE;
                } else if (temp2 < Short.MIN_VALUE) {
                    temp2 = Short.MIN_VALUE;
                }
                if (temp < -7577) {
                    idxVec[startIndex + j] = 0;
                    syntOut[syntOutIndex++] = (short)((Constants.STATE_SQ3[0] + 2 >> 2) + inWeighted[inWeightedIndex++] - temp);
                    continue;
                }
                if (temp > 8151) {
                    idxVec[startIndex + j] = 7;
                    syntOut[syntOutIndex++] = (short)((Constants.STATE_SQ3[7] + 2 >> 2) + inWeighted[inWeightedIndex++] - temp);
                    continue;
                }
                if (temp2 <= Constants.STATE_SQ3[0]) {
                    idxVec[startIndex + j] = 0;
                    syntOut[syntOutIndex++] = (short)((Constants.STATE_SQ3[0] + 2 >> 2) + inWeighted[inWeightedIndex++] - temp);
                    continue;
                }
                for (k = 0; temp2 > Constants.STATE_SQ3[k] && k < Constants.STATE_SQ3.length - 1; ++k) {
                }
                if (temp2 > Constants.STATE_SQ3[k] + Constants.STATE_SQ3[k - 1] + 1 >> 1) {
                    idxVec[startIndex + j] = (short)k;
                    syntOut[syntOutIndex++] = (short)((Constants.STATE_SQ3[k] + 2 >> 2) + inWeighted[inWeightedIndex++] - temp);
                    continue;
                }
                idxVec[startIndex + j] = (short)(k - 1);
                syntOut[syntOutIndex++] = (short)((Constants.STATE_SQ3[k - 1] + 2 >> 2) + inWeighted[inWeightedIndex++] - temp);
            }
            startIndex += quantLen[currIndex];
            weightDenumIndex += 11;
        }
    }

    public static void interpolateSamples(short[] interpSamples, int interpSamplesIndex, short[] cbMem, int cbMemIndex, int length) {
        for (int n = 0; n < 20; ++n) {
            int highIndex = cbMemIndex + length - 4;
            int lowIndex = cbMemIndex + length - n - 24;
            interpSamples[interpSamplesIndex++] = (short)((Constants.ALPHA[3] * cbMem[highIndex++] >> 15) + (Constants.ALPHA[0] * cbMem[lowIndex++] >> 15));
            interpSamples[interpSamplesIndex++] = (short)((Constants.ALPHA[2] * cbMem[highIndex++] >> 15) + (Constants.ALPHA[1] * cbMem[lowIndex++] >> 15));
            interpSamples[interpSamplesIndex++] = (short)((Constants.ALPHA[1] * cbMem[highIndex++] >> 15) + (Constants.ALPHA[2] * cbMem[lowIndex++] >> 15));
            interpSamples[interpSamplesIndex++] = (short)((Constants.ALPHA[0] * cbMem[highIndex++] >> 15) + (Constants.ALPHA[3] * cbMem[lowIndex++] >> 15));
        }
    }

    public static short frameClassify(short[] residual) {
        int n;
        int[] ssqEn = new int[5];
        short max = 0;
        for (n = 0; n < 160; ++n) {
            short tempS = residual[n];
            if (tempS < 0) {
                tempS = (short)(0 - tempS);
            }
            if (tempS <= max) continue;
            max = tempS;
        }
        short scale = (short)(BasicFunctions.getSize(max * max) - 24);
        if (scale < 0) {
            scale = 0;
        }
        int ssqIndex = 2;
        int currIndex = 0;
        for (n = 3; n > 0; --n) {
            ssqEn[currIndex++] = BasicFunctions.scaleRight(residual, ssqIndex, residual, ssqIndex, 76, scale);
            ssqIndex += 40;
        }
        ssqIndex = 0;
        int maxSSq = ssqEn[0];
        for (n = 1; n < 3; ++n) {
            if (ssqEn[n] <= maxSSq) continue;
            maxSSq = ssqEn[n];
        }
        scale = (short)(BasicFunctions.getSize(maxSSq) - 20);
        if (scale < 0) {
            scale = 0;
        }
        ssqIndex = 0;
        currIndex = 1;
        for (n = 3; n > 0; --n) {
            ssqEn[ssqIndex] = (ssqEn[ssqIndex] >> scale) * Constants.ENG_START_SEQUENCE[currIndex++];
            ++ssqIndex;
        }
        currIndex = 0;
        maxSSq = ssqEn[0];
        for (n = 1; n < 3; ++n) {
            if (ssqEn[n] <= maxSSq) continue;
            currIndex = n;
            maxSSq = ssqEn[n];
        }
        return (short)(currIndex + 1);
    }

    public static void packBits(EncoderState encoderState, EncoderBits encoderBits, byte[] result) {
        int i;
        int k;
        int resIndex;
        short[] lsf = encoderBits.getLSF();
        short[] cbIndex = encoderBits.getCbIndex();
        short[] gainIndex = encoderBits.getGainIndex();
        short[] idxVec = encoderBits.getIdxVec();
        result[0] = (byte)(lsf[0] << 2 | lsf[1] >> 5 & 3);
        result[1] = (byte)((lsf[1] & 0x1F) << 3 | lsf[2] >> 4 & 7);
        result[2] = (byte)((lsf[2] & 0xF) << 4);
        if (20 == 20) {
            result[2] = encoderBits.getStateFirst() ? (byte)(result[2] | ((encoderBits.getStartIdx() & 3) << 2 | 2)) : (byte)(result[2] | (encoderBits.getStartIdx() & 3) << 2);
            result[2] = (byte)(result[2] | encoderBits.getIdxForMax() >> 5 & 1);
            result[3] = (byte)((encoderBits.getIdxForMax() & 0x1F) << 3 | cbIndex[0] >> 4 & 7);
            result[4] = (byte)((cbIndex[0] & 0xE) << 4 | gainIndex[0] & 0x18 | (gainIndex[1] & 8) >> 1 | cbIndex[3] >> 6 & 3);
            result[5] = (byte)((cbIndex[3] & 0x3E) << 2 | gainIndex[3] >> 2 & 4 | gainIndex[4] >> 2 & 2 | gainIndex[6] >> 4 & 1);
            resIndex = 6;
        } else {
            result[2] = (byte)(result[2] | lsf[3] >> 2 & 0xF);
            result[3] = (byte)((lsf[3] & 3) << 6 | lsf[4] >> 1 & 0x3F);
            result[4] = (byte)((lsf[4] & 1) << 7 | lsf[5] & 0x7F);
            result[5] = encoderBits.getStateFirst() ? (byte)(encoderBits.getStartIdx() << 5 | 0x10 | encoderBits.getIdxForMax() >> 2 & 0xF) : (byte)(encoderBits.getStartIdx() << 5 | encoderBits.getIdxForMax() >> 2 & 0xF);
            result[6] = (byte)((encoderBits.getIdxForMax() & 3) << 6 | (cbIndex[0] & 0x78) >> 1 | (gainIndex[0] & 0x10) >> 3 | (gainIndex[1] & 0x80) >> 3);
            result[7] = (byte)(cbIndex[3] & 0xFC | (gainIndex[3] & 0x10) >> 3 | (gainIndex[4] & 0x80) >> 3);
            resIndex = 8;
        }
        int idxVecIndex = 0;
        for (k = 0; k < 7; ++k) {
            result[resIndex] = 0;
            for (i = 7; i >= 0; --i) {
                int n = resIndex;
                result[n] = (byte)(result[n] | (idxVec[idxVecIndex++] & 4) >> 2 << i);
            }
            ++resIndex;
        }
        result[resIndex] = (byte)((idxVec[idxVecIndex++] & 4) << 5);
        if (20 == 20) {
            int n = resIndex;
            result[n] = (byte)(result[n] | (gainIndex[1] & 4) << 4);
            int n2 = resIndex;
            result[n2] = (byte)(result[n2] | (gainIndex[3] & 0xC) << 2);
            int n3 = resIndex;
            result[n3] = (byte)(result[n3] | (gainIndex[4] & 4) << 1);
            int n4 = resIndex;
            result[n4] = (byte)(result[n4] | (gainIndex[6] & 8) >> 1);
            int n5 = resIndex;
            result[n5] = (byte)(result[n5] | (gainIndex[7] & 0xC) >> 2);
        } else {
            int n = resIndex;
            result[n] = (byte)(result[n] | (idxVec[idxVecIndex++] & 4) << 4);
            int n6 = resIndex;
            result[n6] = (byte)(result[n6] | (cbIndex[0] & 6) << 3);
            int n7 = resIndex;
            result[n7] = (byte)(result[n7] | gainIndex[0] & 8);
            int n8 = resIndex;
            result[n8] = (byte)(result[n8] | gainIndex[1] & 4);
            int n9 = resIndex;
            result[n9] = (byte)(result[n9] | cbIndex[3] & 2);
            int n10 = resIndex++;
            result[n10] = (byte)(result[n10] | (cbIndex[6] & 0x80) >> 7);
            result[resIndex] = (byte)((cbIndex[6] & 0x7E) << 1 | (cbIndex[9] & 0xC0) >> 6);
            result[++resIndex] = (byte)((cbIndex[9] & 0x3E) << 2 | (cbIndex[12] & 0xE0) >> 5);
            result[++resIndex] = (byte)((cbIndex[12] & 0x1E) << 3 | gainIndex[3] & 0xC | (gainIndex[4] & 6) >> 1);
            result[++resIndex] = (byte)((gainIndex[6] & 0x18) << 3 | (gainIndex[7] & 0xC) << 2 | (gainIndex[9] & 0x10) >> 1 | (gainIndex[10] & 8) >> 1 | (gainIndex[12] & 0x10) >> 3 | (gainIndex[13] & 8) >> 3);
        }
        idxVecIndex = 0;
        ++resIndex;
        for (k = 0; k < 14; ++k) {
            result[resIndex] = 0;
            for (i = 6; i >= 0; i -= 2) {
                int n = resIndex;
                result[n] = (byte)(result[n] | (idxVec[idxVecIndex++] & 3) << i);
            }
            ++resIndex;
        }
        if (20 == 20) {
            result[resIndex++] = (byte)((idxVec[56] & 3) << 6 | (cbIndex[0] & 1) << 5 | (cbIndex[1] & 0x7C) >> 2);
            result[resIndex++] = (byte)((cbIndex[1] & 3) << 6 | cbIndex[2] >> 1 & 0x3F);
            result[resIndex++] = (byte)((cbIndex[2] & 1) << 7 | (gainIndex[0] & 7) << 4 | (gainIndex[1] & 3) << 2 | (gainIndex[2] & 6) >> 1);
            result[resIndex++] = (byte)((gainIndex[2] & 1) << 7 | (cbIndex[3] & 1) << 6 | (cbIndex[4] & 0x7E) >> 1);
            result[resIndex++] = (byte)((cbIndex[4] & 1) << 7 | cbIndex[5] & 0x7F);
            result[resIndex++] = (byte)(cbIndex[6] & 0xFF);
            result[resIndex++] = (byte)(cbIndex[7] & 0xFF);
            result[resIndex++] = (byte)(cbIndex[8] & 0xFF);
            result[resIndex++] = (byte)((gainIndex[3] & 3) << 6 | (gainIndex[4] & 3) << 4 | (gainIndex[5] & 7) << 1 | (gainIndex[6] & 4) >> 2);
            result[resIndex++] = (byte)((gainIndex[6] & 3) << 6 | (gainIndex[7] & 3) << 4 | (gainIndex[8] & 7) << 1);
        } else {
            result[resIndex++] = (byte)((idxVec[56] & 3) << 6 | (idxVec[57] & 3) << 4 | (cbIndex[0] & 1) << 3 | (cbIndex[1] & 0x70) >> 4);
            result[resIndex++] = (byte)((cbIndex[1] & 0xF) << 4 | (cbIndex[2] & 0x78) >> 3);
            result[resIndex++] = (byte)((cbIndex[2] & 7) << 5 | (gainIndex[0] & 7) << 2 | gainIndex[1] & 3);
            result[resIndex++] = (byte)((gainIndex[2] & 7) << 7 | (cbIndex[3] & 1) << 4 | (cbIndex[4] & 0x78) >> 3);
            result[resIndex++] = (byte)((cbIndex[4] & 7) << 5 | (cbIndex[5] & 0x7C) >> 2);
            result[resIndex++] = (byte)((cbIndex[5] & 3) << 6 | (cbIndex[6] & 1) << 1 | (cbIndex[7] & 0xF8) >> 3);
            result[resIndex++] = (byte)((cbIndex[7] & 7) << 5 | (cbIndex[8] & 0xF8) >> 3);
            result[resIndex++] = (byte)((cbIndex[8] & 7) << 5 | (cbIndex[9] & 1) << 4 | (cbIndex[10] & 0xF0) >> 4);
            result[resIndex++] = (byte)((cbIndex[10] & 0xF) << 4 | (cbIndex[11] & 0xF0) >> 4);
            result[resIndex++] = (byte)((cbIndex[11] & 0xF) << 4 | (cbIndex[12] & 1) << 3 | (cbIndex[13] & 0xE0) >> 5);
            result[resIndex++] = (byte)((cbIndex[13] & 0x1F) << 3 | (cbIndex[14] & 0xE0) >> 5);
            result[resIndex++] = (byte)((cbIndex[14] & 0x1F) << 3 | (gainIndex[3] & 3) << 1 | gainIndex[4] & 1);
            result[resIndex++] = (byte)((gainIndex[5] & 7) << 5 | (gainIndex[6] & 7) << 2 | gainIndex[7] & 3);
            result[resIndex++] = (byte)((gainIndex[8] & 7) << 5 | (gainIndex[9] & 0xF) << 1 | (gainIndex[10] & 4) >> 2);
            result[resIndex++] = (byte)((gainIndex[10] & 3) << 6 | (gainIndex[11] & 7) << 3 | (gainIndex[12] & 0xE) >> 1);
            result[resIndex++] = (byte)((gainIndex[12] & 1) << 7 | (gainIndex[13] & 7) << 4 | (gainIndex[14] & 7) << 1);
        }
    }

    public static void unpackBits(EncoderBits encoderBits, short[] data, int mode) {
        int i;
        int k;
        short[] lsf = encoderBits.getLSF();
        short[] cbIndex = encoderBits.getCbIndex();
        short[] gainIndex = encoderBits.getGainIndex();
        short[] idxVec = encoderBits.getIdxVec();
        int tempIndex1 = 0;
        int tempIndex2 = 0;
        lsf[0] = (short)(data[tempIndex1] >> 10 & 0x3F);
        lsf[1] = (short)(data[tempIndex1] >> 3 & 0x7F);
        lsf[2] = (short)((data[tempIndex1] & 7) << 4);
        tempIndex1 = (short)(tempIndex1 + 1);
        lsf[2] = (short)(lsf[2] | data[tempIndex1] >> 12 & 0xF);
        if (mode == 20) {
            encoderBits.setStartIdx((short)(data[tempIndex1] >> 10 & 3));
            encoderBits.setStateFirst(false);
            if ((data[tempIndex1] >> 9 & 1) != 0) {
                encoderBits.setStateFirst(true);
            }
            encoderBits.setIdxForMax((short)(data[tempIndex1] >> 3 & 0x3F));
            cbIndex[0] = (short)((data[tempIndex1] & 7) << 4);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[0] = (short)(cbIndex[0] | data[tempIndex1] >> 12 & 0xE);
            gainIndex[0] = (short)(data[tempIndex1] >> 8 & 0x18);
            gainIndex[1] = (short)(data[tempIndex1] >> 7 & 8);
            cbIndex[3] = (short)(data[tempIndex1] >> 2 & 0xFE);
            gainIndex[3] = (short)(data[tempIndex1] << 2 & 0x10);
            gainIndex[4] = (short)(data[tempIndex1] << 2 & 8);
            gainIndex[6] = (short)(data[tempIndex1] << 4 & 0x10);
        } else {
            lsf[3] = (short)(data[tempIndex1] >> 6 & 0x3F);
            lsf[4] = (short)(data[tempIndex1] << 1 & 0x7E);
            tempIndex1 = (short)(tempIndex1 + 1);
            lsf[4] = (short)(lsf[4] | data[tempIndex1] >> 15 & 1);
            lsf[5] = (short)(data[tempIndex1] >> 8 & 0x7F);
            encoderBits.setStartIdx((short)(data[tempIndex1] >> 5 & 7));
            encoderBits.setStateFirst(false);
            if ((short)(data[tempIndex1] >> 4 & 1) != 0) {
                encoderBits.setStateFirst(true);
            }
            short tempS = (short)(data[tempIndex1] << 2 & 0x3C);
            tempIndex1 = (short)(tempIndex1 + 1);
            tempS = (short)(tempS | data[tempIndex1] >> 14 & 3);
            encoderBits.setIdxForMax(tempS);
            cbIndex[0] = (short)(data[tempIndex1] >> 7 & 0x78);
            gainIndex[0] = (short)(data[tempIndex1] >> 5 & 0x10);
            gainIndex[1] = (short)(data[tempIndex1] >> 5 & 8);
            cbIndex[3] = (short)(data[tempIndex1] & 0xFC);
            gainIndex[3] = (short)(data[tempIndex1] << 3 & 0x10);
            gainIndex[4] = (short)(data[tempIndex1] << 3 & 8);
        }
        tempIndex1 = (short)(tempIndex1 + 1);
        tempIndex2 = 0;
        for (k = 0; k < 3; ++k) {
            for (i = 15; i >= 0; --i) {
                int n = tempIndex2;
                tempIndex2 = (short)(tempIndex2 + 1);
                idxVec[n] = (short)(data[tempIndex1] >> i << 2 & 4);
            }
            tempIndex1 = (short)(tempIndex1 + 1);
        }
        if (mode == 20) {
            for (i = 15; i > 6; --i) {
                int n = tempIndex2;
                tempIndex2 = (short)(tempIndex2 + 1);
                idxVec[n] = (short)(data[tempIndex1] >> i << 2 & 4);
            }
            gainIndex[1] = (short)(gainIndex[1] | data[tempIndex1] >> 4 & 4);
            gainIndex[3] = (short)(gainIndex[3] | data[tempIndex1] >> 2 & 0xC);
            gainIndex[4] = (short)(gainIndex[4] | data[tempIndex1] >> 1 & 4);
            gainIndex[6] = (short)(gainIndex[6] | data[tempIndex1] << 1 & 8);
            gainIndex[7] = (short)(data[tempIndex1] << 2 & 0xC);
        } else {
            for (i = 15; i > 5; --i) {
                int n = tempIndex2;
                tempIndex2 = (short)(tempIndex2 + 1);
                idxVec[n] = (short)(data[tempIndex1] >> i << 2 & 4);
            }
            cbIndex[0] = (short)(cbIndex[0] | data[tempIndex1] >> 3 & 6);
            gainIndex[0] = (short)(gainIndex[0] | data[tempIndex1] & 8);
            gainIndex[1] = (short)(gainIndex[1] | data[tempIndex1] & 4);
            cbIndex[3] = (short)(cbIndex[3] | data[tempIndex1] & 2);
            cbIndex[6] = (short)(data[tempIndex1] << 7 & 0x80);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[6] = (short)(cbIndex[6] | data[tempIndex1] >> 9 & 0x7E);
            cbIndex[9] = (short)(data[tempIndex1] >> 2 & 0xFE);
            cbIndex[12] = (short)(data[tempIndex1] << 5 & 0xE0);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[12] = (short)(cbIndex[12] | data[tempIndex1] >> 11 & 0x1E);
            gainIndex[3] = (short)(gainIndex[3] | data[tempIndex1] >> 8 & 0xC);
            gainIndex[4] = (short)(gainIndex[4] | data[tempIndex1] >> 7 & 6);
            gainIndex[6] = (short)(data[tempIndex1] >> 3 & 0x18);
            gainIndex[7] = (short)(data[tempIndex1] >> 2 & 0xC);
            gainIndex[9] = (short)(data[tempIndex1] << 1 & 0x10);
            gainIndex[10] = (short)(data[tempIndex1] << 1 & 8);
            gainIndex[12] = (short)(data[tempIndex1] << 3 & 0x10);
            gainIndex[13] = (short)(data[tempIndex1] << 3 & 8);
        }
        tempIndex1 = (short)(tempIndex1 + 1);
        tempIndex2 = 0;
        for (k = 0; k < 7; ++k) {
            for (i = 14; i >= 0; i -= 2) {
                int n = tempIndex2;
                tempIndex2 = (short)(tempIndex2 + 1);
                idxVec[n] = (short)(idxVec[n] | data[tempIndex1] >> i & 3);
            }
            tempIndex1 = (short)(tempIndex1 + 1);
        }
        if (mode == 20) {
            idxVec[56] = (short)(idxVec[56] | data[tempIndex1] >> 14 & 3);
            cbIndex[0] = (short)(cbIndex[0] | data[tempIndex1] >> 13 & 1);
            cbIndex[1] = (short)(data[tempIndex1] >> 6 & 0x7F);
            cbIndex[2] = (short)(data[tempIndex1] << 1 & 0x7E);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[2] = (short)(cbIndex[2] | data[tempIndex1] >> 15 & 1);
            gainIndex[0] = (short)(gainIndex[0] | data[tempIndex1] >> 12 & 7);
            gainIndex[1] = (short)(gainIndex[1] | data[tempIndex1] >> 10 & 3);
            gainIndex[2] = (short)(data[tempIndex1] >> 7 & 7);
            cbIndex[3] = (short)(cbIndex[3] | data[tempIndex1] >> 6 & 1);
            cbIndex[4] = (short)(data[tempIndex1] << 1 & 0x7E);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[4] = (short)(cbIndex[4] | data[tempIndex1] >> 15 & 1);
            cbIndex[5] = (short)(data[tempIndex1] >> 8 & 0x7F);
            cbIndex[6] = (short)(data[tempIndex1] & 0xFF);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[7] = (short)(data[tempIndex1] >> 8 & 0xFF);
            cbIndex[8] = (short)(data[tempIndex1] & 0xFF);
            tempIndex1 = (short)(tempIndex1 + 1);
            gainIndex[3] = (short)(gainIndex[3] | data[tempIndex1] >> 14 & 3);
            gainIndex[4] = (short)(gainIndex[4] | data[tempIndex1] >> 12 & 3);
            gainIndex[5] = (short)(data[tempIndex1] >> 9 & 7);
            gainIndex[6] = (short)(gainIndex[6] | data[tempIndex1] >> 6 & 7);
            gainIndex[7] = (short)(gainIndex[7] | data[tempIndex1] >> 4 & 3);
            gainIndex[8] = (short)(data[tempIndex1] >> 1 & 7);
        } else {
            idxVec[56] = (short)(idxVec[56] | data[tempIndex1] >> 14 & 3);
            idxVec[57] = (short)(idxVec[57] | data[tempIndex1] >> 12 & 3);
            cbIndex[0] = (short)(cbIndex[0] | data[tempIndex1] >> 11 & 1);
            cbIndex[1] = (short)(data[tempIndex1] >> 4 & 0x7F);
            cbIndex[2] = (short)(data[tempIndex1] << 3 & 0x78);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[2] = (short)(cbIndex[2] | data[tempIndex1] >> 13 & 7);
            gainIndex[0] = (short)(gainIndex[0] | data[tempIndex1] >> 10 & 7);
            gainIndex[1] = (short)(gainIndex[1] | data[tempIndex1] >> 8 & 3);
            gainIndex[2] = (short)(data[tempIndex1] >> 5 & 7);
            cbIndex[3] = (short)(cbIndex[3] | data[tempIndex1] >> 4 & 1);
            cbIndex[4] = (short)(data[tempIndex1] << 3 & 0x78);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[4] = (short)(cbIndex[4] | data[tempIndex1] >> 13 & 7);
            cbIndex[5] = (short)(data[tempIndex1] >> 6 & 0x7F);
            cbIndex[6] = (short)(cbIndex[6] | data[tempIndex1] >> 5 & 1);
            cbIndex[7] = (short)(data[tempIndex1] << 3 & 0xF8);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[7] = (short)(cbIndex[7] | data[tempIndex1] >> 13 & 7);
            cbIndex[8] = (short)(data[tempIndex1] >> 5 & 0xFF);
            cbIndex[9] = (short)(cbIndex[9] | data[tempIndex1] >> 4 & 1);
            cbIndex[10] = (short)(data[tempIndex1] << 4 & 0xF0);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[10] = (short)(cbIndex[10] | data[tempIndex1] >> 12 & 0xF);
            cbIndex[11] = (short)(data[tempIndex1] >> 4 & 0xFF);
            cbIndex[12] = (short)(cbIndex[12] | data[tempIndex1] >> 3 & 1);
            cbIndex[13] = (short)(data[tempIndex1] << 5 & 0xE0);
            tempIndex1 = (short)(tempIndex1 + 1);
            cbIndex[13] = (short)(cbIndex[13] | data[tempIndex1] >> 11 & 0x1F);
            cbIndex[14] = (short)(data[tempIndex1] >> 3 & 0xFF);
            gainIndex[3] = (short)(gainIndex[3] | data[tempIndex1] >> 1 & 3);
            gainIndex[4] = (short)(gainIndex[4] | data[tempIndex1] & 1);
            tempIndex1 = (short)(tempIndex1 + 1);
            gainIndex[5] = (short)(data[tempIndex1] >> 13 & 7);
            gainIndex[6] = (short)(gainIndex[6] | data[tempIndex1] >> 10 & 7);
            gainIndex[7] = (short)(gainIndex[7] | data[tempIndex1] >> 8 & 3);
            gainIndex[8] = (short)(data[tempIndex1] >> 5 & 7);
            gainIndex[9] = (short)(gainIndex[9] | data[tempIndex1] >> 1 & 0xF);
            gainIndex[10] = (short)(gainIndex[10] | data[tempIndex1] << 2 & 4);
            tempIndex1 = (short)(tempIndex1 + 1);
            gainIndex[10] = (short)(gainIndex[10] | data[tempIndex1] >> 14 & 3);
            gainIndex[11] = (short)(data[tempIndex1] >> 11 & 7);
            gainIndex[12] = (short)(gainIndex[12] | data[tempIndex1] >> 7 & 0xF);
            gainIndex[13] = (short)(gainIndex[13] | data[tempIndex1] >> 4 & 7);
            gainIndex[14] = (short)(data[tempIndex1] >> 1 & 7);
        }
    }

    public static void updateDecIndex(EncoderBits encoderBits) {
        short[] index = encoderBits.getCbIndex();
        for (int k = 4; k < 6; ++k) {
            if (index[k] >= 44 && index[k] < 108) {
                int n = k;
                index[n] = (short)(index[n] + 64);
                continue;
            }
            if (index[k] < 108 || index[k] >= 128) continue;
            int n = k;
            index[n] = (short)(index[n] + 128);
        }
    }

    public static void simpleLsfDeq(short[] lsfDeq, int lsfDeqIndex, short[] index, int indexIndex, int lpcN) {
        int j;
        int i;
        short cbIndex = 0;
        for (i = 0; i < 3; ++i) {
            cbIndex = Constants.LSF_INDEX_CB[i];
            for (j = 0; j < Constants.LSF_DIM_CB[i]; ++j) {
                lsfDeq[lsfDeqIndex++] = Constants.LSF_CB[cbIndex + index[indexIndex] * Constants.LSF_DIM_CB[i] + j];
            }
            ++indexIndex;
        }
        if (lpcN > 1) {
            for (i = 0; i < 3; ++i) {
                cbIndex = Constants.LSF_INDEX_CB[i];
                for (j = 0; j < Constants.LSF_DIM_CB[i]; ++j) {
                    lsfDeq[lsfDeqIndex++] = Constants.LSF_CB[cbIndex + index[indexIndex] * Constants.LSF_DIM_CB[i] + j];
                }
                ++indexIndex;
            }
        }
    }

    public static void decoderInterpolateLsf(DecoderState decoderState, short[] syntDenum, int syntDenumIndex, short[] weightDenum, int weightDenumIndex, short[] lsfDeq, int lsfDeqIndex, short length) {
        short[] lp = new short[11];
        int len = length + 1;
        if (decoderState.DECODER_MODE == 30) {
            CodingFunctions.lspInterpolate2PolyDec(lp, 0, decoderState.getLsfDeqOld(), 0, lsfDeq, lsfDeqIndex, Constants.LSF_WEIGHT_30MS[0], length);
            System.arraycopy(lp, 0, syntDenum, syntDenumIndex, len);
            BasicFunctions.expand(weightDenum, weightDenumIndex, lp, 0, Constants.LPC_CHIRP_SYNT_DENUM, len);
            for (short s = 1; s < decoderState.SUBFRAMES; s = (short)(s + 1)) {
                CodingFunctions.lspInterpolate2PolyDec(lp, 0, lsfDeq, lsfDeqIndex, lsfDeq, lsfDeqIndex + length, Constants.LSF_WEIGHT_30MS[s], length);
                System.arraycopy(lp, 0, syntDenum, syntDenumIndex += len, len);
                BasicFunctions.expand(weightDenum, weightDenumIndex += len, lp, 0, Constants.LPC_CHIRP_SYNT_DENUM, len);
            }
        } else {
            for (short s = 0; s < decoderState.SUBFRAMES; s = (short)(s + 1)) {
                CodingFunctions.lspInterpolate2PolyDec(lp, 0, decoderState.getLsfDeqOld(), 0, lsfDeq, lsfDeqIndex, Constants.LSF_WEIGHT_20MS[s], length);
                System.arraycopy(lp, 0, syntDenum, syntDenumIndex, len);
                BasicFunctions.expand(weightDenum, weightDenumIndex, lp, 0, Constants.LPC_CHIRP_SYNT_DENUM, len);
                syntDenumIndex += len;
                weightDenumIndex += len;
            }
        }
        if (decoderState.DECODER_MODE == 30) {
            System.arraycopy(lsfDeq, lsfDeqIndex + length, decoderState.getLsfDeqOld(), 0, length);
        } else {
            System.arraycopy(lsfDeq, lsfDeqIndex, decoderState.getLsfDeqOld(), 0, length);
        }
    }

    public static void lspInterpolate2PolyDec(short[] a, int aIndex, short[] lsf1, int lsf1Index, short[] lsf2, int lsf2Index, short coef, int length) {
        short[] lsfTemp = new short[10];
        CodingFunctions.interpolate(lsfTemp, 0, lsf1, lsf1Index, lsf2, lsf2Index, coef, length);
        CodingFunctions.lsf2Poly(a, aIndex, lsfTemp, 0);
    }

    public static void decodeResidual(DecoderState decoderState, EncoderBits encoderBits, short[] decResidual, int decResidualIndex, short[] syntDenum, int syntDenumIndex) {
        int nBack;
        int subFrame;
        int memlGotten;
        int i;
        short[] reverseDecresidual = decoderState.getEnhancementBuffer();
        short[] memVec = decoderState.getPrevResidual();
        short diff = (short)(80 - decoderState.STATE_SHORT_LEN);
        short startPos = encoderBits.getStateFirst() ? (short)((encoderBits.getStartIdx() - 1) * 40) : (short)((encoderBits.getStartIdx() - 1) * 40 + diff);
        CodingFunctions.stateConstruct(encoderBits, syntDenum, syntDenumIndex + (encoderBits.getStartIdx() - 1) * 11, decResidual, decResidualIndex + startPos, decoderState.STATE_SHORT_LEN);
        if (encoderBits.getStateFirst()) {
            for (i = 4; i < 151 - decoderState.STATE_SHORT_LEN; ++i) {
                memVec[i] = 0;
            }
            System.arraycopy(decResidual, startPos, memVec, 151 - decoderState.STATE_SHORT_LEN, decoderState.STATE_SHORT_LEN);
            CodingFunctions.cbConstruct(encoderBits, decResidual, decResidualIndex + startPos + decoderState.STATE_SHORT_LEN, memVec, 66, (short)85, diff, 0, 0);
        } else {
            memlGotten = decoderState.STATE_SHORT_LEN;
            BasicFunctions.reverseCopy(memVec, 150, decResidual, decResidualIndex + startPos, memlGotten);
            for (i = 4; i < 151 - memlGotten; ++i) {
                memVec[i] = 0;
            }
            CodingFunctions.cbConstruct(encoderBits, reverseDecresidual, 0, memVec, 66, (short)85, diff, 0, 0);
            BasicFunctions.reverseCopy(decResidual, decResidualIndex + startPos - 1, reverseDecresidual, 0, diff);
        }
        int subCount = 1;
        int nFor = decoderState.SUBFRAMES - encoderBits.getStartIdx() - 1;
        if (nFor > 0) {
            for (i = 4; i < 71; ++i) {
                memVec[i] = 0;
            }
            System.arraycopy(decResidual, decResidualIndex + 40 * (encoderBits.getStartIdx() - 1), memVec, 71, 80);
            for (subFrame = 0; subFrame < nFor; ++subFrame) {
                CodingFunctions.cbConstruct(encoderBits, decResidual, decResidualIndex + 40 * (encoderBits.getStartIdx() + 1 + subFrame), memVec, 4, (short)147, (short)40, subCount * 3, subCount * 3);
                for (i = 4; i < 111; ++i) {
                    memVec[i] = memVec[i + 40];
                }
                System.arraycopy(decResidual, decResidualIndex + 40 * (encoderBits.getStartIdx() + 1 + subFrame), memVec, 111, 40);
                ++subCount;
            }
        }
        if ((nBack = (int)(encoderBits.getStartIdx() - 1)) > 0) {
            memlGotten = (short)(40 * (decoderState.SUBFRAMES + 1 - encoderBits.getStartIdx()));
            if (memlGotten > 147) {
                memlGotten = 147;
            }
            BasicFunctions.reverseCopy(memVec, 150, decResidual, decResidualIndex + 40 * (encoderBits.getStartIdx() - 1), memlGotten);
            for (i = 4; i < 151 - memlGotten; ++i) {
                memVec[i] = 0;
            }
            for (subFrame = 0; subFrame < nBack; ++subFrame) {
                CodingFunctions.cbConstruct(encoderBits, reverseDecresidual, 40 * subFrame, memVec, 4, (short)147, (short)40, subCount * 3, subCount * 3);
                for (i = 4; i < 111; ++i) {
                    memVec[i] = memVec[i + 40];
                }
                System.arraycopy(reverseDecresidual, 40 * subFrame, memVec, 111, 40);
                ++subCount;
            }
            BasicFunctions.reverseCopy(decResidual, decResidualIndex + 40 * nBack - 1, reverseDecresidual, 0, 40 * nBack);
        }
    }

    public static int xCorrCoef(short[] target, int targetIndex, short[] regressor, int regressorIndex, short subl, short searchLen, short offset, short step) {
        int tempIndex2;
        int tempIndex1;
        short max;
        int energyModMax = Short.MAX_VALUE;
        int totScaleMax = -500;
        short crossCorrSqModMax = 0;
        short maxLag = 0;
        int pos = 0;
        if (step == 1) {
            max = BasicFunctions.getMaxAbsValue(regressor, regressorIndex, subl + searchLen - 1);
            tempIndex1 = regressorIndex;
            tempIndex2 = regressorIndex + subl;
        } else {
            max = BasicFunctions.getMaxAbsValue(regressor, regressorIndex - searchLen, subl + searchLen - 1);
            tempIndex1 = regressorIndex - 1;
            tempIndex2 = regressorIndex + subl - 1;
        }
        int shifts = max > 5000 ? 2 : 0;
        int energy = BasicFunctions.scaleRight(regressor, regressorIndex, regressor, regressorIndex, subl, shifts);
        for (int k = 0; k < searchLen; ++k) {
            int tempIndex3 = targetIndex;
            int tempIndex4 = regressorIndex + pos;
            int crossCorr = BasicFunctions.scaleRight(target, tempIndex3, regressor, tempIndex4, subl, shifts);
            if (energy > 0 && crossCorr > 0) {
                int maxCrit;
                int newCrit;
                short crossCorrScale = (short)(BasicFunctions.norm(crossCorr) - 16);
                short crossCorrMod = crossCorrScale > 0 ? (short)(crossCorr << crossCorrScale) : (short)(crossCorr >> 0 - crossCorrScale);
                short energyScale = (short)(BasicFunctions.norm(energy) - 16);
                short energyMod = energyScale > 0 ? (short)(energy << energyScale) : (short)(energy >> 0 - energyScale);
                short crossCorrSqMod = (short)(crossCorrMod * crossCorrMod >> 16);
                short totScale = (short)(energyScale - (crossCorrScale << 1));
                int scaleDiff = totScale - totScaleMax;
                if (scaleDiff > 31) {
                    scaleDiff = 31;
                } else if (scaleDiff < -31) {
                    scaleDiff = -31;
                }
                if (scaleDiff < 0) {
                    newCrit = crossCorrSqMod * energyModMax >> -scaleDiff;
                    maxCrit = crossCorrSqModMax * energyMod;
                } else {
                    newCrit = crossCorrSqMod * energyModMax;
                    maxCrit = crossCorrSqModMax * energyMod >> scaleDiff;
                }
                if (newCrit > maxCrit) {
                    crossCorrSqModMax = crossCorrSqMod;
                    energyModMax = energyMod;
                    totScaleMax = totScale;
                    maxLag = (short)k;
                }
            }
            pos += step;
            int temp = regressor[tempIndex2] * regressor[tempIndex2] - regressor[tempIndex1] * regressor[tempIndex1];
            energy += step * (temp >>= shifts);
            tempIndex1 += step;
            tempIndex2 += step;
        }
        return maxLag + offset;
    }

    public static void doThePlc(DecoderState decoderState, short[] plcResidual, int plcResidualIndex, short[] plcLpc, int plcLpcIndex, short pli, short[] decResidual, int decResidualIndex, short[] lpc, int lpcIndex, short inLag) {
        short[] randVec = new short[240];
        CorrData tempCorrData = new CorrData();
        CorrData corrData = new CorrData();
        tempCorrData.setEnergy(0);
        if (pli == 1) {
            int i;
            int temp;
            int pitchFact;
            short maxPerSquare;
            int tempShift;
            short lag;
            decoderState.setConsPliCount(decoderState.getConsPliCount() + 1);
            if (decoderState.getPrevPli() != 1) {
                int tempS2;
                int tempS;
                short crossSquareMax;
                short max = BasicFunctions.getMaxAbsValue(decoderState.getPrevResidual(), 0, decoderState.SIZE);
                short scale = (short)((BasicFunctions.getSize(max) << 1) - 25);
                if (scale < 0) {
                    scale = 0;
                }
                decoderState.setPrevScale(scale);
                lag = (short)(inLag - 3);
                short corrLen = 60 > decoderState.SIZE - inLag - 3 ? (short)60 : (short)((short)(decoderState.SIZE - inLag - 3));
                CodingFunctions.compCorr(corrData, decoderState.getPrevResidual(), 0, lag, decoderState.SIZE, corrLen, scale);
                short shiftMax = (short)(BasicFunctions.getSize(Math.abs(corrData.getCorrelation())) - 15);
                if (shiftMax > 0) {
                    tempShift = corrData.getCorrelation() >> shiftMax;
                    tempShift *= tempShift;
                    crossSquareMax = (short)(tempShift >> 15);
                } else {
                    tempShift = corrData.getCorrelation() << 0 - shiftMax;
                    tempShift *= tempShift;
                    crossSquareMax = (short)(tempShift >> 15);
                }
                for (int j = inLag - 2; j <= inLag + 3; ++j) {
                    short crossSquare;
                    CodingFunctions.compCorr(tempCorrData, decoderState.getPrevResidual(), 0, (short)j, decoderState.SIZE, corrLen, scale);
                    short shift1 = BasicFunctions.getSize(Math.abs(tempCorrData.getCorrelation()) - 15);
                    if (shift1 > 0) {
                        tempShift = tempCorrData.getCorrelation() >> shift1;
                        tempShift *= tempShift;
                        crossSquare = (short)(tempShift >> 15);
                    } else {
                        tempShift = tempCorrData.getCorrelation() << 0 - shift1;
                        tempShift *= tempShift;
                        crossSquare = (short)(tempShift >> 15);
                    }
                    short shift2 = (short)(BasicFunctions.getSize(corrData.getEnergy()) - 15);
                    int measure = shift2 > 0 ? (corrData.getEnergy() >> shift2) * crossSquare : (corrData.getEnergy() << 0 - shift2) * crossSquare;
                    short shift3 = (short)(BasicFunctions.getSize(tempCorrData.getEnergy()) - 15);
                    int maxMeasure = shift3 > 0 ? (tempCorrData.getEnergy() >> shift3) * crossSquareMax : (tempCorrData.getEnergy() << 0 - shift3) * crossSquareMax;
                    if ((shiftMax << 1) + shift3 > (shift1 << 1) + shift2) {
                        tempShift = shiftMax << 1;
                        tempShift -= shift1 << 1;
                        tempS = (tempShift = tempShift + shift3 - shift2) > 31 ? 31 : (int)((short)tempShift);
                        tempS2 = 0;
                    } else {
                        tempS = 0;
                        tempShift = shift1 << 1;
                        tempShift -= shiftMax << 1;
                        tempS2 = (tempShift = tempShift + shift2 - shift3) > 31 ? 31 : (int)((short)tempShift);
                    }
                    if (measure >> tempS <= maxMeasure >> tempS2) continue;
                    lag = (short)j;
                    crossSquareMax = crossSquare;
                    corrData.setCorrelation(tempCorrData.getCorrelation());
                    shiftMax = shift1;
                    corrData.setEnergy(tempCorrData.getEnergy());
                }
                int temp2 = BasicFunctions.scaleRight(decoderState.getPrevResidual(), decoderState.SIZE - corrLen, decoderState.getPrevResidual(), decoderState.SIZE - corrLen, corrLen, scale);
                if (temp2 > 0 && tempCorrData.getEnergy() > 0) {
                    short scale1 = (short)(BasicFunctions.norm(temp2) - 16);
                    tempS = scale1 > 0 ? (int)(temp2 << scale1) : (short)(temp2 >> 0 - scale1);
                    short scale2 = (short)(BasicFunctions.norm(corrData.getEnergy()) - 16);
                    tempS2 = scale2 > 0 ? (int)(corrData.getEnergy() << scale2) : (short)(corrData.getEnergy() >> 0 - scale2);
                    short denom = (short)(tempS * tempS2 >> 16);
                    short totScale = (short)(scale1 + scale2 - 1);
                    tempShift = totScale >> 1;
                    tempS = tempShift > 0 ? (short)(corrData.getCorrelation() << tempShift) : (short)(corrData.getCorrelation() >> 0 - tempShift);
                    tempShift = totScale - tempShift;
                    tempS2 = tempShift > 0 ? (short)(corrData.getCorrelation() << tempShift) : (short)(corrData.getCorrelation() >> 0 - tempShift);
                    short nom = (short)(tempS * tempS2);
                    maxPerSquare = (short)(nom / denom);
                } else {
                    maxPerSquare = 0;
                }
            } else {
                lag = decoderState.getPrevLag();
                maxPerSquare = decoderState.getPerSquare();
            }
            int useGain = Short.MAX_VALUE;
            if (decoderState.getConsPliCount() * decoderState.SIZE > 320) {
                useGain = 29491;
            } else if (decoderState.getConsPliCount() * decoderState.SIZE > 640) {
                useGain = 22938;
            } else if (decoderState.getConsPliCount() * decoderState.SIZE > 960) {
                useGain = 16384;
            } else if (decoderState.getConsPliCount() * decoderState.SIZE > 1280) {
                useGain = 0;
            }
            if (maxPerSquare > 7868) {
                pitchFact = Short.MAX_VALUE;
            } else if (maxPerSquare > 839) {
                int ind;
                for (ind = 5; maxPerSquare < Constants.PLC_PER_SQR[ind] && ind > 0; --ind) {
                }
                temp = Constants.PLC_PITCH_FACT[ind];
                pitchFact = (temp += Constants.PLC_PF_SLOPE[ind] * (maxPerSquare - Constants.PLC_PER_SQR[ind]) >> 11) > Short.MIN_VALUE ? Short.MIN_VALUE : (int)((short)temp);
            } else {
                pitchFact = 0;
            }
            short useLag = lag;
            if (lag < 80) {
                useLag = (short)(2 * lag);
            }
            int energy = 0;
            for (i = 0; i < decoderState.SIZE; ++i) {
                decoderState.setSeed((short)(decoderState.getSeed() * 31821 + 13849));
                short randLag = (short)(53 + (decoderState.getSeed() & 0x3F));
                short pick = (short)(i - randLag);
                randVec[i] = pick < 0 ? decoderState.getPrevResidual()[decoderState.SIZE + pick] : decoderState.getPrevResidual()[pick];
                pick = (short)(i - useLag);
                plcResidual[plcResidualIndex + i] = pick < 0 ? decoderState.getPrevResidual()[decoderState.SIZE + pick] : plcResidual[plcResidualIndex + pick];
                int totGain = i < 80 ? useGain : (i < 160 ? (int)((short)(31130 * useGain >> 15)) : (int)((short)(29491 * useGain >> 15)));
                tempShift = pitchFact * plcResidual[plcResidualIndex + i];
                tempShift += (Short.MAX_VALUE - pitchFact) * randVec[i];
                temp = (short)((tempShift += 16384) >> 15);
                plcResidual[plcResidualIndex + i] = (short)(totGain * temp >> 15);
                tempShift = plcResidual[plcResidualIndex + i] * plcResidual[plcResidualIndex + i];
                energy += (short)(tempShift >> decoderState.getPrevScale() + 1);
            }
            tempShift = decoderState.SIZE * 900;
            tempShift = decoderState.getPrevScale() + 1 > 0 ? (tempShift >>= decoderState.getPrevScale() + 1) : (tempShift <<= 0 - decoderState.getPrevScale() - 1);
            if (energy < tempShift) {
                energy = 0;
                for (i = 0; i < decoderState.SIZE; ++i) {
                    plcResidual[plcResidualIndex + i] = randVec[i];
                }
            }
            System.arraycopy(decoderState.getPrevLpc(), 0, plcLpc, plcLpcIndex, 10);
            decoderState.setPrevLag(lag);
            decoderState.setPerSquare(maxPerSquare);
        } else {
            System.arraycopy(decResidual, decResidualIndex, plcResidual, plcResidualIndex, decoderState.SIZE);
            System.arraycopy(lpc, lpcIndex, plcLpc, plcLpcIndex, 11);
            decoderState.setConsPliCount(0);
        }
        decoderState.setPrevPli(pli);
        System.arraycopy(plcLpc, plcLpcIndex, decoderState.getPrevLpc(), 0, 11);
        System.arraycopy(plcResidual, plcResidualIndex, decoderState.getPrevResidual(), 0, decoderState.SIZE);
    }

    public static void compCorr(CorrData currData, short[] buffer, int bufferIndex, short lag, short bLen, short sRange, short scale) {
        int currIndex = bLen - sRange - lag;
        if (scale > 0) {
            currData.setCorrelation(BasicFunctions.scaleRight(buffer, bufferIndex + bLen - sRange, buffer, currIndex, sRange, scale));
            currData.setEnergy(BasicFunctions.scaleRight(buffer, currIndex, buffer, currIndex, sRange, scale));
        } else {
            currData.setCorrelation(BasicFunctions.scaleLeft(buffer, bufferIndex + bLen - sRange, buffer, currIndex, sRange, 0 - scale));
            currData.setEnergy(BasicFunctions.scaleLeft(buffer, currIndex, buffer, currIndex, sRange, scale));
        }
        if (currData.getCorrelation() == 0) {
            currData.setCorrelation(0);
            currData.setEnergy(1);
        }
    }
}

