/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.tts;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import naturalvoices.ClientPlayer;
import naturalvoices.Player;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.cache.HashGenerator;
import org.mobicents.servlet.restcomm.tts.api.GetSpeechSynthesizerInfo;
import org.mobicents.servlet.restcomm.tts.api.SpeechSynthesizerException;
import org.mobicents.servlet.restcomm.tts.api.SpeechSynthesizerInfo;
import org.mobicents.servlet.restcomm.tts.api.SpeechSynthesizerRequest;
import org.mobicents.servlet.restcomm.tts.api.SpeechSynthesizerResponse;

public final class AttSpeechSynthesizer
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final Map<String, String> men = new ConcurrentHashMap<String, String>();
    private final Map<String, String> women = new ConcurrentHashMap<String, String>();
    private final String rootDir;
    private final Player player;

    public AttSpeechSynthesizer(Configuration configuration) {
        this.load(configuration);
        this.rootDir = configuration.getString("tts-client-directory");
        this.player = new ClientPlayer(this.rootDir, configuration.getString("host"), configuration.getInt("port", 7000));
        this.player.Verbose = configuration.getBoolean("verbose-output", false);
    }

    public void onReceive(Object message) throws Exception {
        block6: {
            Class<?> klass = message.getClass();
            ActorRef self = this.self();
            ActorRef sender = this.sender();
            if (SpeechSynthesizerRequest.class.equals(klass)) {
                try {
                    URI uri = this.synthesize(message);
                    if (sender != null) {
                        sender.tell((Object)new SpeechSynthesizerResponse((Object)uri), self);
                    }
                    break block6;
                }
                catch (Exception exception) {
                    this.logger.error("There was an exception while trying to synthesize message: " + exception);
                    if (sender != null) {
                        sender.tell((Object)new SpeechSynthesizerResponse((Throwable)exception), self);
                    }
                    break block6;
                }
            }
            if (GetSpeechSynthesizerInfo.class.equals(klass)) {
                sender.tell((Object)new SpeechSynthesizerResponse((Object)this.info()), self);
            }
        }
    }

    private SpeechSynthesizerInfo info() {
        return new SpeechSynthesizerInfo(this.men.keySet());
    }

    private void load(Configuration configuration) throws RuntimeException {
        this.women.put("en", configuration.getString("speakers.english.female"));
        this.women.put("en-uk", configuration.getString("speakers.english-uk.female"));
        this.women.put("es", configuration.getString("speakers.spanish.female"));
        this.women.put("fr", configuration.getString("speakers.french.female"));
        this.women.put("de-de", configuration.getString("speakers.german.female"));
        this.women.put("it-it", configuration.getString("speakers.italian.female"));
        this.women.put("pt-br", configuration.getString("speakers.brazilian-portuguese.female"));
        this.men.put("en", configuration.getString("speakers.english.male"));
        this.men.put("en-uk", configuration.getString("speakers.english-uk.male"));
        this.men.put("es", configuration.getString("speakers.spanish.male"));
        this.men.put("fr", configuration.getString("speakers.french.male"));
        this.men.put("fr-ca", configuration.getString("speakers.canadian-french.male"));
        this.men.put("de", configuration.getString("speakers.german.male"));
        this.men.put("it", configuration.getString("speakers.italian.male"));
        this.men.put("pt-br", configuration.getString("speakers.brazilian-portuguese.male"));
    }

    private URI synthesize(Object message) throws IOException, SpeechSynthesizerException {
        SpeechSynthesizerRequest request = (SpeechSynthesizerRequest)message;
        String gender = request.gender();
        String language = request.language();
        String text = request.text();
        if (language == null) {
            this.logger.info("There is no suitable speaker to synthesize " + request.language());
            throw new IllegalArgumentException("There is no suitable language to synthesize " + request.language());
        }
        String hash = HashGenerator.hashMessage((String)gender, (String)language, (String)text);
        if (gender.equalsIgnoreCase("man")) {
            this.player.setVoice(this.men.get(language));
        } else {
            this.player.setVoice(this.women.get(language));
        }
        this.player.setLatin1(Boolean.valueOf(true));
        this.player.setSourceText(text);
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + hash + ".wav");
        this.player.Convert(file.getAbsolutePath());
        if (file.exists()) {
            return file.toURI();
        }
        this.logger.info("There was a problem with AT&T TTS server. Check configuration and that TTS Server is running");
        throw new SpeechSynthesizerException("There was a problem with TTSClientFile. Check configuration and that TTS Server is running");
    }
}

