/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.network.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;
import org.mobicents.media.server.io.network.channel.PacketHandlerPipeline;

public class NioServer {
    private static final Logger logger = Logger.getLogger(NioServer.class);
    private static final int MAX_BUFFER_SIZE = 8192;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
    private final PacketHandlerPipeline packetHandlers = new PacketHandlerPipeline();
    private boolean running = false;
    protected DatagramChannel currentChannel;
    private Selector selector;
    private final Worker worker = new Worker();
    private Thread workerThread;

    public boolean isRunning() {
        return this.running;
    }

    public boolean addPacketHandler(PacketHandler handler) {
        return this.packetHandlers.addHandler(handler);
    }

    private byte[] getBufferedData(int dataLength) {
        byte[] data = new byte[dataLength];
        this.buffer.rewind();
        this.buffer.get(data, 0, dataLength);
        return data;
    }

    private int receive(DatagramChannel channel, ByteBuffer buffer) {
        int dataLength = 0;
        try {
            buffer.clear();
            SocketAddress remotePeer = channel.receive(buffer);
            if (!channel.isConnected() && remotePeer != null) {
                channel.connect(remotePeer);
            }
            dataLength = this.buffer.position();
        }
        catch (IOException e) {
            logger.error((Object)("Could not receive data: " + e.getMessage()), (Throwable)e);
            dataLength = -1;
        }
        return dataLength;
    }

    private int send(DatagramChannel channel, byte[] data, ByteBuffer buffer) {
        buffer.clear();
        buffer.put(data).flip();
        int dataLength = 0;
        try {
            dataLength = channel.send(buffer, channel.getRemoteAddress());
        }
        catch (IOException e) {
            logger.error((Object)("Could not send data: " + e.getMessage()), (Throwable)e);
            dataLength = -1;
        }
        return dataLength;
    }

    public void start(Selector selector) {
        if (!this.running) {
            logger.info((Object)"Started NIO Server");
            this.running = true;
            this.selector = selector;
            this.workerThread = new Thread(this.worker);
            this.workerThread.start();
        }
    }

    public void stop() {
        if (this.running) {
            logger.info((Object)"Stopping NIO Server...");
            this.running = false;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            while (NioServer.this.running && NioServer.this.selector.isOpen()) {
                try {
                    NioServer.this.selector.selectNow();
                    Iterator<SelectionKey> keys = NioServer.this.selector.selectedKeys().iterator();
                    while (keys.hasNext()) {
                        SelectionKey key = keys.next();
                        keys.remove();
                        NioServer.this.currentChannel = (DatagramChannel)key.channel();
                        int dataLength = NioServer.this.receive(NioServer.this.currentChannel, NioServer.this.buffer);
                        if (dataLength < 0) {
                            try {
                                NioServer.this.currentChannel.close();
                            }
                            catch (IOException e) {
                                logger.error((Object)("Could not close defective channel: " + e.getMessage()), (Throwable)e);
                            }
                            continue;
                        }
                        if (dataLength <= 0) continue;
                        byte[] data = NioServer.this.getBufferedData(dataLength);
                        PacketHandler handler = NioServer.this.packetHandlers.getHandler(data);
                        if (handler != null) {
                            try {
                                byte[] response = handler.handle(data, (InetSocketAddress)NioServer.this.currentChannel.getLocalAddress(), (InetSocketAddress)NioServer.this.currentChannel.getRemoteAddress());
                                if (response == null || !key.isWritable()) continue;
                                NioServer.this.send(NioServer.this.currentChannel, response, NioServer.this.buffer);
                            }
                            catch (PacketHandlerException e) {
                                logger.error((Object)"Could not process incoming packet. Packet will be dropped.");
                            }
                            continue;
                        }
                        logger.warn((Object)"No handler found to process incoming packet. Packet will be dropped.");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Could not select keys: " + e.getMessage()), (Throwable)e);
                }
            }
            if (NioServer.this.selector.isOpen()) {
                try {
                    NioServer.this.selector.close();
                }
                catch (IOException e) {
                    logger.error((Object)("Could not close selector: " + e.getMessage()), (Throwable)e);
                }
            }
            NioServer.this.currentChannel = null;
            NioServer.this.selector = null;
            logger.info((Object)"NIO Server stopped");
        }
    }
}

