/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.network.channel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.mobicents.media.server.io.network.channel.PacketHandler;

public class PacketHandlerPipeline {
    private static final Comparator<PacketHandler> REVERSE_COMPARATOR = new Comparator<PacketHandler>(){

        @Override
        public int compare(PacketHandler o1, PacketHandler o2) {
            return o2.compareTo(o1);
        }
    };
    private final List<PacketHandler> handlers = new ArrayList<PacketHandler>(5);
    private int count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHandler(PacketHandler handler) {
        List<PacketHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.contains(handler)) {
                this.handlers.add(handler);
                ++this.count;
                Collections.sort(this.handlers, REVERSE_COMPARATOR);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHandler(PacketHandler handler) {
        List<PacketHandler> list = this.handlers;
        synchronized (list) {
            boolean removed = this.handlers.remove(handler);
            if (removed) {
                --this.count;
            }
            return removed;
        }
    }

    public int count() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(PacketHandler handler) {
        List<PacketHandler> list = this.handlers;
        synchronized (list) {
            return this.handlers.contains(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketHandler getHandler(byte[] packet) {
        ArrayList<PacketHandler> handlersCopy;
        List<PacketHandler> list = this.handlers;
        synchronized (list) {
            handlersCopy = new ArrayList<PacketHandler>(this.handlers);
        }
        for (PacketHandler protocolHandler : handlersCopy) {
            if (!protocolHandler.canHandle(packet)) continue;
            return protocolHandler;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PacketHandler> getHandlers() {
        List<PacketHandler> list = this.handlers;
        synchronized (list) {
            return new ArrayList<PacketHandler>(this.handlers);
        }
    }
}

