/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.network.IPAddressCompare;
import org.mobicents.media.server.io.network.IPAddressType;
import org.mobicents.media.server.io.network.PortManager;
import org.mobicents.media.server.io.network.ProtocolHandler;
import org.mobicents.media.server.io.network.channel.Channel;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;

public class UdpManager {
    private static final int PORT_ANY = -1;
    private List<Selector> selectors;
    private String bindAddress = "127.0.0.1";
    private String localBindAddress = "127.0.0.1";
    private String externalAddress = "";
    private byte[] localNetwork;
    private IPAddressType currNetworkType;
    private byte[] localSubnet;
    private IPAddressType currSubnetType;
    private Boolean useSbc = false;
    private int rtpTimeout = 0;
    private PortManager portManager = new PortManager();
    private PortManager localPortManager = new PortManager();
    private List<PollTask> pollTasks;
    private volatile boolean isActive;
    private volatile int count;
    private String name = "unknown";
    private Scheduler scheduler;
    private static final Logger logger = Logger.getLogger(UdpManager.class);
    private final Object LOCK = new Object();
    private AtomicInteger currSelectorIndex = new AtomicInteger(0);

    public UdpManager(Scheduler scheduler) throws IOException {
        this.scheduler = scheduler;
        this.selectors = new ArrayList<Selector>(scheduler.getPoolSize());
        this.pollTasks = new ArrayList<PollTask>(scheduler.getPoolSize());
        for (int i = 0; i < scheduler.getPoolSize(); ++i) {
            this.selectors.add(SelectorProvider.provider().openSelector());
            this.pollTasks.add(new PollTask(this.selectors.get(i)));
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setBindAddress(String address) {
        this.bindAddress = address;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setLocalBindAddress(String address) {
        this.localBindAddress = address;
    }

    public String getLocalBindAddress() {
        return this.localBindAddress;
    }

    public String getExternalAddress() {
        return this.externalAddress;
    }

    public void setExternalAddress(String externalAddress) {
        this.externalAddress = externalAddress;
    }

    public void setRtpTimeout(int rtpTimeout) {
        this.rtpTimeout = rtpTimeout;
    }

    public int getRtpTimeout() {
        return this.rtpTimeout;
    }

    public void setLocalNetwork(String localNetwork) {
        IPAddressType currNetworkType;
        this.currNetworkType = currNetworkType = IPAddressCompare.getAddressType(localNetwork);
        if (currNetworkType == IPAddressType.IPV4) {
            this.localNetwork = IPAddressCompare.addressToByteArrayV4(localNetwork);
        } else if (currNetworkType == IPAddressType.IPV6) {
            this.localNetwork = IPAddressCompare.addressToByteArrayV6(localNetwork);
        }
    }

    public void setLocalSubnet(String localSubnet) {
        IPAddressType currSubnetType;
        this.currSubnetType = currSubnetType = IPAddressCompare.getAddressType(localSubnet);
        if (currSubnetType == IPAddressType.IPV4) {
            this.localSubnet = IPAddressCompare.addressToByteArrayV4(localSubnet);
        } else if (currSubnetType == IPAddressType.IPV6) {
            this.localSubnet = IPAddressCompare.addressToByteArrayV6(localSubnet);
        }
    }

    public void setUseSbc(Boolean useSbc) {
        this.useSbc = useSbc;
    }

    public PortManager getPortManager() {
        return this.portManager;
    }

    public void setLowestPort(int low) {
        this.portManager.setLowestPort(low);
    }

    public int getLowestPort() {
        return this.portManager.getLowestPort();
    }

    public void setHighestPort(int high) {
        this.portManager.setHighestPort(high);
    }

    public int getHighestPort() {
        return this.portManager.getLowestPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelector(Selector selector) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.selectors.contains(selector)) {
                this.selectors.add(selector);
                PollTask pollTask = new PollTask(selector);
                this.pollTasks.add(pollTask);
                pollTask.startNow();
            }
        }
    }

    public boolean connectImmediately(InetSocketAddress address) {
        if (!this.useSbc.booleanValue()) {
            return true;
        }
        boolean connectImmediately = false;
        byte[] addressValue = address.getAddress().getAddress();
        if (this.currSubnetType == IPAddressType.IPV4 && this.currNetworkType == IPAddressType.IPV4) {
            if (IPAddressCompare.isInRangeV4(this.localNetwork, this.localSubnet, addressValue)) {
                connectImmediately = true;
            }
        } else if (this.currSubnetType == IPAddressType.IPV6 && this.currNetworkType == IPAddressType.IPV6 && IPAddressCompare.isInRangeV6(this.localNetwork, this.localSubnet, addressValue)) {
            connectImmediately = true;
        }
        return connectImmediately;
    }

    @Deprecated
    public DatagramChannel open(ProtocolHandler handler) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        int index = this.currSelectorIndex.getAndIncrement();
        SelectionKey key = channel.register(this.selectors.get(index % this.selectors.size()), 1);
        key.attach(handler);
        handler.setKey(key);
        return channel;
    }

    public SelectionKey open(Channel channel) throws IOException {
        DatagramChannel dataChannel = DatagramChannel.open();
        dataChannel.configureBlocking(false);
        int index = this.currSelectorIndex.getAndIncrement();
        SelectionKey key = dataChannel.register(this.selectors.get(index % this.selectors.size()), 1);
        key.attach(channel);
        return key;
    }

    public SelectionKey open(DatagramChannel dataChannel, Channel channel) throws IOException {
        int index = this.currSelectorIndex.getAndIncrement();
        Selector selector = this.selectors.get(index % this.selectors.size());
        SelectionKey key = dataChannel.register(selector, 1);
        key.attach(channel);
        return key;
    }

    @Deprecated
    public void open(DatagramChannel channel, ProtocolHandler handler) throws IOException {
        int index = this.currSelectorIndex.getAndIncrement();
        Selector selector = this.selectors.get(index % this.selectors.size());
        SelectionKey key = channel.register(selector, 1);
        key.attach(handler);
        handler.setKey(key);
    }

    public void bind(DatagramChannel channel, int port, boolean local) throws SocketException {
        if (local) {
            this.bindLocal(channel, port);
        } else {
            this.bind(channel, port);
        }
    }

    public void bind(DatagramChannel channel, int port) throws SocketException {
        if (port == -1) {
            port = this.portManager.next();
        }
        SocketException ex = null;
        for (int q = 0; q < 100; ++q) {
            try {
                channel.socket().bind(new InetSocketAddress(this.bindAddress, port));
                ex = null;
                break;
            }
            catch (SocketException e) {
                ex = e;
                logger.info((Object)("Failed trying to bind " + this.bindAddress + ":" + port));
                port = this.portManager.next();
                continue;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void bindLocal(DatagramChannel channel, int port) throws SocketException {
        if (port == -1) {
            port = this.localPortManager.next();
        }
        SocketException ex = null;
        for (int q = 0; q < 100; ++q) {
            try {
                channel.socket().bind(new InetSocketAddress(this.localBindAddress, port));
                ex = null;
                break;
            }
            catch (SocketException e) {
                ex = e;
                logger.info((Object)("Failed trying to bind " + this.localBindAddress + ":" + port));
                port = this.localPortManager.next();
                continue;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isActive) {
                return;
            }
            this.isActive = true;
            for (int i = 0; i < this.pollTasks.size(); ++i) {
                this.pollTasks.get(i).startNow();
            }
            logger.info((Object)String.format("Initialized UDP interface[%s]: bind address=%s", this.name, this.bindAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isActive) {
                return;
            }
            this.isActive = false;
            for (int i = 0; i < this.pollTasks.size(); ++i) {
                this.pollTasks.get(i).cancel();
            }
            logger.info((Object)"Stopped");
        }
    }

    private class PollTask
    extends Task {
        private Selector localSelector;

        public PollTask(Selector selector) {
            this.localSelector = selector;
        }

        public int getQueueNumber() {
            return Scheduler.UDP_MANAGER_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (!UdpManager.this.isActive) {
                return 0L;
            }
            try {
                this.localSelector.selectNow();
                Iterator<SelectionKey> it = this.localSelector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    DatagramChannel udpChannel = (DatagramChannel)key.channel();
                    Object attachment = key.attachment();
                    if (attachment == null) continue;
                    if (attachment instanceof ProtocolHandler) {
                        ProtocolHandler handler = (ProtocolHandler)key.attachment();
                        if (!udpChannel.isOpen()) {
                            handler.onClosed();
                            continue;
                        }
                        if (!key.isReadable()) continue;
                        handler.receive(udpChannel);
                        UdpManager.this.count++;
                        continue;
                    }
                    if (!(attachment instanceof Channel)) continue;
                    Channel channel = (Channel)attachment;
                    if (udpChannel.isOpen()) {
                        if (!key.isValid()) continue;
                        channel.receive();
                        UdpManager.this.count++;
                        if (!channel.hasPendingData()) continue;
                        channel.send();
                        UdpManager.this.count++;
                        continue;
                    }
                    channel.close();
                }
                this.localSelector.selectedKeys().clear();
            }
            catch (IOException e) {
                logger.error((Object)e);
                long l = 0L;
                return l;
            }
            finally {
                UdpManager.this.scheduler.submit((Task)this, Scheduler.UDP_MANAGER_QUEUE);
            }
            return 0L;
        }

        public void startNow() {
            UdpManager.this.scheduler.submit((Task)this, Scheduler.UDP_MANAGER_QUEUE);
        }
    }
}

