/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.aesh.cl.internal.OptionInt;

public class ParameterInt {
    private String name;
    private String usage;
    private List<OptionInt> options;

    public ParameterInt(String name, String usage) {
        this.setName(name);
        this.setUsage(usage);
        this.setOptions(new ArrayList<OptionInt>());
    }

    public ParameterInt(String name, String usage, OptionInt[] options) {
        this.setName(name);
        this.setUsage(usage);
        this.setOptions(Arrays.asList(options));
    }

    public ParameterInt(String name, String usage, List<OptionInt> options) {
        this.setName(name);
        this.setUsage(usage);
        this.setOptions(options);
    }

    public List<OptionInt> getOptions() {
        return this.options;
    }

    public void addOption(char name, String longName, String description, boolean hasValue, String argument, boolean required, boolean hasMultipleValues, Object type) {
        this.options.add(new OptionInt(name, longName, description, hasValue, argument, required, '\u0000', false, hasMultipleValues, type));
    }

    private void setOptions(List<OptionInt> options) {
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public OptionInt findOption(String name) {
        for (OptionInt option : this.options) {
            if (option.getName() == null || !option.getName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public OptionInt findLongOption(String name) {
        for (OptionInt option : this.options) {
            if (option.getLongName() == null || !option.getLongName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public OptionInt startWithOption(String name) {
        for (OptionInt option : this.options) {
            if (!name.startsWith(option.getName())) continue;
            return option;
        }
        return null;
    }

    public OptionInt startWithLongOption(String name) {
        for (OptionInt option : this.options) {
            if (!name.startsWith(option.getLongName())) continue;
            return option;
        }
        return null;
    }

    public void clean() {
        for (OptionInt optionInt : this.options) {
            optionInt.clean();
        }
    }
}

