/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;

public class XorOnlyAttribute
extends StunAttribute {
    public static final String NAME = "XOR-ONLY";
    public static final char DATA_LENGTH = '\u0000';

    public XorOnlyAttribute() {
        super('!');
    }

    @Override
    public void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        return binValue;
    }

    @Override
    public char getDataLength() {
        return '\u0000';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XorOnlyAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        XorOnlyAttribute att = (XorOnlyAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength();
    }
}

