/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import java.util.Arrays;
import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;

public class SoftwareAttribute
extends StunAttribute {
    private static final String NAME = "SOFTWARE";
    private byte[] software = null;

    public SoftwareAttribute() {
        super('\u8022');
    }

    public byte[] getSoftware() {
        if (this.software == null) {
            return null;
        }
        byte[] copy = new byte[this.software.length];
        System.arraycopy(this.software, 0, copy, 0, this.software.length);
        return this.software;
    }

    public void setSoftware(byte[] software) {
        if (software == null) {
            this.software = null;
        } else {
            this.software = new byte[software.length];
            System.arraycopy(software, 0, this.software, 0, software.length);
        }
    }

    @Override
    public char getDataLength() {
        if (this.software == null) {
            return '\u0000';
        }
        return (char)this.software.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof SoftwareAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        SoftwareAttribute att = (SoftwareAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.software, this.software);
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + (4 - this.getDataLength() % 4) % 4];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.software, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        this.software = new byte[length];
        System.arraycopy(data, offset, this.software, 0, length);
    }
}

