/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import java.util.Arrays;
import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;

public class RealmAttribute
extends StunAttribute {
    public static final String NAME = "REALM";
    private byte[] realm;

    public RealmAttribute() {
        super('\u0014');
    }

    public byte[] getRealm() {
        if (this.realm == null) {
            return null;
        }
        return (byte[])this.realm.clone();
    }

    public void setRealm(byte[] realm) {
        if (realm == null) {
            this.realm = null;
        } else {
            this.realm = new byte[realm.length];
            System.arraycopy(realm, 0, this.realm, 0, realm.length);
        }
    }

    @Override
    public char getDataLength() {
        return (char)this.realm.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof RealmAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        RealmAttribute att = (RealmAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.realm, this.realm);
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + this.getDataLength() % 4];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.realm, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        this.realm = new byte[length];
        System.arraycopy(data, offset, this.realm, 0, length);
    }
}

