/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;

public class PriorityAttribute
extends StunAttribute {
    private static final String NAME = "PRIORITY";
    private static final char DATA_LENGTH = '\u0004';
    private long priority = 0L;

    public PriorityAttribute() {
        super('$');
    }

    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        if (priority <= 0L || priority > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Priority must be between 0 and (2^31 - 1)");
        }
        this.priority = priority;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof PriorityAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        PriorityAttribute att = (PriorityAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.priority == this.priority;
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[]{(byte)(type >> 8), (byte)(type & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), (byte)((this.priority & 0xFF000000L) >> 24), (byte)((this.priority & 0xFF0000L) >> 16), (byte)((this.priority & 0xFF00L) >> 8), (byte)(this.priority & 0xFFL)};
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        long[] values = new long[4];
        char c = offset;
        offset = (char)(offset + '\u0001');
        values[0] = (data[c] & 0xFF) << 24;
        char c2 = offset;
        offset = (char)(offset + '\u0001');
        values[1] = (data[c2] & 0xFF) << 16;
        char c3 = offset;
        offset = (char)(offset + '\u0001');
        values[2] = (data[c3] & 0xFF) << 8;
        char c4 = offset;
        offset = (char)(offset + '\u0001');
        values[3] = data[c4] & 0xFF;
        this.priority = values[0] | values[1] | values[2] | values[3];
    }
}

