/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import java.util.Arrays;
import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;

public class NonceAttribute
extends StunAttribute {
    public static final String NAME = "NONCE";
    private byte[] nonce = null;

    public NonceAttribute() {
        super('\u0015');
    }

    public byte[] getNonce() {
        if (this.nonce == null) {
            return null;
        }
        return (byte[])this.nonce.clone();
    }

    public void setNonce(byte[] nonce) {
        if (nonce == null) {
            this.nonce = null;
        }
        this.nonce = (byte[])nonce.clone();
    }

    @Override
    public char getDataLength() {
        return (char)this.nonce.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof NonceAttribute)) {
            return false;
        }
        NonceAttribute att = (NonceAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.nonce, this.nonce);
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + this.getDataLength() % 4];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.nonce, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        this.nonce = new byte[length];
        System.arraycopy(data, offset, this.nonce, 0, length);
    }
}

