/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;
import org.mobicents.media.io.stun.messages.attributes.general.ContextDependentAttribute;

public class MessageIntegrityAttribute
extends StunAttribute
implements ContextDependentAttribute {
    public static final String NAME = "MESSAGE_INTEGRITY";
    public static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    public static final char DATA_LENGTH = '\u0014';
    private byte[] hmacSha1Content;
    private String username;
    private String media;
    byte[] key;

    public MessageIntegrityAttribute() {
        super('\b');
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public byte[] getHmacSha1Content() {
        return this.hmacSha1Content;
    }

    public void setHmacSha1Content(byte[] hmacSha1Content) {
        this.hmacSha1Content = hmacSha1Content;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public static byte[] calculateHmacSha1(byte[] message, int offset, int length, byte[] key) throws IllegalArgumentException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] macInput = new byte[length];
            System.arraycopy(message, offset, macInput, 0, length);
            return mac.doFinal(macInput);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not create HMAC-SHA1 request encoding", exc);
        }
    }

    @Override
    public byte[] encode(byte[] data, int offset, int length) {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        char msgType = (char)((data[0] << 8) + data[1]);
        this.hmacSha1Content = MessageIntegrityAttribute.calculateHmacSha1(data, offset, length, this.key);
        System.arraycopy(this.hmacSha1Content, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    public char getDataLength() {
        return '\u0014';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof MessageIntegrityAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        MessageIntegrityAttribute att = (MessageIntegrityAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.hmacSha1Content, this.hmacSha1Content);
    }

    @Override
    public byte[] encode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ContentDependentAttributes should be encoded through the contend-dependent encode method");
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        this.hmacSha1Content = new byte[length];
        System.arraycopy(data, offset, this.hmacSha1Content, 0, length);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(NAME).append(": ");
        builder.append("username=").append(this.username).append(", ");
        builder.append("key=").append(this.key);
        return builder.toString();
    }
}

