/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;

public class LifetimeAttribute
extends StunAttribute {
    public static final String NAME = "LIFETIME";
    public static final char DATA_LENGTH = '\u0004';
    private int lifetime = 0;

    public LifetimeAttribute() {
        super('\r');
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof LifetimeAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        LifetimeAttribute att = (LifetimeAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.lifetime == this.lifetime;
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), (byte)(this.lifetime >> 24 & 0xFF), (byte)(this.lifetime >> 16 & 0xFF), (byte)(this.lifetime >> 8 & 0xFF), (byte)(this.lifetime & 0xFF)};
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("Invalid length:" + length);
        }
        this.lifetime = (data[0] << 24 & 0xFF000000) + (data[1] << 16 & 0xFF0000) + (data[2] << 8 & 0xFF00) + (data[3] & 0xFF);
    }
}

