/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import java.util.zip.CRC32;
import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;
import org.mobicents.media.io.stun.messages.attributes.general.ContextDependentAttribute;

public class FingerprintAttribute
extends StunAttribute
implements ContextDependentAttribute {
    public static final String NAME = "FINGERPRINT";
    private static final char DATA_LENGTH = '\u0004';
    public static final byte[] XOR_MASK = new byte[]{83, 84, 85, 78};
    private byte[] crc;

    public byte[] getChecksum() {
        return this.crc;
    }

    public FingerprintAttribute() {
        super('\u8028');
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof FingerprintAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        FingerprintAttribute att = (FingerprintAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength();
    }

    @Override
    public byte[] encode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This operation is not supported because the FINGERPRINT attribute requires information from a context.");
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("Invalid lenght " + length);
        }
        byte[] incomingCrcBytes = new byte[]{data[offset], data[offset + '\u0001'], data[offset + 2], data[offset + 3]};
        this.crc = incomingCrcBytes;
    }

    @Override
    public byte[] encode(byte[] data, int offset, int length) {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        byte[] xorCrc32 = FingerprintAttribute.calculateXorCRC32(data, offset, length);
        binValue[4] = xorCrc32[0];
        binValue[5] = xorCrc32[1];
        binValue[6] = xorCrc32[2];
        binValue[7] = xorCrc32[3];
        return binValue;
    }

    public static byte[] calculateXorCRC32(byte[] message, int offset, int len) {
        CRC32 checksum = new CRC32();
        checksum.update(message, offset, len);
        long crc = checksum.getValue();
        byte[] xorCRC32 = new byte[]{(byte)((byte)(crc >> 24 & 0xFFL) ^ XOR_MASK[0]), (byte)((byte)(crc >> 16 & 0xFFL) ^ XOR_MASK[1]), (byte)((byte)(crc >> 8 & 0xFFL) ^ XOR_MASK[2]), (byte)((byte)(crc & 0xFFL) ^ XOR_MASK[3])};
        return xorCRC32;
    }
}

