/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;

public class ErrorCodeAttribute
extends StunAttribute {
    public static final String NAME = "ERROR-CODE";
    public static final char BAD_REQUEST = '\u0190';
    public static final char UNAUTHORIZED = '\u0191';
    public static final char UNKNOWN_ATTRIBUTE = '\u01a4';
    public static final char STALE_CREDENTIALS = '\u01ae';
    public static final char INTEGRITY_CHECK_FAILURE = '\u01af';
    public static final char MISSING_USERNAME = '\u01b0';
    public static final char USE_TLS = '\u01b1';
    public static final char ROLE_CONFLICT = '\u01e7';
    public static final char SERVER_ERROR = '\u01f4';
    public static final char GLOBAL_FAILURE = '\u0258';
    private static final int ERROR_CODE_DIGITS = 4;
    private byte errorClass = 0;
    private byte errorNumber = 0;
    private byte[] reasonPhrase = null;

    public ErrorCodeAttribute() {
        super('\t');
    }

    public byte getErrorClass() {
        return this.errorClass;
    }

    public void setErrorClass(byte errorClass) throws IllegalArgumentException {
        if (errorClass < 0 || errorClass > 99) {
            throw new IllegalArgumentException(errorClass + "Only error classes between 0 and 99 are valid. Current class: " + errorClass);
        }
        this.errorClass = errorClass;
    }

    public byte getErrorNumber() {
        return this.errorNumber;
    }

    public void setErrorNumber(byte errorNumber) {
        this.errorNumber = errorNumber;
    }

    public void setErrorCode(char code) {
        this.setErrorClass((byte)(code / 100));
        this.setErrorNumber((byte)(code % 100));
    }

    public char getErrorCode() {
        return (char)(this.getErrorClass() * 100 + this.getErrorNumber());
    }

    public static String getDefaultReasonPhrase(char errorCode) {
        switch (errorCode) {
            case '\u0190': {
                return "(Bad Request): The request was malformed.  The client should not retry the request without modification from the previous attempt.";
            }
            case '\u0191': {
                return "(Unauthorized): The Binding Request did not contain a MESSAGE-INTEGRITY attribute.";
            }
            case '\u01a4': {
                return "(Unknown Attribute): The server did not understand a mandatory attribute in the request.";
            }
            case '\u01ae': {
                return "(Stale Credentials): The Binding Request did contain a MESSAGE-INTEGRITY attribute, but it used a shared secret that has expired.  The client should obtain a new shared secret and tryagain";
            }
            case '\u01af': {
                return "(Integrity Check Failure): The Binding Request contained a MESSAGE-INTEGRITY attribute, but the HMAC failed verification. This could be a sign of a potential attack, or client implementation error.";
            }
            case '\u01b0': {
                return "(Missing Username): The Binding Request contained a MESSAGE-INTEGRITY attribute, but not a USERNAME attribute.  Both must bepresent for integrity checks.";
            }
            case '\u01b1': {
                return "(Use TLS): The Shared Secret request has to be sent over TLS, butwas not received over TLS.";
            }
            case '\u01f4': {
                return "(Server Error): The server has suffered a temporary error. Theclient should try again.";
            }
            case '\u0258': {
                return "(Global Failure:) The server is refusing to fulfill the request.The client should not retry.";
            }
        }
        return "Unknown Error";
    }

    public void setReasonPhrase(String reason) {
        this.reasonPhrase = reason.getBytes();
    }

    public byte[] getReasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    public char getDataLength() {
        char len = (char)(4 + (char)(this.reasonPhrase == null ? 0 : this.reasonPhrase.length));
        return len;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof ErrorCodeAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ErrorCodeAttribute att = (ErrorCodeAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.getErrorClass() == this.getErrorClass() && att.getErrorNumber() == this.getErrorNumber() && (att.getReasonPhrase() == null || att.getReasonPhrase().equals(this.getReasonPhrase()));
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[4 + this.getDataLength() + (4 - this.getDataLength() % 4) % 4];
        binValue[0] = (byte)(this.getAttributeType() >> 8);
        binValue[1] = (byte)(this.getAttributeType() & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        binValue[4] = 0;
        binValue[5] = 0;
        binValue[6] = this.getErrorClass();
        binValue[7] = this.getErrorNumber();
        if (this.reasonPhrase != null) {
            System.arraycopy(this.reasonPhrase, 0, binValue, 8, this.reasonPhrase.length);
        }
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        char c = offset = (char)(offset + 2);
        offset = (char)(offset + '\u0001');
        this.setErrorClass(data[c]);
        char c2 = offset;
        offset = (char)(offset + '\u0001');
        this.setErrorNumber(data[c2]);
        byte[] reasonBytes = new byte[length - 4];
        System.arraycopy(data, offset, reasonBytes, 0, reasonBytes.length);
        this.setReasonPhrase(new String(reasonBytes));
    }
}

