/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.general;

import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;

public class ChannelNumberAttribute
extends StunAttribute {
    public static final String NAME = "CHANNEL-NUMBER";
    public static final char DATA_LENGTH = '\u0004';
    private char channelNumber = '\u0000';

    public ChannelNumberAttribute() {
        super('\f');
    }

    public char getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(char channelNumber) {
        this.channelNumber = channelNumber;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof ChannelNumberAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ChannelNumberAttribute att = (ChannelNumberAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.channelNumber == this.channelNumber;
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), (byte)(this.channelNumber >> 8 & 0xFF), (byte)(this.channelNumber & 0xFF), 0, 0};
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("Invalid Length: " + length + ". Should be: " + 4);
        }
        this.channelNumber = (char)(data[0] << 8 | data[1] & 0xFF);
    }
}

