/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.data;

import java.util.Arrays;
import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;

public class DataAttribute
extends StunAttribute {
    public static final String NAME = "DATA";
    private byte[] data = null;
    private boolean padding;

    public DataAttribute() {
        this(true);
    }

    public DataAttribute(boolean padding) {
        super('\u0013');
        this.padding = padding;
    }

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        return (byte[])this.data.clone();
    }

    public void setData(byte[] data) {
        if (data == null) {
            this.data = null;
        } else {
            this.data = new byte[data.length];
            System.arraycopy(data, 0, this.data, 0, data.length);
        }
    }

    @Override
    public char getDataLength() {
        return (char)this.data.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof DataAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        DataAttribute att = (DataAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.data, this.data);
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + (this.padding ? this.getDataLength() % 4 : 0)];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.data, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        this.data = new byte[length];
        System.arraycopy(data, offset, this.data, 0, length);
    }
}

