/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.address;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.mobicents.media.io.stun.messages.StunMessage;
import org.mobicents.media.io.stun.messages.attributes.address.AddressAttribute;
import org.mobicents.media.server.io.network.TransportAddress;

public class XorMappedAddressAttribute
extends AddressAttribute {
    public static final String NAME = "XOR-MAPPED-ADDRESS";

    public XorMappedAddressAttribute() {
        super(' ');
    }

    protected XorMappedAddressAttribute(char type) {
        super(type);
    }

    public static TransportAddress applyXor(TransportAddress address, byte[] transactionID) {
        byte[] addressBytes = address.getAddressBytes();
        char port = (char)address.getPort();
        char portModifier = (char)(transactionID[0] << 8 & 0xFF00 | transactionID[1] & 0xFF);
        port = (char)(port ^ portModifier);
        for (int i = 0; i < addressBytes.length; ++i) {
            int n = i;
            addressBytes[n] = (byte)(addressBytes[n] ^ transactionID[i]);
        }
        try {
            TransportAddress xoredAdd = new TransportAddress(InetAddress.getByAddress(addressBytes), (int)port, TransportAddress.TransportProtocol.UDP);
            return xoredAdd;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public TransportAddress getAddress(byte[] transactionID) {
        byte[] xorMask = new byte[16];
        System.arraycopy(StunMessage.MAGIC_COOKIE, 0, xorMask, 0, 4);
        System.arraycopy(transactionID, 0, xorMask, 4, 12);
        return this.applyXor(xorMask);
    }

    public TransportAddress applyXor(byte[] xorMask) {
        return XorMappedAddressAttribute.applyXor(this.getAddress(), xorMask);
    }

    public void setAddress(TransportAddress address, byte[] transactionID) {
        byte[] xorMask = new byte[16];
        System.arraycopy(StunMessage.MAGIC_COOKIE, 0, xorMask, 0, 4);
        System.arraycopy(transactionID, 0, xorMask, 4, 12);
        TransportAddress xorAddress = XorMappedAddressAttribute.applyXor(address, xorMask);
        super.setAddress(xorAddress);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

