/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages.attributes.address;

import org.mobicents.media.io.stun.StunException;
import org.mobicents.media.io.stun.messages.attributes.StunAttribute;
import org.mobicents.media.server.io.network.TransportAddress;

public abstract class AddressAttribute
extends StunAttribute {
    protected static final byte ADDRESS_FAMILY_IPV4 = 1;
    protected static final byte ADDRESS_FAMILY_IPV6 = 2;
    private static final char DATA_LENGTH_FOR_IPV4 = '\b';
    private static final char DATA_LENGTH_FOR_IPV6 = '\u0014';
    protected TransportAddress transportAddress;

    protected AddressAttribute(char attributeType) {
        super(attributeType);
        if (!this.isTypeValid(attributeType)) {
            throw new IllegalArgumentException("Invalid STUN attribut type: " + attributeType);
        }
    }

    private boolean isTypeValid(char type) {
        return type == '\u0001' || type == '\u0002' || type == '\u0004' || type == '\u0005' || type == '\u000b' || type == ' ' || type == '\u8023' || type == '\u0012' || type == '\u0016' || type == '\u0011';
    }

    @Override
    protected void setAttributeType(char type) {
        if (!this.isTypeValid(type)) {
            throw new IllegalArgumentException("Invalid STUN attribut type: " + type);
        }
        super.setAttributeType(type);
    }

    public TransportAddress getAddress() {
        return this.transportAddress;
    }

    public void setAddress(TransportAddress address) {
        this.transportAddress = address;
    }

    public int getPort() {
        return this.transportAddress.getPort();
    }

    public byte[] getAddressBytes() {
        return this.transportAddress.getAddressBytes();
    }

    public byte getFamily() {
        if (this.transportAddress.isIPv4()) {
            return 1;
        }
        return 2;
    }

    @Override
    public char getDataLength() {
        if (this.getFamily() == 1) {
            return '\b';
        }
        return '\u0014';
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        binValue[4] = 0;
        binValue[5] = this.getFamily();
        binValue[6] = (byte)(this.getPort() >> 8);
        binValue[7] = (byte)(this.getPort() & 0xFF);
        if (this.transportAddress.isIPv4()) {
            System.arraycopy(this.getAddressBytes(), 0, binValue, 8, 4);
        } else {
            System.arraycopy(this.getAddressBytes(), 0, binValue, 8, 16);
        }
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        char c = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        byte family = attributeValue[c];
        char c2 = offset;
        char c3 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        char port = (char)(attributeValue[c2] << 8 | attributeValue[c3] & 0xFF);
        int addressLength = family == 1 ? 4 : 16;
        byte[] addressData = new byte[addressLength];
        System.arraycopy(attributeValue, offset, addressData, 0, addressLength);
        TransportAddress address = new TransportAddress(new String(addressData), (int)port, TransportAddress.TransportProtocol.UDP);
        this.setAddress(address);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof AddressAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        AddressAttribute att = (AddressAttribute)other;
        if (att.getAttributeType() != this.getAttributeType() || att.getDataLength() != this.getDataLength() || att.getFamily() != this.getFamily() || att.getAddress() != null && !this.transportAddress.equals((Object)att.getAddress())) {
            return false;
        }
        if (att.getAddress() == null && this.getAddress() == null) {
            return true;
        }
        return true;
    }
}

