/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.stun.messages;

import java.util.Arrays;
import java.util.Random;

public class StunTransactionId {
    public static final int DATA_LENGTH = 12;
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private final byte[] value = new byte[12];
    private int hashCode = 0;

    protected StunTransactionId() {
        this.generateValue();
        this.generateHashCode();
    }

    private void generateValue() {
        long left = System.currentTimeMillis();
        long right = RANDOM.nextLong();
        int b = 6;
        for (int i = 0; i < b; ++i) {
            this.value[i] = (byte)(left >> i * 8 & 0xFFL);
            this.value[i + b] = (byte)(right >> i * 8 & 0xFFL);
        }
    }

    private int generateHashCode() {
        return this.value[3] << 24 & 0xFF000000 | this.value[2] << 16 & 0xFF0000 | this.value[1] << 8 & 0xFF00 | this.value[0] & 0xFF;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof StunTransactionId)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        byte[] otherValue = ((StunTransactionId)other).value;
        return Arrays.equals(this.value, otherValue);
    }

    public boolean equals(byte[] other) {
        return Arrays.equals(this.value, other);
    }

    public String toString() {
        StringBuilder idStr = new StringBuilder("0x");
        for (int i = 0; i < this.value.length; ++i) {
            if ((this.value[i] & 0xFF) <= 15) {
                idStr.append("0");
            }
            idStr.append(Integer.toHexString(this.value[i] & 0xFF).toUpperCase());
        }
        return idStr.toString();
    }

    public static String readableFormat(byte[] transactionId) {
        StringBuilder idStr = new StringBuilder("0x");
        for (int i = 0; i < transactionId.length; ++i) {
            if ((transactionId[i] & 0xFF) <= 15) {
                idStr.append("0");
            }
            idStr.append(Integer.toHexString(transactionId[i] & 0xFF).toUpperCase());
        }
        return idStr.toString();
    }
}

