/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.render;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.render.ValueRenderer;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class StringRenderer
extends ValueRenderer {
    public StringRenderer(ExpressionType type) {
        super(type);
    }

    @Override
    public List<String> render(VariableSpec varspec, VariableValue value) throws URITemplateException {
        return ImmutableList.of((Object)this.doRender(varspec, value.getScalarValue()));
    }

    private String doRender(VariableSpec varspec, String value) {
        String ret = "";
        if (this.named) {
            ret = ret + varspec.getName();
            if (value.isEmpty()) {
                return ret + this.ifEmpty;
            }
            ret = ret + '=';
        }
        int len = value.length();
        int prefixLen = varspec.getPrefixLength();
        String val = prefixLen == -1 ? value : value.substring(0, Math.min(len, prefixLen));
        ret = ret + this.pctEncode(val);
        return ret;
    }
}

