/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static ClassLoader setContextClassLoader(final ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            return result;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    try {
                        ClassLoader result = Thread.currentThread().getContextClassLoader();
                        if (cl != null) {
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        return result;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

